package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelPipeline invokes the devops_rdc.CancelPipeline API synchronously
func (client *Client) CancelPipeline(request *CancelPipelineRequest) (response *CancelPipelineResponse, err error) {
	response = CreateCancelPipelineResponse()
	err = client.DoAction(request, response)
	return
}

// CancelPipelineWithChan invokes the devops_rdc.CancelPipeline API asynchronously
func (client *Client) CancelPipelineWithChan(request *CancelPipelineRequest) (<-chan *CancelPipelineResponse, <-chan error) {
	responseChan := make(chan *CancelPipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelPipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelPipelineWithCallback invokes the devops_rdc.CancelPipeline API asynchronously
func (client *Client) CancelPipelineWithCallback(request *CancelPipelineRequest, callback func(response *CancelPipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelPipelineResponse
		var err error
		defer close(result)
		response, err = client.CancelPipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelPipelineRequest is the request struct for api CancelPipeline
type CancelPipelineRequest struct {
	*requests.RpcRequest
	FlowInstanceId requests.Integer `position:"Body" name:"FlowInstanceId"`
	UserPk         string           `position:"Body" name:"UserPk"`
	OrgId          string           `position:"Body" name:"OrgId"`
	PipelineId     requests.Integer `position:"Body" name:"PipelineId"`
}

// CancelPipelineResponse is the response struct for api CancelPipeline
type CancelPipelineResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Object       bool   `json:"Object" xml:"Object"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelPipelineRequest creates a request to invoke CancelPipeline API
func CreateCancelPipelineRequest() (request *CancelPipelineRequest) {
	request = &CancelPipelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CancelPipeline", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelPipelineResponse creates a response to parse from CancelPipeline response
func CreateCancelPipelineResponse() (response *CancelPipelineResponse) {
	response = &CancelPipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
