package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySecretNoDetail invokes the dyplsapi.QuerySecretNoDetail API synchronously
func (client *Client) QuerySecretNoDetail(request *QuerySecretNoDetailRequest) (response *QuerySecretNoDetailResponse, err error) {
	response = CreateQuerySecretNoDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySecretNoDetailWithChan invokes the dyplsapi.QuerySecretNoDetail API asynchronously
func (client *Client) QuerySecretNoDetailWithChan(request *QuerySecretNoDetailRequest) (<-chan *QuerySecretNoDetailResponse, <-chan error) {
	responseChan := make(chan *QuerySecretNoDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySecretNoDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySecretNoDetailWithCallback invokes the dyplsapi.QuerySecretNoDetail API asynchronously
func (client *Client) QuerySecretNoDetailWithCallback(request *QuerySecretNoDetailRequest, callback func(response *QuerySecretNoDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySecretNoDetailResponse
		var err error
		defer close(result)
		response, err = client.QuerySecretNoDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySecretNoDetailRequest is the request struct for api QuerySecretNoDetail
type QuerySecretNoDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// QuerySecretNoDetailResponse is the response struct for api QuerySecretNoDetail
type QuerySecretNoDetailResponse struct {
	*responses.BaseResponse
	Code            string          `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecretNoInfoDTO SecretNoInfoDTO `json:"SecretNoInfoDTO" xml:"SecretNoInfoDTO"`
}

// CreateQuerySecretNoDetailRequest creates a request to invoke QuerySecretNoDetail API
func CreateQuerySecretNoDetailRequest() (request *QuerySecretNoDetailRequest) {
	request = &QuerySecretNoDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "QuerySecretNoDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySecretNoDetailResponse creates a response to parse from QuerySecretNoDetail response
func CreateQuerySecretNoDetailResponse() (response *QuerySecretNoDetailResponse) {
	response = &QuerySecretNoDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
