package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowClusterAll invokes the emr.ListFlowClusterAll API synchronously
func (client *Client) ListFlowClusterAll(request *ListFlowClusterAllRequest) (response *ListFlowClusterAllResponse, err error) {
	response = CreateListFlowClusterAllResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowClusterAllWithChan invokes the emr.ListFlowClusterAll API asynchronously
func (client *Client) ListFlowClusterAllWithChan(request *ListFlowClusterAllRequest) (<-chan *ListFlowClusterAllResponse, <-chan error) {
	responseChan := make(chan *ListFlowClusterAllResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowClusterAll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowClusterAllWithCallback invokes the emr.ListFlowClusterAll API asynchronously
func (client *Client) ListFlowClusterAllWithCallback(request *ListFlowClusterAllRequest, callback func(response *ListFlowClusterAllResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowClusterAllResponse
		var err error
		defer close(result)
		response, err = client.ListFlowClusterAll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowClusterAllRequest is the request struct for api ListFlowClusterAll
type ListFlowClusterAllRequest struct {
	*requests.RpcRequest
	ProductType     string `position:"Query" name:"ProductType"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
}

// ListFlowClusterAllResponse is the response struct for api ListFlowClusterAll
type ListFlowClusterAllResponse struct {
	*responses.BaseResponse
	RequestId  string                       `json:"RequestId" xml:"RequestId"`
	TotalCount int                          `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                          `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                          `json:"PageSize" xml:"PageSize"`
	Clusters   ClustersInListFlowClusterAll `json:"Clusters" xml:"Clusters"`
}

// CreateListFlowClusterAllRequest creates a request to invoke ListFlowClusterAll API
func CreateListFlowClusterAllRequest() (request *ListFlowClusterAllRequest) {
	request = &ListFlowClusterAllRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowClusterAll", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFlowClusterAllResponse creates a response to parse from ListFlowClusterAll response
func CreateListFlowClusterAllResponse() (response *ListFlowClusterAllResponse) {
	response = &ListFlowClusterAllResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
