package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateForwardingRules invokes the ga.CreateForwardingRules API synchronously
func (client *Client) CreateForwardingRules(request *CreateForwardingRulesRequest) (response *CreateForwardingRulesResponse, err error) {
	response = CreateCreateForwardingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateForwardingRulesWithChan invokes the ga.CreateForwardingRules API asynchronously
func (client *Client) CreateForwardingRulesWithChan(request *CreateForwardingRulesRequest) (<-chan *CreateForwardingRulesResponse, <-chan error) {
	responseChan := make(chan *CreateForwardingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateForwardingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateForwardingRulesWithCallback invokes the ga.CreateForwardingRules API asynchronously
func (client *Client) CreateForwardingRulesWithCallback(request *CreateForwardingRulesRequest, callback func(response *CreateForwardingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateForwardingRulesResponse
		var err error
		defer close(result)
		response, err = client.CreateForwardingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateForwardingRulesRequest is the request struct for api CreateForwardingRules
type CreateForwardingRulesRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	ListenerId      string `position:"Query" name:"ListenerId"`
	AcceleratorId   string `position:"Query" name:"AcceleratorId"`
	ForwardingRules string `position:"Query" name:"ForwardingRules"`
}

// CreateForwardingRulesResponse is the response struct for api CreateForwardingRules
type CreateForwardingRulesResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	ForwardingRules []ForwardingRulesItem `json:"ForwardingRules" xml:"ForwardingRules"`
}

// CreateCreateForwardingRulesRequest creates a request to invoke CreateForwardingRules API
func CreateCreateForwardingRulesRequest() (request *CreateForwardingRulesRequest) {
	request = &CreateForwardingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "CreateForwardingRules", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateForwardingRulesResponse creates a response to parse from CreateForwardingRules response
func CreateCreateForwardingRulesResponse() (response *CreateForwardingRulesResponse) {
	response = &CreateForwardingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
