package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectKneeXRay invokes the imageprocess.DetectKneeXRay API synchronously
func (client *Client) DetectKneeXRay(request *DetectKneeXRayRequest) (response *DetectKneeXRayResponse, err error) {
	response = CreateDetectKneeXRayResponse()
	err = client.DoAction(request, response)
	return
}

// DetectKneeXRayWithChan invokes the imageprocess.DetectKneeXRay API asynchronously
func (client *Client) DetectKneeXRayWithChan(request *DetectKneeXRayRequest) (<-chan *DetectKneeXRayResponse, <-chan error) {
	responseChan := make(chan *DetectKneeXRayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectKneeXRay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectKneeXRayWithCallback invokes the imageprocess.DetectKneeXRay API asynchronously
func (client *Client) DetectKneeXRayWithCallback(request *DetectKneeXRayRequest, callback func(response *DetectKneeXRayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectKneeXRayResponse
		var err error
		defer close(result)
		response, err = client.DetectKneeXRay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectKneeXRayRequest is the request struct for api DetectKneeXRay
type DetectKneeXRayRequest struct {
	*requests.RpcRequest
	DataFormat string `position:"Body" name:"DataFormat"`
	Url        string `position:"Body" name:"Url"`
	OrgId      string `position:"Body" name:"OrgId"`
	OrgName    string `position:"Body" name:"OrgName"`
}

// DetectKneeXRayResponse is the response struct for api DetectKneeXRay
type DetectKneeXRayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectKneeXRayRequest creates a request to invoke DetectKneeXRay API
func CreateDetectKneeXRayRequest() (request *DetectKneeXRayRequest) {
	request = &DetectKneeXRayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectKneeXRay", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectKneeXRayResponse creates a response to parse from DetectKneeXRay response
func CreateDetectKneeXRayResponse() (response *DetectKneeXRayResponse) {
	response = &DetectKneeXRayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
