package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelOTATaskByDevice invokes the iot.CancelOTATaskByDevice API synchronously
func (client *Client) CancelOTATaskByDevice(request *CancelOTATaskByDeviceRequest) (response *CancelOTATaskByDeviceResponse, err error) {
	response = CreateCancelOTATaskByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// CancelOTATaskByDeviceWithChan invokes the iot.CancelOTATaskByDevice API asynchronously
func (client *Client) CancelOTATaskByDeviceWithChan(request *CancelOTATaskByDeviceRequest) (<-chan *CancelOTATaskByDeviceResponse, <-chan error) {
	responseChan := make(chan *CancelOTATaskByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelOTATaskByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelOTATaskByDeviceWithCallback invokes the iot.CancelOTATaskByDevice API asynchronously
func (client *Client) CancelOTATaskByDeviceWithCallback(request *CancelOTATaskByDeviceRequest, callback func(response *CancelOTATaskByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelOTATaskByDeviceResponse
		var err error
		defer close(result)
		response, err = client.CancelOTATaskByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelOTATaskByDeviceRequest is the request struct for api CancelOTATaskByDevice
type CancelOTATaskByDeviceRequest struct {
	*requests.RpcRequest
	JobId         string    `position:"Query" name:"JobId"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	FirmwareId    string    `position:"Query" name:"FirmwareId"`
	ProductKey    string    `position:"Query" name:"ProductKey"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	DeviceName    *[]string `position:"Query" name:"DeviceName"  type:"Repeated"`
}

// CancelOTATaskByDeviceResponse is the response struct for api CancelOTATaskByDevice
type CancelOTATaskByDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateCancelOTATaskByDeviceRequest creates a request to invoke CancelOTATaskByDevice API
func CreateCancelOTATaskByDeviceRequest() (request *CancelOTATaskByDeviceRequest) {
	request = &CancelOTATaskByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CancelOTATaskByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelOTATaskByDeviceResponse creates a response to parse from CancelOTATaskByDevice response
func CreateCancelOTATaskByDeviceResponse() (response *CancelOTATaskByDeviceResponse) {
	response = &CancelOTATaskByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
