package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegisterBoxNumber invokes the itaas.GetRegisterBoxNumber API synchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxnumber.html
func (client *Client) GetRegisterBoxNumber(request *GetRegisterBoxNumberRequest) (response *GetRegisterBoxNumberResponse, err error) {
	response = CreateGetRegisterBoxNumberResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegisterBoxNumberWithChan invokes the itaas.GetRegisterBoxNumber API asynchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRegisterBoxNumberWithChan(request *GetRegisterBoxNumberRequest) (<-chan *GetRegisterBoxNumberResponse, <-chan error) {
	responseChan := make(chan *GetRegisterBoxNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegisterBoxNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegisterBoxNumberWithCallback invokes the itaas.GetRegisterBoxNumber API asynchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRegisterBoxNumberWithCallback(request *GetRegisterBoxNumberRequest, callback func(response *GetRegisterBoxNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegisterBoxNumberResponse
		var err error
		defer close(result)
		response, err = client.GetRegisterBoxNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegisterBoxNumberRequest is the request struct for api GetRegisterBoxNumber
type GetRegisterBoxNumberRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// GetRegisterBoxNumberResponse is the response struct for api GetRegisterBoxNumber
type GetRegisterBoxNumberResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	ErrorCode int                             `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                          `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                            `json:"Success" xml:"Success"`
	Data      Data                            `json:"Data" xml:"Data"`
	ErrorList ErrorListInGetRegisterBoxNumber `json:"ErrorList" xml:"ErrorList"`
}

// CreateGetRegisterBoxNumberRequest creates a request to invoke GetRegisterBoxNumber API
func CreateGetRegisterBoxNumberRequest() (request *GetRegisterBoxNumberRequest) {
	request = &GetRegisterBoxNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "GetRegisterBoxNumber", "itaas", "openAPI")
	return
}

// CreateGetRegisterBoxNumberResponse creates a response to parse from GetRegisterBoxNumber response
func CreateGetRegisterBoxNumberResponse() (response *GetRegisterBoxNumberResponse) {
	response = &GetRegisterBoxNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
