package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTagMiddle invokes the oam.AddTagMiddle API synchronously
// api document: https://help.aliyun.com/api/oam/addtagmiddle.html
func (client *Client) AddTagMiddle(request *AddTagMiddleRequest) (response *AddTagMiddleResponse, err error) {
	response = CreateAddTagMiddleResponse()
	err = client.DoAction(request, response)
	return
}

// AddTagMiddleWithChan invokes the oam.AddTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/addtagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTagMiddleWithChan(request *AddTagMiddleRequest) (<-chan *AddTagMiddleResponse, <-chan error) {
	responseChan := make(chan *AddTagMiddleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTagMiddle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTagMiddleWithCallback invokes the oam.AddTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/addtagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTagMiddleWithCallback(request *AddTagMiddleRequest, callback func(response *AddTagMiddleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTagMiddleResponse
		var err error
		defer close(result)
		response, err = client.AddTagMiddle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTagMiddleRequest is the request struct for api AddTagMiddle
type AddTagMiddleRequest struct {
	*requests.RpcRequest
	MutexTagMiddle *[]AddTagMiddleMutexTagMiddle `position:"Query" name:"MutexTagMiddle"  type:"Repeated"`
	ClientToken    string                        `position:"Query" name:"ClientToken"`
}

// AddTagMiddleMutexTagMiddle is a repeated param struct in AddTagMiddleRequest
type AddTagMiddleMutexTagMiddle struct {
	TagId      string `name:"TagId"`
	RoleCellId string `name:"RoleCellId"`
	Type       string `name:"Type"`
}

// AddTagMiddleResponse is the response struct for api AddTagMiddle
type AddTagMiddleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTagMiddleRequest creates a request to invoke AddTagMiddle API
func CreateAddTagMiddleRequest() (request *AddTagMiddleRequest) {
	request = &AddTagMiddleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "AddTagMiddle", "", "")
	request.Method = requests.POST
	return
}

// CreateAddTagMiddleResponse creates a response to parse from AddTagMiddle response
func CreateAddTagMiddleResponse() (response *AddTagMiddleResponse) {
	response = &AddTagMiddleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
