package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListABTestScenes invokes the opensearch.ListABTestScenes API synchronously
func (client *Client) ListABTestScenes(request *ListABTestScenesRequest) (response *ListABTestScenesResponse, err error) {
	response = CreateListABTestScenesResponse()
	err = client.DoAction(request, response)
	return
}

// ListABTestScenesWithChan invokes the opensearch.ListABTestScenes API asynchronously
func (client *Client) ListABTestScenesWithChan(request *ListABTestScenesRequest) (<-chan *ListABTestScenesResponse, <-chan error) {
	responseChan := make(chan *ListABTestScenesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListABTestScenes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListABTestScenesWithCallback invokes the opensearch.ListABTestScenes API asynchronously
func (client *Client) ListABTestScenesWithCallback(request *ListABTestScenesRequest, callback func(response *ListABTestScenesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListABTestScenesResponse
		var err error
		defer close(result)
		response, err = client.ListABTestScenes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListABTestScenesRequest is the request struct for api ListABTestScenes
type ListABTestScenesRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ListABTestScenesResponse is the response struct for api ListABTestScenes
type ListABTestScenesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListABTestScenesRequest creates a request to invoke ListABTestScenes API
func CreateListABTestScenesRequest() (request *ListABTestScenesRequest) {
	request = &ListABTestScenesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListABTestScenes", "/v4/openapi/app-groups/[appGroupIdentity]/scenes", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListABTestScenesResponse creates a response to parse from ListABTestScenes response
func CreateListABTestScenesResponse() (response *ListABTestScenesResponse) {
	response = &ListABTestScenesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
