package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateABTestScene invokes the opensearch.UpdateABTestScene API synchronously
func (client *Client) UpdateABTestScene(request *UpdateABTestSceneRequest) (response *UpdateABTestSceneResponse, err error) {
	response = CreateUpdateABTestSceneResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateABTestSceneWithChan invokes the opensearch.UpdateABTestScene API asynchronously
func (client *Client) UpdateABTestSceneWithChan(request *UpdateABTestSceneRequest) (<-chan *UpdateABTestSceneResponse, <-chan error) {
	responseChan := make(chan *UpdateABTestSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateABTestScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateABTestSceneWithCallback invokes the opensearch.UpdateABTestScene API asynchronously
func (client *Client) UpdateABTestSceneWithCallback(request *UpdateABTestSceneRequest, callback func(response *UpdateABTestSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateABTestSceneResponse
		var err error
		defer close(result)
		response, err = client.UpdateABTestScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateABTestSceneRequest is the request struct for api UpdateABTestScene
type UpdateABTestSceneRequest struct {
	*requests.RoaRequest
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// UpdateABTestSceneResponse is the response struct for api UpdateABTestScene
type UpdateABTestSceneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateUpdateABTestSceneRequest creates a request to invoke UpdateABTestScene API
func CreateUpdateABTestSceneRequest() (request *UpdateABTestSceneRequest) {
	request = &UpdateABTestSceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateABTestScene", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]", "opensearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateABTestSceneResponse creates a response to parse from UpdateABTestScene response
func CreateUpdateABTestSceneResponse() (response *UpdateABTestSceneResponse) {
	response = &UpdateABTestSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
