package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNumberDistrictInfoStatus invokes the outboundbot.DescribeNumberDistrictInfoStatus API synchronously
func (client *Client) DescribeNumberDistrictInfoStatus(request *DescribeNumberDistrictInfoStatusRequest) (response *DescribeNumberDistrictInfoStatusResponse, err error) {
	response = CreateDescribeNumberDistrictInfoStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNumberDistrictInfoStatusWithChan invokes the outboundbot.DescribeNumberDistrictInfoStatus API asynchronously
func (client *Client) DescribeNumberDistrictInfoStatusWithChan(request *DescribeNumberDistrictInfoStatusRequest) (<-chan *DescribeNumberDistrictInfoStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeNumberDistrictInfoStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNumberDistrictInfoStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNumberDistrictInfoStatusWithCallback invokes the outboundbot.DescribeNumberDistrictInfoStatus API asynchronously
func (client *Client) DescribeNumberDistrictInfoStatusWithCallback(request *DescribeNumberDistrictInfoStatusRequest, callback func(response *DescribeNumberDistrictInfoStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNumberDistrictInfoStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeNumberDistrictInfoStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNumberDistrictInfoStatusRequest is the request struct for api DescribeNumberDistrictInfoStatus
type DescribeNumberDistrictInfoStatusRequest struct {
	*requests.RpcRequest
}

// DescribeNumberDistrictInfoStatusResponse is the response struct for api DescribeNumberDistrictInfoStatus
type DescribeNumberDistrictInfoStatusResponse struct {
	*responses.BaseResponse
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Status         string         `json:"Status" xml:"Status"`
	AppliedVersion AppliedVersion `json:"AppliedVersion" xml:"AppliedVersion"`
	ParsingVersion ParsingVersion `json:"ParsingVersion" xml:"ParsingVersion"`
}

// CreateDescribeNumberDistrictInfoStatusRequest creates a request to invoke DescribeNumberDistrictInfoStatus API
func CreateDescribeNumberDistrictInfoStatusRequest() (request *DescribeNumberDistrictInfoStatusRequest) {
	request = &DescribeNumberDistrictInfoStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeNumberDistrictInfoStatus", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNumberDistrictInfoStatusResponse creates a response to parse from DescribeNumberDistrictInfoStatus response
func CreateDescribeNumberDistrictInfoStatusResponse() (response *DescribeNumberDistrictInfoStatusResponse) {
	response = &DescribeNumberDistrictInfoStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
