package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitRecording invokes the outboundbot.SubmitRecording API synchronously
func (client *Client) SubmitRecording(request *SubmitRecordingRequest) (response *SubmitRecordingResponse, err error) {
	response = CreateSubmitRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitRecordingWithChan invokes the outboundbot.SubmitRecording API asynchronously
func (client *Client) SubmitRecordingWithChan(request *SubmitRecordingRequest) (<-chan *SubmitRecordingResponse, <-chan error) {
	responseChan := make(chan *SubmitRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitRecordingWithCallback invokes the outboundbot.SubmitRecording API asynchronously
func (client *Client) SubmitRecordingWithCallback(request *SubmitRecordingRequest, callback func(response *SubmitRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitRecordingResponse
		var err error
		defer close(result)
		response, err = client.SubmitRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitRecordingRequest is the request struct for api SubmitRecording
type SubmitRecordingRequest struct {
	*requests.RpcRequest
	MergedRecording   string           `position:"Query" name:"MergedRecording"`
	ResourceRecording string           `position:"Query" name:"ResourceRecording"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	InstanceOwnerId   requests.Integer `position:"Query" name:"InstanceOwnerId"`
	TaskId            string           `position:"Query" name:"TaskId"`
}

// SubmitRecordingResponse is the response struct for api SubmitRecording
type SubmitRecordingResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateSubmitRecordingRequest creates a request to invoke SubmitRecording API
func CreateSubmitRecordingRequest() (request *SubmitRecordingRequest) {
	request = &SubmitRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "SubmitRecording", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitRecordingResponse creates a response to parse from SubmitRecording response
func CreateSubmitRecordingResponse() (response *SubmitRecordingResponse) {
	response = &SubmitRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
