package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendCall invokes the outboundbot.SuspendCall API synchronously
func (client *Client) SuspendCall(request *SuspendCallRequest) (response *SuspendCallResponse, err error) {
	response = CreateSuspendCallResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendCallWithChan invokes the outboundbot.SuspendCall API asynchronously
func (client *Client) SuspendCallWithChan(request *SuspendCallRequest) (<-chan *SuspendCallResponse, <-chan error) {
	responseChan := make(chan *SuspendCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendCallWithCallback invokes the outboundbot.SuspendCall API asynchronously
func (client *Client) SuspendCallWithCallback(request *SuspendCallRequest, callback func(response *SuspendCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendCallResponse
		var err error
		defer close(result)
		response, err = client.SuspendCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendCallRequest is the request struct for api SuspendCall
type SuspendCallRequest struct {
	*requests.RpcRequest
	GroupId       string    `position:"Query" name:"GroupId"`
	CalledNumbers *[]string `position:"Query" name:"CalledNumbers"  type:"Repeated"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
}

// SuspendCallResponse is the response struct for api SuspendCall
type SuspendCallResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateSuspendCallRequest creates a request to invoke SuspendCall API
func CreateSuspendCallRequest() (request *SuspendCallRequest) {
	request = &SuspendCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "SuspendCall", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSuspendCallResponse creates a response to parse from SuspendCall response
func CreateSuspendCallResponse() (response *SuspendCallResponse) {
	response = &SuspendCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
