package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResolverRule invokes the pvtz.UpdateResolverRule API synchronously
func (client *Client) UpdateResolverRule(request *UpdateResolverRuleRequest) (response *UpdateResolverRuleResponse, err error) {
	response = CreateUpdateResolverRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResolverRuleWithChan invokes the pvtz.UpdateResolverRule API asynchronously
func (client *Client) UpdateResolverRuleWithChan(request *UpdateResolverRuleRequest) (<-chan *UpdateResolverRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateResolverRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResolverRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResolverRuleWithCallback invokes the pvtz.UpdateResolverRule API asynchronously
func (client *Client) UpdateResolverRuleWithCallback(request *UpdateResolverRuleRequest, callback func(response *UpdateResolverRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResolverRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateResolverRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResolverRuleRequest is the request struct for api UpdateResolverRule
type UpdateResolverRuleRequest struct {
	*requests.RpcRequest
	ForwardIp    *[]UpdateResolverRuleForwardIp `position:"Query" name:"ForwardIp"  type:"Repeated"`
	UserClientIp string                         `position:"Query" name:"UserClientIp"`
	Name         string                         `position:"Query" name:"Name"`
	Lang         string                         `position:"Query" name:"Lang"`
	RuleId       string                         `position:"Query" name:"RuleId"`
}

// UpdateResolverRuleForwardIp is a repeated param struct in UpdateResolverRuleRequest
type UpdateResolverRuleForwardIp struct {
	Port string `name:"Port"`
	Ip   string `name:"Ip"`
}

// UpdateResolverRuleResponse is the response struct for api UpdateResolverRule
type UpdateResolverRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateResolverRuleRequest creates a request to invoke UpdateResolverRule API
func CreateUpdateResolverRuleRequest() (request *UpdateResolverRuleRequest) {
	request = &UpdateResolverRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "UpdateResolverRule", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateResolverRuleResponse creates a response to parse from UpdateResolverRule response
func CreateUpdateResolverRuleResponse() (response *UpdateResolverRuleResponse) {
	response = &UpdateResolverRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
