package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDatasetDetailInfo invokes the quickbi_public.QueryDatasetDetailInfo API synchronously
func (client *Client) QueryDatasetDetailInfo(request *QueryDatasetDetailInfoRequest) (response *QueryDatasetDetailInfoResponse, err error) {
	response = CreateQueryDatasetDetailInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDatasetDetailInfoWithChan invokes the quickbi_public.QueryDatasetDetailInfo API asynchronously
func (client *Client) QueryDatasetDetailInfoWithChan(request *QueryDatasetDetailInfoRequest) (<-chan *QueryDatasetDetailInfoResponse, <-chan error) {
	responseChan := make(chan *QueryDatasetDetailInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDatasetDetailInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDatasetDetailInfoWithCallback invokes the quickbi_public.QueryDatasetDetailInfo API asynchronously
func (client *Client) QueryDatasetDetailInfoWithCallback(request *QueryDatasetDetailInfoRequest, callback func(response *QueryDatasetDetailInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDatasetDetailInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryDatasetDetailInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDatasetDetailInfoRequest is the request struct for api QueryDatasetDetailInfo
type QueryDatasetDetailInfoRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	DatasetId   string `position:"Query" name:"DatasetId"`
	SignType    string `position:"Query" name:"SignType"`
}

// QueryDatasetDetailInfoResponse is the response struct for api QueryDatasetDetailInfo
type QueryDatasetDetailInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryDatasetDetailInfoRequest creates a request to invoke QueryDatasetDetailInfo API
func CreateQueryDatasetDetailInfoRequest() (request *QueryDatasetDetailInfoRequest) {
	request = &QueryDatasetDetailInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-06", "QueryDatasetDetailInfo", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDatasetDetailInfoResponse creates a response to parse from QueryDatasetDetailInfo response
func CreateQueryDatasetDetailInfoResponse() (response *QueryDatasetDetailInfoResponse) {
	response = &QueryDatasetDetailInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
