package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApproveJoinCompany invokes the rdc.ApproveJoinCompany API synchronously
// api document: https://help.aliyun.com/api/rdc/approvejoincompany.html
func (client *Client) ApproveJoinCompany(request *ApproveJoinCompanyRequest) (response *ApproveJoinCompanyResponse, err error) {
	response = CreateApproveJoinCompanyResponse()
	err = client.DoAction(request, response)
	return
}

// ApproveJoinCompanyWithChan invokes the rdc.ApproveJoinCompany API asynchronously
// api document: https://help.aliyun.com/api/rdc/approvejoincompany.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApproveJoinCompanyWithChan(request *ApproveJoinCompanyRequest) (<-chan *ApproveJoinCompanyResponse, <-chan error) {
	responseChan := make(chan *ApproveJoinCompanyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApproveJoinCompany(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApproveJoinCompanyWithCallback invokes the rdc.ApproveJoinCompany API asynchronously
// api document: https://help.aliyun.com/api/rdc/approvejoincompany.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApproveJoinCompanyWithCallback(request *ApproveJoinCompanyRequest, callback func(response *ApproveJoinCompanyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApproveJoinCompanyResponse
		var err error
		defer close(result)
		response, err = client.ApproveJoinCompany(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApproveJoinCompanyRequest is the request struct for api ApproveJoinCompany
type ApproveJoinCompanyRequest struct {
	*requests.RpcRequest
	CorpIdentifier string `position:"Query" name:"CorpIdentifier"`
	ApplicationIds string `position:"Body" name:"ApplicationIds"`
}

// ApproveJoinCompanyResponse is the response struct for api ApproveJoinCompany
type ApproveJoinCompanyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateApproveJoinCompanyRequest creates a request to invoke ApproveJoinCompany API
func CreateApproveJoinCompanyRequest() (request *ApproveJoinCompanyRequest) {
	request = &ApproveJoinCompanyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "ApproveJoinCompany", "rdc", "openAPI")
	return
}

// CreateApproveJoinCompanyResponse creates a response to parse from ApproveJoinCompany response
func CreateApproveJoinCompanyResponse() (response *ApproveJoinCompanyResponse) {
	response = &ApproveJoinCompanyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
