package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceAntiBruteForceRule invokes the sas.ModifyInstanceAntiBruteForceRule API synchronously
func (client *Client) ModifyInstanceAntiBruteForceRule(request *ModifyInstanceAntiBruteForceRuleRequest) (response *ModifyInstanceAntiBruteForceRuleResponse, err error) {
	response = CreateModifyInstanceAntiBruteForceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceAntiBruteForceRuleWithChan invokes the sas.ModifyInstanceAntiBruteForceRule API asynchronously
func (client *Client) ModifyInstanceAntiBruteForceRuleWithChan(request *ModifyInstanceAntiBruteForceRuleRequest) (<-chan *ModifyInstanceAntiBruteForceRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceAntiBruteForceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceAntiBruteForceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceAntiBruteForceRuleWithCallback invokes the sas.ModifyInstanceAntiBruteForceRule API asynchronously
func (client *Client) ModifyInstanceAntiBruteForceRuleWithCallback(request *ModifyInstanceAntiBruteForceRuleRequest, callback func(response *ModifyInstanceAntiBruteForceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceAntiBruteForceRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceAntiBruteForceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceAntiBruteForceRuleRequest is the request struct for api ModifyInstanceAntiBruteForceRule
type ModifyInstanceAntiBruteForceRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Uuid            string           `position:"Query" name:"Uuid"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	NewRuleId       requests.Integer `position:"Query" name:"NewRuleId"`
}

// ModifyInstanceAntiBruteForceRuleResponse is the response struct for api ModifyInstanceAntiBruteForceRule
type ModifyInstanceAntiBruteForceRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceAntiBruteForceRuleRequest creates a request to invoke ModifyInstanceAntiBruteForceRule API
func CreateModifyInstanceAntiBruteForceRuleRequest() (request *ModifyInstanceAntiBruteForceRuleRequest) {
	request = &ModifyInstanceAntiBruteForceRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyInstanceAntiBruteForceRule", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceAntiBruteForceRuleResponse creates a response to parse from ModifyInstanceAntiBruteForceRule response
func CreateModifyInstanceAntiBruteForceRuleResponse() (response *ModifyInstanceAntiBruteForceRuleResponse) {
	response = &ModifyInstanceAntiBruteForceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
