package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyStartVulScan invokes the sas.ModifyStartVulScan API synchronously
func (client *Client) ModifyStartVulScan(request *ModifyStartVulScanRequest) (response *ModifyStartVulScanResponse, err error) {
	response = CreateModifyStartVulScanResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyStartVulScanWithChan invokes the sas.ModifyStartVulScan API asynchronously
func (client *Client) ModifyStartVulScanWithChan(request *ModifyStartVulScanRequest) (<-chan *ModifyStartVulScanResponse, <-chan error) {
	responseChan := make(chan *ModifyStartVulScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyStartVulScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyStartVulScanWithCallback invokes the sas.ModifyStartVulScan API asynchronously
func (client *Client) ModifyStartVulScanWithCallback(request *ModifyStartVulScanRequest, callback func(response *ModifyStartVulScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyStartVulScanResponse
		var err error
		defer close(result)
		response, err = client.ModifyStartVulScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyStartVulScanRequest is the request struct for api ModifyStartVulScan
type ModifyStartVulScanRequest struct {
	*requests.RpcRequest
	Types    string `position:"Query" name:"Types"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Uuids    string `position:"Query" name:"Uuids"`
}

// ModifyStartVulScanResponse is the response struct for api ModifyStartVulScan
type ModifyStartVulScanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyStartVulScanRequest creates a request to invoke ModifyStartVulScan API
func CreateModifyStartVulScanRequest() (request *ModifyStartVulScanRequest) {
	request = &ModifyStartVulScanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyStartVulScan", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyStartVulScanResponse creates a response to parse from ModifyStartVulScan response
func CreateModifyStartVulScanResponse() (response *ModifyStartVulScanResponse) {
	response = &ModifyStartVulScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
