package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateQrCode invokes the trademark.GenerateQrCode API synchronously
// api document: https://help.aliyun.com/api/trademark/generateqrcode.html
func (client *Client) GenerateQrCode(request *GenerateQrCodeRequest) (response *GenerateQrCodeResponse, err error) {
	response = CreateGenerateQrCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateQrCodeWithChan invokes the trademark.GenerateQrCode API asynchronously
// api document: https://help.aliyun.com/api/trademark/generateqrcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateQrCodeWithChan(request *GenerateQrCodeRequest) (<-chan *GenerateQrCodeResponse, <-chan error) {
	responseChan := make(chan *GenerateQrCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateQrCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateQrCodeWithCallback invokes the trademark.GenerateQrCode API asynchronously
// api document: https://help.aliyun.com/api/trademark/generateqrcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateQrCodeWithCallback(request *GenerateQrCodeRequest, callback func(response *GenerateQrCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateQrCodeResponse
		var err error
		defer close(result)
		response, err = client.GenerateQrCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateQrCodeRequest is the request struct for api GenerateQrCode
type GenerateQrCodeRequest struct {
	*requests.RpcRequest
	OssKey   string `position:"Query" name:"OssKey"`
	FieldKey string `position:"Query" name:"FieldKey"`
	Uuid     string `position:"Query" name:"Uuid"`
}

// GenerateQrCodeResponse is the response struct for api GenerateQrCode
type GenerateQrCodeResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Uuid       string `json:"Uuid" xml:"Uuid"`
	ExpireTime int64  `json:"ExpireTime" xml:"ExpireTime"`
	QrcodeUrl  string `json:"QrcodeUrl" xml:"QrcodeUrl"`
	FieldKey   string `json:"FieldKey" xml:"FieldKey"`
	Success    bool   `json:"Success" xml:"Success"`
}

// CreateGenerateQrCodeRequest creates a request to invoke GenerateQrCode API
func CreateGenerateQrCodeRequest() (request *GenerateQrCodeRequest) {
	request = &GenerateQrCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "GenerateQrCode", "trademark", "openAPI")
	return
}

// CreateGenerateQrCodeResponse creates a response to parse from GenerateQrCode response
func CreateGenerateQrCodeResponse() (response *GenerateQrCodeResponse) {
	response = &GenerateQrCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
