package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCorpGroups invokes the vcs.ListCorpGroups API synchronously
func (client *Client) ListCorpGroups(request *ListCorpGroupsRequest) (response *ListCorpGroupsResponse, err error) {
	response = CreateListCorpGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCorpGroupsWithChan invokes the vcs.ListCorpGroups API asynchronously
func (client *Client) ListCorpGroupsWithChan(request *ListCorpGroupsRequest) (<-chan *ListCorpGroupsResponse, <-chan error) {
	responseChan := make(chan *ListCorpGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCorpGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCorpGroupsWithCallback invokes the vcs.ListCorpGroups API asynchronously
func (client *Client) ListCorpGroupsWithCallback(request *ListCorpGroupsRequest, callback func(response *ListCorpGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCorpGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListCorpGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCorpGroupsRequest is the request struct for api ListCorpGroups
type ListCorpGroupsRequest struct {
	*requests.RpcRequest
	CorpId     string           `position:"Body" name:"CorpId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// ListCorpGroupsResponse is the response struct for api ListCorpGroups
type ListCorpGroupsResponse struct {
	*responses.BaseResponse
	Code      string               `json:"Code" xml:"Code"`
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Data      DataInListCorpGroups `json:"Data" xml:"Data"`
}

// CreateListCorpGroupsRequest creates a request to invoke ListCorpGroups API
func CreateListCorpGroupsRequest() (request *ListCorpGroupsRequest) {
	request = &ListCorpGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "ListCorpGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateListCorpGroupsResponse creates a response to parse from ListCorpGroups response
func CreateListCorpGroupsResponse() (response *ListCorpGroupsResponse) {
	response = &ListCorpGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
