package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNewBargeInSwitch invokes the voicenavigator.GetNewBargeInSwitch API synchronously
func (client *Client) GetNewBargeInSwitch(request *GetNewBargeInSwitchRequest) (response *GetNewBargeInSwitchResponse, err error) {
	response = CreateGetNewBargeInSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// GetNewBargeInSwitchWithChan invokes the voicenavigator.GetNewBargeInSwitch API asynchronously
func (client *Client) GetNewBargeInSwitchWithChan(request *GetNewBargeInSwitchRequest) (<-chan *GetNewBargeInSwitchResponse, <-chan error) {
	responseChan := make(chan *GetNewBargeInSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNewBargeInSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNewBargeInSwitchWithCallback invokes the voicenavigator.GetNewBargeInSwitch API asynchronously
func (client *Client) GetNewBargeInSwitchWithCallback(request *GetNewBargeInSwitchRequest, callback func(response *GetNewBargeInSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNewBargeInSwitchResponse
		var err error
		defer close(result)
		response, err = client.GetNewBargeInSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNewBargeInSwitchRequest is the request struct for api GetNewBargeInSwitch
type GetNewBargeInSwitchRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetNewBargeInSwitchResponse is the response struct for api GetNewBargeInSwitch
type GetNewBargeInSwitchResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetNewBargeInSwitchRequest creates a request to invoke GetNewBargeInSwitch API
func CreateGetNewBargeInSwitchRequest() (request *GetNewBargeInSwitchRequest) {
	request = &GetNewBargeInSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "GetNewBargeInSwitch", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNewBargeInSwitchResponse creates a response to parse from GetNewBargeInSwitch response
func CreateGetNewBargeInSwitchResponse() (response *GetNewBargeInSwitchResponse) {
	response = &GetNewBargeInSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
