package xspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomerById invokes the xspace.QueryCustomerById API synchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyid.html
func (client *Client) QueryCustomerById(request *QueryCustomerByIdRequest) (response *QueryCustomerByIdResponse, err error) {
	response = CreateQueryCustomerByIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomerByIdWithChan invokes the xspace.QueryCustomerById API asynchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerByIdWithChan(request *QueryCustomerByIdRequest) (<-chan *QueryCustomerByIdResponse, <-chan error) {
	responseChan := make(chan *QueryCustomerByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomerById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomerByIdWithCallback invokes the xspace.QueryCustomerById API asynchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerByIdWithCallback(request *QueryCustomerByIdRequest, callback func(response *QueryCustomerByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomerByIdResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomerById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomerByIdRequest is the request struct for api QueryCustomerById
type QueryCustomerByIdRequest struct {
	*requests.RoaRequest
	Id string `position:"Query" name:"Id"`
}

// QueryCustomerByIdResponse is the response struct for api QueryCustomerById
type QueryCustomerByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCustomerByIdRequest creates a request to invoke QueryCustomerById API
func CreateQueryCustomerByIdRequest() (request *QueryCustomerByIdRequest) {
	request = &QueryCustomerByIdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("xspace", "2017-07-20", "QueryCustomerById", "/customer", "", "")
	request.Method = requests.PUT
	return
}

// CreateQueryCustomerByIdResponse creates a response to parse from QueryCustomerById response
func CreateQueryCustomerByIdResponse() (response *QueryCustomerByIdResponse) {
	response = &QueryCustomerByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
