/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.DirectByteBufferPool;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.MissingIkvException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ZipFile
extends AutoCloseable {
    @Nullable
    public InputStream getInputStream(@NotNull String var1) throws IOException;

    @Nullable
    public ByteBuffer getByteBuffer(@NotNull String var1) throws IOException;

    public byte @Nullable [] getData(String var1) throws IOException;

    @Nullable
    public ZipResource getResource(String var1);

    public void processResources(@NotNull String var1, @NotNull Predicate<? super String> var2, @NotNull BiConsumer<? super String, ? super InputStream> var3) throws IOException;

    default public void releaseBuffer(ByteBuffer buffer) {
        if (!buffer.isReadOnly()) {
            DirectByteBufferPool.DEFAULT_POOL.release(buffer);
        }
    }

    @NotNull
    public static ZipFile load(@NotNull Path file) throws IOException {
        ZipFile zipFile;
        if (file == null) {
            ZipFile.$$$reportNull$$$0(0);
        }
        try {
            zipFile = ImmutableZipFile.load(file);
        }
        catch (MissingIkvException e) {
            HashMapZipFile hashMapZipFile = HashMapZipFile.load(file);
            if (hashMapZipFile == null) {
                ZipFile.$$$reportNull$$$0(2);
            }
            return hashMapZipFile;
        }
        if (zipFile == null) {
            ZipFile.$$$reportNull$$$0(1);
        }
        return zipFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ZipFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ZipResource {
        public int getUncompressedSize();

        @NotNull
        public String getPath();

        @NotNull
        public ByteBuffer getByteBuffer() throws IOException;

        public byte @NotNull [] getData() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;
    }
}

