/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.ui.DocumentAdapter;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "Lcom/intellij/ui/DocumentAdapter;", "document", "Ljavax/swing/text/Document;", "defaultParentPath", "Ljava/nio/file/Path;", "<init>", "(Ljavax/swing/text/Document;Ljava/nio/file/Path;)V", "modifiedByUser", "", "textChanged", "", "e", "Ljavax/swing/event/DocumentEvent;", "trySetChildPath", "child", "", "Companion", "intellij.platform.vcs.dvcs.impl"})
public final class FilePathDocumentChildPathHandle
extends DocumentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final Path defaultParentPath;
    private boolean modifiedByUser;

    private FilePathDocumentChildPathHandle(Document document, Path defaultParentPath) {
        this.document = document;
        this.defaultParentPath = defaultParentPath;
        this.document.remove(0, this.document.getLength());
        this.document.insertString(0, ((Object)this.defaultParentPath).toString(), null);
    }

    protected void textChanged(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.modifiedByUser = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trySetChildPath(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!this.modifiedByUser) {
            try {
                Path newPath = this.defaultParentPath.resolve(child);
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, ((Object)newPath).toString(), null);
            }
            catch (InvalidPathException invalidPathException) {
            }
            finally {
                this.modifiedByUser = false;
            }
        }
    }

    public /* synthetic */ FilePathDocumentChildPathHandle(Document document, Path defaultParentPath, DefaultConstructorMarker $constructor_marker) {
        this(document, defaultParentPath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle$Companion;", "", "<init>", "()V", "install", "Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "document", "Ljavax/swing/text/Document;", "defaultParentPath", "", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePathDocumentChildPathHandle install(@NotNull Document document, @NotNull String defaultParentPath) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)defaultParentPath, (String)"defaultParentPath");
            Path path = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            FilePathDocumentChildPathHandle handle = new FilePathDocumentChildPathHandle(document, path, null);
            document.addDocumentListener((DocumentListener)((Object)handle));
            return handle;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

