/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model;

import java.util.HashMap;
import java.util.Map;

public enum Level {
    NONE("none"),
    NOTE("note"),
    WARNING("warning"),
    ERROR("error");

    private static final Map<String, Level> CONSTANTS;
    private final String value;

    private Level(String value) {
        this.value = value;
    }

    public static Level fromValue(String value) {
        Level constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    static {
        CONSTANTS = new HashMap<String, Level>();
        for (Level c : Level.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

