/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.DebugArtifactPublisherKt;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.util.text.UniqueNameGenerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/testFramework/DebugArtifactPublisher;", "", "artifactStoragePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "testArtifactStoragePath", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "storeArtifact", "", "artifactPath", "artifactName", "", "publishArtifacts", "testName", "cleanup", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nDebugArtifactPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugArtifactPublisher.kt\ncom/intellij/testFramework/DebugArtifactPublisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class DebugArtifactPublisher {
    @NotNull
    private final Path testArtifactStoragePath;
    @NotNull
    private final UniqueNameGenerator nameGenerator;
    @NotNull
    private final AtomicInteger count;

    public DebugArtifactPublisher(@NotNull Path artifactStoragePath) {
        Intrinsics.checkNotNullParameter((Object)artifactStoragePath, (String)"artifactStoragePath");
        this.testArtifactStoragePath = DebugArtifactPublisherKt.access$createStorageForTest(artifactStoragePath);
        this.nameGenerator = new UniqueNameGenerator();
        this.count = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeArtifact(@NotNull Path artifactPath, @NotNull String artifactName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        if (!Files.exists(artifactPath, new LinkOption[0])) {
            boolean $i$a$-require-DebugArtifactPublisher$storeArtifact$32 = false;
            String $i$a$-require-DebugArtifactPublisher$storeArtifact$32 = "File '" + artifactPath + "' doesn't exist";
            throw new IllegalArgumentException($i$a$-require-DebugArtifactPublisher$storeArtifact$32.toString());
        }
        if (!(((CharSequence)artifactName).length() > 0)) {
            boolean bl = false;
            String string2 = "Artifact name must not be empty";
            throw new IllegalArgumentException(string2.toString());
        }
        UniqueNameGenerator uniqueNameGenerator = this.nameGenerator;
        synchronized (uniqueNameGenerator) {
            boolean bl = false;
            String string3 = this.nameGenerator.generateUniqueName(FileUtil.sanitizeFileName((String)artifactName));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var5_7
            string = string3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"synchronized(...)");
        String uniqueName = string;
        this.count.incrementAndGet();
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.testArtifactStoragePath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path path = this.testArtifactStoragePath.resolve(uniqueName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PathsKt.copyToRecursively$default((Path)artifactPath, (Path)path, null, (boolean)false, (boolean)false, (int)2, null);
    }

    public final void publishArtifacts(@NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        if (this.count.get() == 0) {
            return;
        }
        String fullName = "debug-artifacts/" + FileUtil.sanitizeFileName((String)testName);
        DebugArtifactPublisherKt.access$getLogger$p().debug("Publishing " + this.count.get() + " " + StringUtil.pluralize((String)"artifact", (int)this.count.get()) + " from '" + this.testArtifactStoragePath + "' as " + fullName);
        TeamCityLogger.publishArtifact(this.testArtifactStoragePath, fullName);
    }

    public final void cleanup() {
        if (this.count.get() > 0) {
            PathsKt.deleteRecursively((Path)this.testArtifactStoragePath);
        }
    }
}

