/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.action;

import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionPolicy;
import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionSettings;
import com.intellij.ml.llm.hub.statistics.AIHubLogger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0006\u0082\u0001\u0003\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/completion/cloud/action/CompletionPolicyAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "actionPolicy", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "<init>", "(Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;)V", "value", "cloudCompletionPolicy", "getCloudCompletionPolicy", "()Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "setCloudCompletionPolicy", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Lcom/intellij/ml/llm/completion/cloud/action/CompletionPolicyBalancedAction;", "Lcom/intellij/ml/llm/completion/cloud/action/CompletionPolicyCreativeAction;", "Lcom/intellij/ml/llm/completion/cloud/action/CompletionPolicyFocusedAction;", "intellij.ml.llm.completion"})
@ApiStatus.Internal
public abstract class CompletionPolicyAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final CloudCompletionPolicy actionPolicy;

    private CompletionPolicyAction(CloudCompletionPolicy actionPolicy) {
        this.actionPolicy = actionPolicy;
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
    }

    private final CloudCompletionPolicy getCloudCompletionPolicy() {
        return CloudCompletionSettings.Companion.getInstance().getState().getPolicy();
    }

    private final void setCloudCompletionPolicy(CloudCompletionPolicy value) {
        CloudCompletionSettings.Companion.getInstance().getState().setPolicy(value);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setCloudCompletionPolicy(this.actionPolicy);
        AIHubLogger.Action logAction = switch (WhenMappings.$EnumSwitchMapping$0[this.actionPolicy.ordinal()]) {
            case 1 -> AIHubLogger.Action.COMPLETION_POLICY_FOCUSED;
            case 2 -> AIHubLogger.Action.COMPLETION_POLICY_BALANCED;
            case 3 -> AIHubLogger.Action.COMPLETION_POLICY_CREATIVE;
            default -> throw new NoWhenBranchMatchedException();
        };
        AIHubLogger.INSTANCE.logHubActionsClicked(e.getProject(), logAction);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.getCloudCompletionPolicy() == this.actionPolicy;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setCloudCompletionPolicy(this.actionPolicy);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public /* synthetic */ CompletionPolicyAction(CloudCompletionPolicy actionPolicy, DefaultConstructorMarker $constructor_marker) {
        this(actionPolicy);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudCompletionPolicy.values().length];
            try {
                nArray[CloudCompletionPolicy.Focused.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCompletionPolicy.Balanced.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCompletionPolicy.Creative.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

