/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bH\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "SCRIPT", "Lorg/jetbrains/debugger/ScriptBase;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "<init>", "()V", "idToScript", "Ljava/util/concurrent/ConcurrentMap;", "", "getIdToScript", "()Ljava/util/concurrent/ConcurrentMap;", "forEachScript", "", "scriptProcessor", "Lkotlin/Function1;", "Lorg/jetbrains/debugger/Script;", "", "findScriptById", "id", "(Ljava/lang/String;)Lorg/jetbrains/debugger/ScriptBase;", "clear", "listener", "Lorg/jetbrains/debugger/DebugEventListener;", "findScriptByUrl", "rawUrl", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)Lorg/jetbrains/debugger/ScriptBase;", "rawUrlToOurUrl", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nScriptManagerBaseEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptManagerBaseEx.kt\norg/jetbrains/debugger/ScriptManagerBaseEx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public abstract class ScriptManagerBaseEx<SCRIPT extends ScriptBase>
extends ScriptManagerBase<SCRIPT> {
    @NotNull
    private final ConcurrentMap<String, SCRIPT> idToScript = new ConcurrentHashMap();

    @NotNull
    protected final ConcurrentMap<String, SCRIPT> getIdToScript() {
        return this.idToScript;
    }

    @Override
    public final void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkNotNullParameter(scriptProcessor, (String)"scriptProcessor");
        for (ScriptBase script : this.idToScript.values()) {
            Intrinsics.checkNotNull((Object)script);
            if (((Boolean)scriptProcessor.invoke((Object)script)).booleanValue()) continue;
            return;
        }
    }

    @Nullable
    public final SCRIPT findScriptById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (SCRIPT)((ScriptBase)this.idToScript.get(id));
    }

    public final void clear(@NotNull DebugEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.idToScript.clear();
        listener.scriptsCleared();
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        return (SCRIPT)this.findScriptByUrl(this.rawUrlToOurUrl(rawUrl));
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull Url url) {
        ScriptBase scriptBase;
        Object v0;
        ScriptBase it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            iterable = this.idToScript.values();
            for (Object t : iterable) {
                it = (ScriptBase)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)url, (Object)it.getUrl())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((scriptBase = (ScriptBase)v0) == null) {
            Object v2;
            block4: {
                iterable = this.idToScript.values();
                for (Object t : iterable) {
                    it = (ScriptBase)t;
                    boolean bl = false;
                    if (!url.equalsIgnoreParameters(it.getUrl())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            scriptBase = v2;
        }
        return (SCRIPT)scriptBase;
    }

    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        Url url = Urls.parseEncoded((String)rawUrl);
        Intrinsics.checkNotNull((Object)url);
        return url;
    }
}

