/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.autolink.internal.AutolinkNodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbbreviationNodePostProcessor
extends NodePostProcessor {
    private Pattern abbreviations = null;
    private HashMap<String, BasedSequence> abbreviationMap = null;

    private AbbreviationNodePostProcessor(Document document) {
        this.computeAbbreviations(document);
    }

    private void computeAbbreviations(Document document) {
        AbbreviationRepository abbrRepository = AbbreviationExtension.ABBREVIATIONS.get(document);
        if (!abbrRepository.isEmpty()) {
            this.abbreviationMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> abbreviations = new ArrayList<String>(abbrRepository.keySet());
            abbreviations.sort(Comparator.reverseOrder());
            for (String abbr : abbreviations) {
                BasedSequence abbreviation;
                AbbreviationBlock abbreviationBlock;
                if (abbr.isEmpty() || (abbreviationBlock = (AbbreviationBlock)abbrRepository.get(abbr)) == null || (abbreviation = abbreviationBlock.getAbbreviation()).isEmpty()) continue;
                this.abbreviationMap.put(abbr, abbreviation);
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (Character.isLetterOrDigit(abbr.charAt(0))) {
                    sb.append("\\b");
                }
                sb.append("\\Q").append(abbr).append("\\E");
                if (!Character.isLetterOrDigit(abbr.charAt(abbr.length() - 1))) continue;
                sb.append("\\b");
            }
            if (sb.length() > 0) {
                this.abbreviations = Pattern.compile(sb.toString());
            }
        }
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        TextBase textBase;
        if (this.abbreviations == null) {
            return;
        }
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape(original, textMapper);
        Matcher m = this.abbreviations.matcher(literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase2 = textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        while (m.find()) {
            BasedSequence abbreviation = this.abbreviationMap.get(m.group(0));
            if (abbreviation == null) continue;
            int startOffset = textMapper.originalOffset(m.start(0));
            int endOffset = textMapper.originalOffset(m.end(0));
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore(textBase);
                state.nodeAdded(textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            BasedSequence origToDecorateText = original.subSequence(startOffset, endOffset);
            Abbreviation decorationNode = new Abbreviation(origToDecorateText, abbreviation);
            textBase.appendChild(decorationNode);
            state.nodeAdded(decorationNode);
            lastEscaped = endOffset;
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            HashSet set = new HashSet();
            set.add(AutolinkNodePostProcessor.Factory.class);
            return set;
        }

        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, DoNotDecorate.class, DoNotLinkDecorate.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document) {
            return new AbbreviationNodePostProcessor(document);
        }
    }
}

