from typing import Any

from django.contrib.auth.models import Permission, _AnyUser, _User, _UserModel, _UserType
from django.db.models import QuerySet
from django.db.models.base import Model
from django.http.request import HttpRequest

UserModel = _UserModel

class BaseBackend:
    def authenticate(self, request: HttpRequest | None, **kwargs: Any) -> _User | None: ...
    async def aauthenticate(self, request: HttpRequest | None, **kwargs: Any) -> _User | None: ...
    def get_user(self, user_id: Any) -> _User | None: ...
    async def aget_user(self, user_id: Any) -> _User | None: ...
    def get_user_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    async def aget_user_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    def get_group_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    async def aget_group_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    def get_all_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    async def aget_all_permissions(self, user_obj: _AnyUser, obj: Model | None = ...) -> set[str]: ...
    def has_perm(self, user_obj: _AnyUser, perm: str, obj: Model | None = ...) -> bool: ...
    async def ahas_perm(self, user_obj: _AnyUser, perm: str, obj: Model | None = ...) -> bool: ...

class ModelBackend(BaseBackend):
    def authenticate(
        self, request: HttpRequest | None, username: str | None = ..., password: str | None = ..., **kwargs: Any
    ) -> _User | None: ...
    async def aauthenticate(
        self, request: HttpRequest | None, username: str | None = ..., password: str | None = ..., **kwargs: Any
    ) -> _User | None: ...
    def has_module_perms(self, user_obj: _AnyUser, app_label: str) -> bool: ...
    async def ahas_module_perms(self, user_obj: _AnyUser, app_label: str) -> bool: ...
    def user_can_authenticate(self, user: _AnyUser | None) -> bool: ...
    def with_perm(
        self,
        perm: str | Permission,
        is_active: bool = ...,
        include_superusers: bool = ...,
        obj: Model | None = ...,
    ) -> QuerySet[_User]: ...

class AllowAllUsersModelBackend(ModelBackend): ...

class RemoteUserBackend(ModelBackend):
    create_unknown_user: bool
    def authenticate(self, request: HttpRequest | None, remote_user: str) -> _User | None: ...  # type: ignore[override]
    async def aauthenticate(self, request: HttpRequest | None, remote_user: str) -> _User | None: ...  # type: ignore[override]
    def clean_username(self, username: str) -> str: ...
    def configure_user(self, request: HttpRequest, user: _UserType, created: bool = ...) -> _UserType: ...
    async def aconfigure_user(self, request: HttpRequest, user: _UserType, created: bool = ...) -> _UserType: ...

class AllowAllUsersRemoteUserBackend(RemoteUserBackend): ...
