/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.MemoryUsageCompositeData;

public class MemoryUsage {
    private final long init;
    private final long used;
    private final long committed;
    private final long max;

    public MemoryUsage(long l, long l2, long l3, long l4) {
        if (l < -1L) {
            throw new IllegalArgumentException("init parameter = " + l + " is negative but not -1.");
        }
        if (l4 < -1L) {
            throw new IllegalArgumentException("max parameter = " + l4 + " is negative but not -1.");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("used parameter = " + l2 + " is negative.");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("committed parameter = " + l3 + " is negative.");
        }
        if (l2 > l3) {
            throw new IllegalArgumentException("used = " + l2 + " should be <= committed = " + l3);
        }
        if (l4 >= 0L && l3 > l4) {
            throw new IllegalArgumentException("committed = " + l3 + " should be < max = " + l4);
        }
        this.init = l;
        this.used = l2;
        this.committed = l3;
        this.max = l4;
    }

    private MemoryUsage(CompositeData compositeData) {
        MemoryUsageCompositeData.validateCompositeData(compositeData);
        this.init = MemoryUsageCompositeData.getInit(compositeData);
        this.used = MemoryUsageCompositeData.getUsed(compositeData);
        this.committed = MemoryUsageCompositeData.getCommitted(compositeData);
        this.max = MemoryUsageCompositeData.getMax(compositeData);
    }

    public long getInit() {
        return this.init;
    }

    public long getUsed() {
        return this.used;
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getMax() {
        return this.max;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("init = " + this.init + "(" + (this.init >> 10) + "K) ");
        stringBuffer.append("used = " + this.used + "(" + (this.used >> 10) + "K) ");
        stringBuffer.append("committed = " + this.committed + "(" + (this.committed >> 10) + "K) ");
        stringBuffer.append("max = " + this.max + "(" + (this.max >> 10) + "K)");
        return stringBuffer.toString();
    }

    public static MemoryUsage from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof MemoryUsageCompositeData) {
            return ((MemoryUsageCompositeData)compositeData).getMemoryUsage();
        }
        return new MemoryUsage(compositeData);
    }
}

