/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	"context"
	"io"
	"time"

	mock "github.com/stretchr/testify/mock"
	v10 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
	"k8s.io/client-go/util/flowcontrol"
	"k8s.io/cri-api/pkg/apis/runtime/v1"
	"k8s.io/kubernetes/pkg/credentialprovider"
	"k8s.io/kubernetes/pkg/kubelet/container"
	types0 "k8s.io/kubernetes/pkg/kubelet/types"
)

// NewMockRuntime creates a new instance of MockRuntime. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockRuntime(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockRuntime {
	mock := &MockRuntime{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockRuntime is an autogenerated mock type for the Runtime type
type MockRuntime struct {
	mock.Mock
}

type MockRuntime_Expecter struct {
	mock *mock.Mock
}

func (_m *MockRuntime) EXPECT() *MockRuntime_Expecter {
	return &MockRuntime_Expecter{mock: &_m.Mock}
}

// APIVersion provides a mock function for the type MockRuntime
func (_mock *MockRuntime) APIVersion() (container.Version, error) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for APIVersion")
	}

	var r0 container.Version
	var r1 error
	if returnFunc, ok := ret.Get(0).(func() (container.Version, error)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() container.Version); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(container.Version)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() error); ok {
		r1 = returnFunc()
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_APIVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'APIVersion'
type MockRuntime_APIVersion_Call struct {
	*mock.Call
}

// APIVersion is a helper method to define mock.On call
func (_e *MockRuntime_Expecter) APIVersion() *MockRuntime_APIVersion_Call {
	return &MockRuntime_APIVersion_Call{Call: _e.mock.On("APIVersion")}
}

func (_c *MockRuntime_APIVersion_Call) Run(run func()) *MockRuntime_APIVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRuntime_APIVersion_Call) Return(version container.Version, err error) *MockRuntime_APIVersion_Call {
	_c.Call.Return(version, err)
	return _c
}

func (_c *MockRuntime_APIVersion_Call) RunAndReturn(run func() (container.Version, error)) *MockRuntime_APIVersion_Call {
	_c.Call.Return(run)
	return _c
}

// CheckpointContainer provides a mock function for the type MockRuntime
func (_mock *MockRuntime) CheckpointContainer(ctx context.Context, options *v1.CheckpointContainerRequest) error {
	ret := _mock.Called(ctx, options)

	if len(ret) == 0 {
		panic("no return value specified for CheckpointContainer")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1.CheckpointContainerRequest) error); ok {
		r0 = returnFunc(ctx, options)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_CheckpointContainer_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CheckpointContainer'
type MockRuntime_CheckpointContainer_Call struct {
	*mock.Call
}

// CheckpointContainer is a helper method to define mock.On call
//   - ctx context.Context
//   - options *v1.CheckpointContainerRequest
func (_e *MockRuntime_Expecter) CheckpointContainer(ctx interface{}, options interface{}) *MockRuntime_CheckpointContainer_Call {
	return &MockRuntime_CheckpointContainer_Call{Call: _e.mock.On("CheckpointContainer", ctx, options)}
}

func (_c *MockRuntime_CheckpointContainer_Call) Run(run func(ctx context.Context, options *v1.CheckpointContainerRequest)) *MockRuntime_CheckpointContainer_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1.CheckpointContainerRequest
		if args[1] != nil {
			arg1 = args[1].(*v1.CheckpointContainerRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_CheckpointContainer_Call) Return(err error) *MockRuntime_CheckpointContainer_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_CheckpointContainer_Call) RunAndReturn(run func(ctx context.Context, options *v1.CheckpointContainerRequest) error) *MockRuntime_CheckpointContainer_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteContainer provides a mock function for the type MockRuntime
func (_mock *MockRuntime) DeleteContainer(ctx context.Context, containerID container.ContainerID) error {
	ret := _mock.Called(ctx, containerID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteContainer")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ContainerID) error); ok {
		r0 = returnFunc(ctx, containerID)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_DeleteContainer_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteContainer'
type MockRuntime_DeleteContainer_Call struct {
	*mock.Call
}

// DeleteContainer is a helper method to define mock.On call
//   - ctx context.Context
//   - containerID container.ContainerID
func (_e *MockRuntime_Expecter) DeleteContainer(ctx interface{}, containerID interface{}) *MockRuntime_DeleteContainer_Call {
	return &MockRuntime_DeleteContainer_Call{Call: _e.mock.On("DeleteContainer", ctx, containerID)}
}

func (_c *MockRuntime_DeleteContainer_Call) Run(run func(ctx context.Context, containerID container.ContainerID)) *MockRuntime_DeleteContainer_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ContainerID
		if args[1] != nil {
			arg1 = args[1].(container.ContainerID)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_DeleteContainer_Call) Return(err error) *MockRuntime_DeleteContainer_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_DeleteContainer_Call) RunAndReturn(run func(ctx context.Context, containerID container.ContainerID) error) *MockRuntime_DeleteContainer_Call {
	_c.Call.Return(run)
	return _c
}

// GarbageCollect provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GarbageCollect(ctx context.Context, gcPolicy container.GCPolicy, allSourcesReady bool, evictNonDeletedPods bool) error {
	ret := _mock.Called(ctx, gcPolicy, allSourcesReady, evictNonDeletedPods)

	if len(ret) == 0 {
		panic("no return value specified for GarbageCollect")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.GCPolicy, bool, bool) error); ok {
		r0 = returnFunc(ctx, gcPolicy, allSourcesReady, evictNonDeletedPods)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_GarbageCollect_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GarbageCollect'
type MockRuntime_GarbageCollect_Call struct {
	*mock.Call
}

// GarbageCollect is a helper method to define mock.On call
//   - ctx context.Context
//   - gcPolicy container.GCPolicy
//   - allSourcesReady bool
//   - evictNonDeletedPods bool
func (_e *MockRuntime_Expecter) GarbageCollect(ctx interface{}, gcPolicy interface{}, allSourcesReady interface{}, evictNonDeletedPods interface{}) *MockRuntime_GarbageCollect_Call {
	return &MockRuntime_GarbageCollect_Call{Call: _e.mock.On("GarbageCollect", ctx, gcPolicy, allSourcesReady, evictNonDeletedPods)}
}

func (_c *MockRuntime_GarbageCollect_Call) Run(run func(ctx context.Context, gcPolicy container.GCPolicy, allSourcesReady bool, evictNonDeletedPods bool)) *MockRuntime_GarbageCollect_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.GCPolicy
		if args[1] != nil {
			arg1 = args[1].(container.GCPolicy)
		}
		var arg2 bool
		if args[2] != nil {
			arg2 = args[2].(bool)
		}
		var arg3 bool
		if args[3] != nil {
			arg3 = args[3].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockRuntime_GarbageCollect_Call) Return(err error) *MockRuntime_GarbageCollect_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_GarbageCollect_Call) RunAndReturn(run func(ctx context.Context, gcPolicy container.GCPolicy, allSourcesReady bool, evictNonDeletedPods bool) error) *MockRuntime_GarbageCollect_Call {
	_c.Call.Return(run)
	return _c
}

// GeneratePodStatus provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GeneratePodStatus(event *v1.ContainerEventResponse) *container.PodStatus {
	ret := _mock.Called(event)

	if len(ret) == 0 {
		panic("no return value specified for GeneratePodStatus")
	}

	var r0 *container.PodStatus
	if returnFunc, ok := ret.Get(0).(func(*v1.ContainerEventResponse) *container.PodStatus); ok {
		r0 = returnFunc(event)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.PodStatus)
		}
	}
	return r0
}

// MockRuntime_GeneratePodStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GeneratePodStatus'
type MockRuntime_GeneratePodStatus_Call struct {
	*mock.Call
}

// GeneratePodStatus is a helper method to define mock.On call
//   - event *v1.ContainerEventResponse
func (_e *MockRuntime_Expecter) GeneratePodStatus(event interface{}) *MockRuntime_GeneratePodStatus_Call {
	return &MockRuntime_GeneratePodStatus_Call{Call: _e.mock.On("GeneratePodStatus", event)}
}

func (_c *MockRuntime_GeneratePodStatus_Call) Run(run func(event *v1.ContainerEventResponse)) *MockRuntime_GeneratePodStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.ContainerEventResponse
		if args[0] != nil {
			arg0 = args[0].(*v1.ContainerEventResponse)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_GeneratePodStatus_Call) Return(podStatus *container.PodStatus) *MockRuntime_GeneratePodStatus_Call {
	_c.Call.Return(podStatus)
	return _c
}

func (_c *MockRuntime_GeneratePodStatus_Call) RunAndReturn(run func(event *v1.ContainerEventResponse) *container.PodStatus) *MockRuntime_GeneratePodStatus_Call {
	_c.Call.Return(run)
	return _c
}

// GetContainerLogs provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetContainerLogs(ctx context.Context, pod *v10.Pod, containerID container.ContainerID, logOptions *v10.PodLogOptions, stdout io.Writer, stderr io.Writer) error {
	ret := _mock.Called(ctx, pod, containerID, logOptions, stdout, stderr)

	if len(ret) == 0 {
		panic("no return value specified for GetContainerLogs")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v10.Pod, container.ContainerID, *v10.PodLogOptions, io.Writer, io.Writer) error); ok {
		r0 = returnFunc(ctx, pod, containerID, logOptions, stdout, stderr)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_GetContainerLogs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetContainerLogs'
type MockRuntime_GetContainerLogs_Call struct {
	*mock.Call
}

// GetContainerLogs is a helper method to define mock.On call
//   - ctx context.Context
//   - pod *v10.Pod
//   - containerID container.ContainerID
//   - logOptions *v10.PodLogOptions
//   - stdout io.Writer
//   - stderr io.Writer
func (_e *MockRuntime_Expecter) GetContainerLogs(ctx interface{}, pod interface{}, containerID interface{}, logOptions interface{}, stdout interface{}, stderr interface{}) *MockRuntime_GetContainerLogs_Call {
	return &MockRuntime_GetContainerLogs_Call{Call: _e.mock.On("GetContainerLogs", ctx, pod, containerID, logOptions, stdout, stderr)}
}

func (_c *MockRuntime_GetContainerLogs_Call) Run(run func(ctx context.Context, pod *v10.Pod, containerID container.ContainerID, logOptions *v10.PodLogOptions, stdout io.Writer, stderr io.Writer)) *MockRuntime_GetContainerLogs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v10.Pod
		if args[1] != nil {
			arg1 = args[1].(*v10.Pod)
		}
		var arg2 container.ContainerID
		if args[2] != nil {
			arg2 = args[2].(container.ContainerID)
		}
		var arg3 *v10.PodLogOptions
		if args[3] != nil {
			arg3 = args[3].(*v10.PodLogOptions)
		}
		var arg4 io.Writer
		if args[4] != nil {
			arg4 = args[4].(io.Writer)
		}
		var arg5 io.Writer
		if args[5] != nil {
			arg5 = args[5].(io.Writer)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
		)
	})
	return _c
}

func (_c *MockRuntime_GetContainerLogs_Call) Return(err error) *MockRuntime_GetContainerLogs_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_GetContainerLogs_Call) RunAndReturn(run func(ctx context.Context, pod *v10.Pod, containerID container.ContainerID, logOptions *v10.PodLogOptions, stdout io.Writer, stderr io.Writer) error) *MockRuntime_GetContainerLogs_Call {
	_c.Call.Return(run)
	return _c
}

// GetContainerStatus provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetContainerStatus(ctx context.Context, podUID types.UID, id container.ContainerID) (*container.Status, error) {
	ret := _mock.Called(ctx, podUID, id)

	if len(ret) == 0 {
		panic("no return value specified for GetContainerStatus")
	}

	var r0 *container.Status
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, types.UID, container.ContainerID) (*container.Status, error)); ok {
		return returnFunc(ctx, podUID, id)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, types.UID, container.ContainerID) *container.Status); ok {
		r0 = returnFunc(ctx, podUID, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.Status)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, types.UID, container.ContainerID) error); ok {
		r1 = returnFunc(ctx, podUID, id)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_GetContainerStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetContainerStatus'
type MockRuntime_GetContainerStatus_Call struct {
	*mock.Call
}

// GetContainerStatus is a helper method to define mock.On call
//   - ctx context.Context
//   - podUID types.UID
//   - id container.ContainerID
func (_e *MockRuntime_Expecter) GetContainerStatus(ctx interface{}, podUID interface{}, id interface{}) *MockRuntime_GetContainerStatus_Call {
	return &MockRuntime_GetContainerStatus_Call{Call: _e.mock.On("GetContainerStatus", ctx, podUID, id)}
}

func (_c *MockRuntime_GetContainerStatus_Call) Run(run func(ctx context.Context, podUID types.UID, id container.ContainerID)) *MockRuntime_GetContainerStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 types.UID
		if args[1] != nil {
			arg1 = args[1].(types.UID)
		}
		var arg2 container.ContainerID
		if args[2] != nil {
			arg2 = args[2].(container.ContainerID)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockRuntime_GetContainerStatus_Call) Return(status *container.Status, err error) *MockRuntime_GetContainerStatus_Call {
	_c.Call.Return(status, err)
	return _c
}

func (_c *MockRuntime_GetContainerStatus_Call) RunAndReturn(run func(ctx context.Context, podUID types.UID, id container.ContainerID) (*container.Status, error)) *MockRuntime_GetContainerStatus_Call {
	_c.Call.Return(run)
	return _c
}

// GetContainerSwapBehavior provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetContainerSwapBehavior(pod *v10.Pod, container1 *v10.Container) types0.SwapBehavior {
	ret := _mock.Called(pod, container1)

	if len(ret) == 0 {
		panic("no return value specified for GetContainerSwapBehavior")
	}

	var r0 types0.SwapBehavior
	if returnFunc, ok := ret.Get(0).(func(*v10.Pod, *v10.Container) types0.SwapBehavior); ok {
		r0 = returnFunc(pod, container1)
	} else {
		r0 = ret.Get(0).(types0.SwapBehavior)
	}
	return r0
}

// MockRuntime_GetContainerSwapBehavior_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetContainerSwapBehavior'
type MockRuntime_GetContainerSwapBehavior_Call struct {
	*mock.Call
}

// GetContainerSwapBehavior is a helper method to define mock.On call
//   - pod *v10.Pod
//   - container1 *v10.Container
func (_e *MockRuntime_Expecter) GetContainerSwapBehavior(pod interface{}, container1 interface{}) *MockRuntime_GetContainerSwapBehavior_Call {
	return &MockRuntime_GetContainerSwapBehavior_Call{Call: _e.mock.On("GetContainerSwapBehavior", pod, container1)}
}

func (_c *MockRuntime_GetContainerSwapBehavior_Call) Run(run func(pod *v10.Pod, container1 *v10.Container)) *MockRuntime_GetContainerSwapBehavior_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v10.Pod
		if args[0] != nil {
			arg0 = args[0].(*v10.Pod)
		}
		var arg1 *v10.Container
		if args[1] != nil {
			arg1 = args[1].(*v10.Container)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_GetContainerSwapBehavior_Call) Return(swapBehavior types0.SwapBehavior) *MockRuntime_GetContainerSwapBehavior_Call {
	_c.Call.Return(swapBehavior)
	return _c
}

func (_c *MockRuntime_GetContainerSwapBehavior_Call) RunAndReturn(run func(pod *v10.Pod, container1 *v10.Container) types0.SwapBehavior) *MockRuntime_GetContainerSwapBehavior_Call {
	_c.Call.Return(run)
	return _c
}

// GetImageRef provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetImageRef(ctx context.Context, image container.ImageSpec) (string, error) {
	ret := _mock.Called(ctx, image)

	if len(ret) == 0 {
		panic("no return value specified for GetImageRef")
	}

	var r0 string
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec) (string, error)); ok {
		return returnFunc(ctx, image)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec) string); ok {
		r0 = returnFunc(ctx, image)
	} else {
		r0 = ret.Get(0).(string)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, container.ImageSpec) error); ok {
		r1 = returnFunc(ctx, image)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_GetImageRef_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetImageRef'
type MockRuntime_GetImageRef_Call struct {
	*mock.Call
}

// GetImageRef is a helper method to define mock.On call
//   - ctx context.Context
//   - image container.ImageSpec
func (_e *MockRuntime_Expecter) GetImageRef(ctx interface{}, image interface{}) *MockRuntime_GetImageRef_Call {
	return &MockRuntime_GetImageRef_Call{Call: _e.mock.On("GetImageRef", ctx, image)}
}

func (_c *MockRuntime_GetImageRef_Call) Run(run func(ctx context.Context, image container.ImageSpec)) *MockRuntime_GetImageRef_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ImageSpec
		if args[1] != nil {
			arg1 = args[1].(container.ImageSpec)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_GetImageRef_Call) Return(s string, err error) *MockRuntime_GetImageRef_Call {
	_c.Call.Return(s, err)
	return _c
}

func (_c *MockRuntime_GetImageRef_Call) RunAndReturn(run func(ctx context.Context, image container.ImageSpec) (string, error)) *MockRuntime_GetImageRef_Call {
	_c.Call.Return(run)
	return _c
}

// GetImageSize provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetImageSize(ctx context.Context, image container.ImageSpec) (uint64, error) {
	ret := _mock.Called(ctx, image)

	if len(ret) == 0 {
		panic("no return value specified for GetImageSize")
	}

	var r0 uint64
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec) (uint64, error)); ok {
		return returnFunc(ctx, image)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec) uint64); ok {
		r0 = returnFunc(ctx, image)
	} else {
		r0 = ret.Get(0).(uint64)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, container.ImageSpec) error); ok {
		r1 = returnFunc(ctx, image)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_GetImageSize_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetImageSize'
type MockRuntime_GetImageSize_Call struct {
	*mock.Call
}

// GetImageSize is a helper method to define mock.On call
//   - ctx context.Context
//   - image container.ImageSpec
func (_e *MockRuntime_Expecter) GetImageSize(ctx interface{}, image interface{}) *MockRuntime_GetImageSize_Call {
	return &MockRuntime_GetImageSize_Call{Call: _e.mock.On("GetImageSize", ctx, image)}
}

func (_c *MockRuntime_GetImageSize_Call) Run(run func(ctx context.Context, image container.ImageSpec)) *MockRuntime_GetImageSize_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ImageSpec
		if args[1] != nil {
			arg1 = args[1].(container.ImageSpec)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_GetImageSize_Call) Return(v uint64, err error) *MockRuntime_GetImageSize_Call {
	_c.Call.Return(v, err)
	return _c
}

func (_c *MockRuntime_GetImageSize_Call) RunAndReturn(run func(ctx context.Context, image container.ImageSpec) (uint64, error)) *MockRuntime_GetImageSize_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodStatus provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetPodStatus(ctx context.Context, uid types.UID, name string, namespace string) (*container.PodStatus, error) {
	ret := _mock.Called(ctx, uid, name, namespace)

	if len(ret) == 0 {
		panic("no return value specified for GetPodStatus")
	}

	var r0 *container.PodStatus
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, types.UID, string, string) (*container.PodStatus, error)); ok {
		return returnFunc(ctx, uid, name, namespace)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, types.UID, string, string) *container.PodStatus); ok {
		r0 = returnFunc(ctx, uid, name, namespace)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.PodStatus)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, types.UID, string, string) error); ok {
		r1 = returnFunc(ctx, uid, name, namespace)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_GetPodStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodStatus'
type MockRuntime_GetPodStatus_Call struct {
	*mock.Call
}

// GetPodStatus is a helper method to define mock.On call
//   - ctx context.Context
//   - uid types.UID
//   - name string
//   - namespace string
func (_e *MockRuntime_Expecter) GetPodStatus(ctx interface{}, uid interface{}, name interface{}, namespace interface{}) *MockRuntime_GetPodStatus_Call {
	return &MockRuntime_GetPodStatus_Call{Call: _e.mock.On("GetPodStatus", ctx, uid, name, namespace)}
}

func (_c *MockRuntime_GetPodStatus_Call) Run(run func(ctx context.Context, uid types.UID, name string, namespace string)) *MockRuntime_GetPodStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 types.UID
		if args[1] != nil {
			arg1 = args[1].(types.UID)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		var arg3 string
		if args[3] != nil {
			arg3 = args[3].(string)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockRuntime_GetPodStatus_Call) Return(podStatus *container.PodStatus, err error) *MockRuntime_GetPodStatus_Call {
	_c.Call.Return(podStatus, err)
	return _c
}

func (_c *MockRuntime_GetPodStatus_Call) RunAndReturn(run func(ctx context.Context, uid types.UID, name string, namespace string) (*container.PodStatus, error)) *MockRuntime_GetPodStatus_Call {
	_c.Call.Return(run)
	return _c
}

// GetPods provides a mock function for the type MockRuntime
func (_mock *MockRuntime) GetPods(ctx context.Context, all bool) ([]*container.Pod, error) {
	ret := _mock.Called(ctx, all)

	if len(ret) == 0 {
		panic("no return value specified for GetPods")
	}

	var r0 []*container.Pod
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, bool) ([]*container.Pod, error)); ok {
		return returnFunc(ctx, all)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, bool) []*container.Pod); ok {
		r0 = returnFunc(ctx, all)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*container.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, bool) error); ok {
		r1 = returnFunc(ctx, all)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_GetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPods'
type MockRuntime_GetPods_Call struct {
	*mock.Call
}

// GetPods is a helper method to define mock.On call
//   - ctx context.Context
//   - all bool
func (_e *MockRuntime_Expecter) GetPods(ctx interface{}, all interface{}) *MockRuntime_GetPods_Call {
	return &MockRuntime_GetPods_Call{Call: _e.mock.On("GetPods", ctx, all)}
}

func (_c *MockRuntime_GetPods_Call) Run(run func(ctx context.Context, all bool)) *MockRuntime_GetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 bool
		if args[1] != nil {
			arg1 = args[1].(bool)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_GetPods_Call) Return(pods []*container.Pod, err error) *MockRuntime_GetPods_Call {
	_c.Call.Return(pods, err)
	return _c
}

func (_c *MockRuntime_GetPods_Call) RunAndReturn(run func(ctx context.Context, all bool) ([]*container.Pod, error)) *MockRuntime_GetPods_Call {
	_c.Call.Return(run)
	return _c
}

// ImageFsInfo provides a mock function for the type MockRuntime
func (_mock *MockRuntime) ImageFsInfo(ctx context.Context) (*v1.ImageFsInfoResponse, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for ImageFsInfo")
	}

	var r0 *v1.ImageFsInfoResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (*v1.ImageFsInfoResponse, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) *v1.ImageFsInfoResponse); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.ImageFsInfoResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_ImageFsInfo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageFsInfo'
type MockRuntime_ImageFsInfo_Call struct {
	*mock.Call
}

// ImageFsInfo is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) ImageFsInfo(ctx interface{}) *MockRuntime_ImageFsInfo_Call {
	return &MockRuntime_ImageFsInfo_Call{Call: _e.mock.On("ImageFsInfo", ctx)}
}

func (_c *MockRuntime_ImageFsInfo_Call) Run(run func(ctx context.Context)) *MockRuntime_ImageFsInfo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_ImageFsInfo_Call) Return(imageFsInfoResponse *v1.ImageFsInfoResponse, err error) *MockRuntime_ImageFsInfo_Call {
	_c.Call.Return(imageFsInfoResponse, err)
	return _c
}

func (_c *MockRuntime_ImageFsInfo_Call) RunAndReturn(run func(ctx context.Context) (*v1.ImageFsInfoResponse, error)) *MockRuntime_ImageFsInfo_Call {
	_c.Call.Return(run)
	return _c
}

// ImageStats provides a mock function for the type MockRuntime
func (_mock *MockRuntime) ImageStats(ctx context.Context) (*container.ImageStats, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for ImageStats")
	}

	var r0 *container.ImageStats
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (*container.ImageStats, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) *container.ImageStats); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.ImageStats)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_ImageStats_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ImageStats'
type MockRuntime_ImageStats_Call struct {
	*mock.Call
}

// ImageStats is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) ImageStats(ctx interface{}) *MockRuntime_ImageStats_Call {
	return &MockRuntime_ImageStats_Call{Call: _e.mock.On("ImageStats", ctx)}
}

func (_c *MockRuntime_ImageStats_Call) Run(run func(ctx context.Context)) *MockRuntime_ImageStats_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_ImageStats_Call) Return(imageStats *container.ImageStats, err error) *MockRuntime_ImageStats_Call {
	_c.Call.Return(imageStats, err)
	return _c
}

func (_c *MockRuntime_ImageStats_Call) RunAndReturn(run func(ctx context.Context) (*container.ImageStats, error)) *MockRuntime_ImageStats_Call {
	_c.Call.Return(run)
	return _c
}

// IsPodResizeInProgress provides a mock function for the type MockRuntime
func (_mock *MockRuntime) IsPodResizeInProgress(allocatedPod *v10.Pod, podStatus *container.PodStatus) bool {
	ret := _mock.Called(allocatedPod, podStatus)

	if len(ret) == 0 {
		panic("no return value specified for IsPodResizeInProgress")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*v10.Pod, *container.PodStatus) bool); ok {
		r0 = returnFunc(allocatedPod, podStatus)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockRuntime_IsPodResizeInProgress_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsPodResizeInProgress'
type MockRuntime_IsPodResizeInProgress_Call struct {
	*mock.Call
}

// IsPodResizeInProgress is a helper method to define mock.On call
//   - allocatedPod *v10.Pod
//   - podStatus *container.PodStatus
func (_e *MockRuntime_Expecter) IsPodResizeInProgress(allocatedPod interface{}, podStatus interface{}) *MockRuntime_IsPodResizeInProgress_Call {
	return &MockRuntime_IsPodResizeInProgress_Call{Call: _e.mock.On("IsPodResizeInProgress", allocatedPod, podStatus)}
}

func (_c *MockRuntime_IsPodResizeInProgress_Call) Run(run func(allocatedPod *v10.Pod, podStatus *container.PodStatus)) *MockRuntime_IsPodResizeInProgress_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v10.Pod
		if args[0] != nil {
			arg0 = args[0].(*v10.Pod)
		}
		var arg1 *container.PodStatus
		if args[1] != nil {
			arg1 = args[1].(*container.PodStatus)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_IsPodResizeInProgress_Call) Return(b bool) *MockRuntime_IsPodResizeInProgress_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockRuntime_IsPodResizeInProgress_Call) RunAndReturn(run func(allocatedPod *v10.Pod, podStatus *container.PodStatus) bool) *MockRuntime_IsPodResizeInProgress_Call {
	_c.Call.Return(run)
	return _c
}

// KillPod provides a mock function for the type MockRuntime
func (_mock *MockRuntime) KillPod(ctx context.Context, pod *v10.Pod, runningPod container.Pod, gracePeriodOverride *int64) error {
	ret := _mock.Called(ctx, pod, runningPod, gracePeriodOverride)

	if len(ret) == 0 {
		panic("no return value specified for KillPod")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v10.Pod, container.Pod, *int64) error); ok {
		r0 = returnFunc(ctx, pod, runningPod, gracePeriodOverride)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_KillPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'KillPod'
type MockRuntime_KillPod_Call struct {
	*mock.Call
}

// KillPod is a helper method to define mock.On call
//   - ctx context.Context
//   - pod *v10.Pod
//   - runningPod container.Pod
//   - gracePeriodOverride *int64
func (_e *MockRuntime_Expecter) KillPod(ctx interface{}, pod interface{}, runningPod interface{}, gracePeriodOverride interface{}) *MockRuntime_KillPod_Call {
	return &MockRuntime_KillPod_Call{Call: _e.mock.On("KillPod", ctx, pod, runningPod, gracePeriodOverride)}
}

func (_c *MockRuntime_KillPod_Call) Run(run func(ctx context.Context, pod *v10.Pod, runningPod container.Pod, gracePeriodOverride *int64)) *MockRuntime_KillPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v10.Pod
		if args[1] != nil {
			arg1 = args[1].(*v10.Pod)
		}
		var arg2 container.Pod
		if args[2] != nil {
			arg2 = args[2].(container.Pod)
		}
		var arg3 *int64
		if args[3] != nil {
			arg3 = args[3].(*int64)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockRuntime_KillPod_Call) Return(err error) *MockRuntime_KillPod_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_KillPod_Call) RunAndReturn(run func(ctx context.Context, pod *v10.Pod, runningPod container.Pod, gracePeriodOverride *int64) error) *MockRuntime_KillPod_Call {
	_c.Call.Return(run)
	return _c
}

// ListImages provides a mock function for the type MockRuntime
func (_mock *MockRuntime) ListImages(ctx context.Context) ([]container.Image, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for ListImages")
	}

	var r0 []container.Image
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) ([]container.Image, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) []container.Image); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]container.Image)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_ListImages_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListImages'
type MockRuntime_ListImages_Call struct {
	*mock.Call
}

// ListImages is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) ListImages(ctx interface{}) *MockRuntime_ListImages_Call {
	return &MockRuntime_ListImages_Call{Call: _e.mock.On("ListImages", ctx)}
}

func (_c *MockRuntime_ListImages_Call) Run(run func(ctx context.Context)) *MockRuntime_ListImages_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_ListImages_Call) Return(images []container.Image, err error) *MockRuntime_ListImages_Call {
	_c.Call.Return(images, err)
	return _c
}

func (_c *MockRuntime_ListImages_Call) RunAndReturn(run func(ctx context.Context) ([]container.Image, error)) *MockRuntime_ListImages_Call {
	_c.Call.Return(run)
	return _c
}

// ListMetricDescriptors provides a mock function for the type MockRuntime
func (_mock *MockRuntime) ListMetricDescriptors(ctx context.Context) ([]*v1.MetricDescriptor, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for ListMetricDescriptors")
	}

	var r0 []*v1.MetricDescriptor
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) ([]*v1.MetricDescriptor, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) []*v1.MetricDescriptor); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.MetricDescriptor)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_ListMetricDescriptors_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListMetricDescriptors'
type MockRuntime_ListMetricDescriptors_Call struct {
	*mock.Call
}

// ListMetricDescriptors is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) ListMetricDescriptors(ctx interface{}) *MockRuntime_ListMetricDescriptors_Call {
	return &MockRuntime_ListMetricDescriptors_Call{Call: _e.mock.On("ListMetricDescriptors", ctx)}
}

func (_c *MockRuntime_ListMetricDescriptors_Call) Run(run func(ctx context.Context)) *MockRuntime_ListMetricDescriptors_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_ListMetricDescriptors_Call) Return(metricDescriptors []*v1.MetricDescriptor, err error) *MockRuntime_ListMetricDescriptors_Call {
	_c.Call.Return(metricDescriptors, err)
	return _c
}

func (_c *MockRuntime_ListMetricDescriptors_Call) RunAndReturn(run func(ctx context.Context) ([]*v1.MetricDescriptor, error)) *MockRuntime_ListMetricDescriptors_Call {
	_c.Call.Return(run)
	return _c
}

// ListPodSandboxMetrics provides a mock function for the type MockRuntime
func (_mock *MockRuntime) ListPodSandboxMetrics(ctx context.Context) ([]*v1.PodSandboxMetrics, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for ListPodSandboxMetrics")
	}

	var r0 []*v1.PodSandboxMetrics
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) ([]*v1.PodSandboxMetrics, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) []*v1.PodSandboxMetrics); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.PodSandboxMetrics)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_ListPodSandboxMetrics_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListPodSandboxMetrics'
type MockRuntime_ListPodSandboxMetrics_Call struct {
	*mock.Call
}

// ListPodSandboxMetrics is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) ListPodSandboxMetrics(ctx interface{}) *MockRuntime_ListPodSandboxMetrics_Call {
	return &MockRuntime_ListPodSandboxMetrics_Call{Call: _e.mock.On("ListPodSandboxMetrics", ctx)}
}

func (_c *MockRuntime_ListPodSandboxMetrics_Call) Run(run func(ctx context.Context)) *MockRuntime_ListPodSandboxMetrics_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_ListPodSandboxMetrics_Call) Return(podSandboxMetricss []*v1.PodSandboxMetrics, err error) *MockRuntime_ListPodSandboxMetrics_Call {
	_c.Call.Return(podSandboxMetricss, err)
	return _c
}

func (_c *MockRuntime_ListPodSandboxMetrics_Call) RunAndReturn(run func(ctx context.Context) ([]*v1.PodSandboxMetrics, error)) *MockRuntime_ListPodSandboxMetrics_Call {
	_c.Call.Return(run)
	return _c
}

// PullImage provides a mock function for the type MockRuntime
func (_mock *MockRuntime) PullImage(ctx context.Context, image container.ImageSpec, credentials []credentialprovider.TrackedAuthConfig, podSandboxConfig *v1.PodSandboxConfig) (string, *credentialprovider.TrackedAuthConfig, error) {
	ret := _mock.Called(ctx, image, credentials, podSandboxConfig)

	if len(ret) == 0 {
		panic("no return value specified for PullImage")
	}

	var r0 string
	var r1 *credentialprovider.TrackedAuthConfig
	var r2 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec, []credentialprovider.TrackedAuthConfig, *v1.PodSandboxConfig) (string, *credentialprovider.TrackedAuthConfig, error)); ok {
		return returnFunc(ctx, image, credentials, podSandboxConfig)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec, []credentialprovider.TrackedAuthConfig, *v1.PodSandboxConfig) string); ok {
		r0 = returnFunc(ctx, image, credentials, podSandboxConfig)
	} else {
		r0 = ret.Get(0).(string)
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, container.ImageSpec, []credentialprovider.TrackedAuthConfig, *v1.PodSandboxConfig) *credentialprovider.TrackedAuthConfig); ok {
		r1 = returnFunc(ctx, image, credentials, podSandboxConfig)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*credentialprovider.TrackedAuthConfig)
		}
	}
	if returnFunc, ok := ret.Get(2).(func(context.Context, container.ImageSpec, []credentialprovider.TrackedAuthConfig, *v1.PodSandboxConfig) error); ok {
		r2 = returnFunc(ctx, image, credentials, podSandboxConfig)
	} else {
		r2 = ret.Error(2)
	}
	return r0, r1, r2
}

// MockRuntime_PullImage_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PullImage'
type MockRuntime_PullImage_Call struct {
	*mock.Call
}

// PullImage is a helper method to define mock.On call
//   - ctx context.Context
//   - image container.ImageSpec
//   - credentials []credentialprovider.TrackedAuthConfig
//   - podSandboxConfig *v1.PodSandboxConfig
func (_e *MockRuntime_Expecter) PullImage(ctx interface{}, image interface{}, credentials interface{}, podSandboxConfig interface{}) *MockRuntime_PullImage_Call {
	return &MockRuntime_PullImage_Call{Call: _e.mock.On("PullImage", ctx, image, credentials, podSandboxConfig)}
}

func (_c *MockRuntime_PullImage_Call) Run(run func(ctx context.Context, image container.ImageSpec, credentials []credentialprovider.TrackedAuthConfig, podSandboxConfig *v1.PodSandboxConfig)) *MockRuntime_PullImage_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ImageSpec
		if args[1] != nil {
			arg1 = args[1].(container.ImageSpec)
		}
		var arg2 []credentialprovider.TrackedAuthConfig
		if args[2] != nil {
			arg2 = args[2].([]credentialprovider.TrackedAuthConfig)
		}
		var arg3 *v1.PodSandboxConfig
		if args[3] != nil {
			arg3 = args[3].(*v1.PodSandboxConfig)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockRuntime_PullImage_Call) Return(s string, trackedAuthConfig *credentialprovider.TrackedAuthConfig, err error) *MockRuntime_PullImage_Call {
	_c.Call.Return(s, trackedAuthConfig, err)
	return _c
}

func (_c *MockRuntime_PullImage_Call) RunAndReturn(run func(ctx context.Context, image container.ImageSpec, credentials []credentialprovider.TrackedAuthConfig, podSandboxConfig *v1.PodSandboxConfig) (string, *credentialprovider.TrackedAuthConfig, error)) *MockRuntime_PullImage_Call {
	_c.Call.Return(run)
	return _c
}

// RemoveImage provides a mock function for the type MockRuntime
func (_mock *MockRuntime) RemoveImage(ctx context.Context, image container.ImageSpec) error {
	ret := _mock.Called(ctx, image)

	if len(ret) == 0 {
		panic("no return value specified for RemoveImage")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, container.ImageSpec) error); ok {
		r0 = returnFunc(ctx, image)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_RemoveImage_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RemoveImage'
type MockRuntime_RemoveImage_Call struct {
	*mock.Call
}

// RemoveImage is a helper method to define mock.On call
//   - ctx context.Context
//   - image container.ImageSpec
func (_e *MockRuntime_Expecter) RemoveImage(ctx interface{}, image interface{}) *MockRuntime_RemoveImage_Call {
	return &MockRuntime_RemoveImage_Call{Call: _e.mock.On("RemoveImage", ctx, image)}
}

func (_c *MockRuntime_RemoveImage_Call) Run(run func(ctx context.Context, image container.ImageSpec)) *MockRuntime_RemoveImage_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 container.ImageSpec
		if args[1] != nil {
			arg1 = args[1].(container.ImageSpec)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_RemoveImage_Call) Return(err error) *MockRuntime_RemoveImage_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_RemoveImage_Call) RunAndReturn(run func(ctx context.Context, image container.ImageSpec) error) *MockRuntime_RemoveImage_Call {
	_c.Call.Return(run)
	return _c
}

// Status provides a mock function for the type MockRuntime
func (_mock *MockRuntime) Status(ctx context.Context) (*container.RuntimeStatus, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Status")
	}

	var r0 *container.RuntimeStatus
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (*container.RuntimeStatus, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) *container.RuntimeStatus); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*container.RuntimeStatus)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_Status_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Status'
type MockRuntime_Status_Call struct {
	*mock.Call
}

// Status is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) Status(ctx interface{}) *MockRuntime_Status_Call {
	return &MockRuntime_Status_Call{Call: _e.mock.On("Status", ctx)}
}

func (_c *MockRuntime_Status_Call) Run(run func(ctx context.Context)) *MockRuntime_Status_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_Status_Call) Return(runtimeStatus *container.RuntimeStatus, err error) *MockRuntime_Status_Call {
	_c.Call.Return(runtimeStatus, err)
	return _c
}

func (_c *MockRuntime_Status_Call) RunAndReturn(run func(ctx context.Context) (*container.RuntimeStatus, error)) *MockRuntime_Status_Call {
	_c.Call.Return(run)
	return _c
}

// SyncPod provides a mock function for the type MockRuntime
func (_mock *MockRuntime) SyncPod(ctx context.Context, pod *v10.Pod, podStatus *container.PodStatus, pullSecrets []v10.Secret, backOff *flowcontrol.Backoff, restartAllContainers bool) container.PodSyncResult {
	ret := _mock.Called(ctx, pod, podStatus, pullSecrets, backOff, restartAllContainers)

	if len(ret) == 0 {
		panic("no return value specified for SyncPod")
	}

	var r0 container.PodSyncResult
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v10.Pod, *container.PodStatus, []v10.Secret, *flowcontrol.Backoff, bool) container.PodSyncResult); ok {
		r0 = returnFunc(ctx, pod, podStatus, pullSecrets, backOff, restartAllContainers)
	} else {
		r0 = ret.Get(0).(container.PodSyncResult)
	}
	return r0
}

// MockRuntime_SyncPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SyncPod'
type MockRuntime_SyncPod_Call struct {
	*mock.Call
}

// SyncPod is a helper method to define mock.On call
//   - ctx context.Context
//   - pod *v10.Pod
//   - podStatus *container.PodStatus
//   - pullSecrets []v10.Secret
//   - backOff *flowcontrol.Backoff
//   - restartAllContainers bool
func (_e *MockRuntime_Expecter) SyncPod(ctx interface{}, pod interface{}, podStatus interface{}, pullSecrets interface{}, backOff interface{}, restartAllContainers interface{}) *MockRuntime_SyncPod_Call {
	return &MockRuntime_SyncPod_Call{Call: _e.mock.On("SyncPod", ctx, pod, podStatus, pullSecrets, backOff, restartAllContainers)}
}

func (_c *MockRuntime_SyncPod_Call) Run(run func(ctx context.Context, pod *v10.Pod, podStatus *container.PodStatus, pullSecrets []v10.Secret, backOff *flowcontrol.Backoff, restartAllContainers bool)) *MockRuntime_SyncPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v10.Pod
		if args[1] != nil {
			arg1 = args[1].(*v10.Pod)
		}
		var arg2 *container.PodStatus
		if args[2] != nil {
			arg2 = args[2].(*container.PodStatus)
		}
		var arg3 []v10.Secret
		if args[3] != nil {
			arg3 = args[3].([]v10.Secret)
		}
		var arg4 *flowcontrol.Backoff
		if args[4] != nil {
			arg4 = args[4].(*flowcontrol.Backoff)
		}
		var arg5 bool
		if args[5] != nil {
			arg5 = args[5].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
		)
	})
	return _c
}

func (_c *MockRuntime_SyncPod_Call) Return(podSyncResult container.PodSyncResult) *MockRuntime_SyncPod_Call {
	_c.Call.Return(podSyncResult)
	return _c
}

func (_c *MockRuntime_SyncPod_Call) RunAndReturn(run func(ctx context.Context, pod *v10.Pod, podStatus *container.PodStatus, pullSecrets []v10.Secret, backOff *flowcontrol.Backoff, restartAllContainers bool) container.PodSyncResult) *MockRuntime_SyncPod_Call {
	_c.Call.Return(run)
	return _c
}

// Type provides a mock function for the type MockRuntime
func (_mock *MockRuntime) Type() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Type")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockRuntime_Type_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Type'
type MockRuntime_Type_Call struct {
	*mock.Call
}

// Type is a helper method to define mock.On call
func (_e *MockRuntime_Expecter) Type() *MockRuntime_Type_Call {
	return &MockRuntime_Type_Call{Call: _e.mock.On("Type")}
}

func (_c *MockRuntime_Type_Call) Run(run func()) *MockRuntime_Type_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRuntime_Type_Call) Return(s string) *MockRuntime_Type_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockRuntime_Type_Call) RunAndReturn(run func() string) *MockRuntime_Type_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateActuatedPodLevelResources provides a mock function for the type MockRuntime
func (_mock *MockRuntime) UpdateActuatedPodLevelResources(actuatedPod *v10.Pod) error {
	ret := _mock.Called(actuatedPod)

	if len(ret) == 0 {
		panic("no return value specified for UpdateActuatedPodLevelResources")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(*v10.Pod) error); ok {
		r0 = returnFunc(actuatedPod)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_UpdateActuatedPodLevelResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateActuatedPodLevelResources'
type MockRuntime_UpdateActuatedPodLevelResources_Call struct {
	*mock.Call
}

// UpdateActuatedPodLevelResources is a helper method to define mock.On call
//   - actuatedPod *v10.Pod
func (_e *MockRuntime_Expecter) UpdateActuatedPodLevelResources(actuatedPod interface{}) *MockRuntime_UpdateActuatedPodLevelResources_Call {
	return &MockRuntime_UpdateActuatedPodLevelResources_Call{Call: _e.mock.On("UpdateActuatedPodLevelResources", actuatedPod)}
}

func (_c *MockRuntime_UpdateActuatedPodLevelResources_Call) Run(run func(actuatedPod *v10.Pod)) *MockRuntime_UpdateActuatedPodLevelResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v10.Pod
		if args[0] != nil {
			arg0 = args[0].(*v10.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_UpdateActuatedPodLevelResources_Call) Return(err error) *MockRuntime_UpdateActuatedPodLevelResources_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_UpdateActuatedPodLevelResources_Call) RunAndReturn(run func(actuatedPod *v10.Pod) error) *MockRuntime_UpdateActuatedPodLevelResources_Call {
	_c.Call.Return(run)
	return _c
}

// UpdatePodCIDR provides a mock function for the type MockRuntime
func (_mock *MockRuntime) UpdatePodCIDR(ctx context.Context, podCIDR string) error {
	ret := _mock.Called(ctx, podCIDR)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePodCIDR")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = returnFunc(ctx, podCIDR)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntime_UpdatePodCIDR_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdatePodCIDR'
type MockRuntime_UpdatePodCIDR_Call struct {
	*mock.Call
}

// UpdatePodCIDR is a helper method to define mock.On call
//   - ctx context.Context
//   - podCIDR string
func (_e *MockRuntime_Expecter) UpdatePodCIDR(ctx interface{}, podCIDR interface{}) *MockRuntime_UpdatePodCIDR_Call {
	return &MockRuntime_UpdatePodCIDR_Call{Call: _e.mock.On("UpdatePodCIDR", ctx, podCIDR)}
}

func (_c *MockRuntime_UpdatePodCIDR_Call) Run(run func(ctx context.Context, podCIDR string)) *MockRuntime_UpdatePodCIDR_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntime_UpdatePodCIDR_Call) Return(err error) *MockRuntime_UpdatePodCIDR_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntime_UpdatePodCIDR_Call) RunAndReturn(run func(ctx context.Context, podCIDR string) error) *MockRuntime_UpdatePodCIDR_Call {
	_c.Call.Return(run)
	return _c
}

// Version provides a mock function for the type MockRuntime
func (_mock *MockRuntime) Version(ctx context.Context) (container.Version, error) {
	ret := _mock.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Version")
	}

	var r0 container.Version
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) (container.Version, error)); ok {
		return returnFunc(ctx)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) container.Version); ok {
		r0 = returnFunc(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(container.Version)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(ctx)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntime_Version_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Version'
type MockRuntime_Version_Call struct {
	*mock.Call
}

// Version is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRuntime_Expecter) Version(ctx interface{}) *MockRuntime_Version_Call {
	return &MockRuntime_Version_Call{Call: _e.mock.On("Version", ctx)}
}

func (_c *MockRuntime_Version_Call) Run(run func(ctx context.Context)) *MockRuntime_Version_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntime_Version_Call) Return(version container.Version, err error) *MockRuntime_Version_Call {
	_c.Call.Return(version, err)
	return _c
}

func (_c *MockRuntime_Version_Call) RunAndReturn(run func(ctx context.Context) (container.Version, error)) *MockRuntime_Version_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockRuntimeCache creates a new instance of MockRuntimeCache. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockRuntimeCache(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockRuntimeCache {
	mock := &MockRuntimeCache{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockRuntimeCache is an autogenerated mock type for the RuntimeCache type
type MockRuntimeCache struct {
	mock.Mock
}

type MockRuntimeCache_Expecter struct {
	mock *mock.Mock
}

func (_m *MockRuntimeCache) EXPECT() *MockRuntimeCache_Expecter {
	return &MockRuntimeCache_Expecter{mock: &_m.Mock}
}

// ForceUpdateIfOlder provides a mock function for the type MockRuntimeCache
func (_mock *MockRuntimeCache) ForceUpdateIfOlder(context1 context.Context, time1 time.Time) error {
	ret := _mock.Called(context1, time1)

	if len(ret) == 0 {
		panic("no return value specified for ForceUpdateIfOlder")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, time.Time) error); ok {
		r0 = returnFunc(context1, time1)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockRuntimeCache_ForceUpdateIfOlder_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ForceUpdateIfOlder'
type MockRuntimeCache_ForceUpdateIfOlder_Call struct {
	*mock.Call
}

// ForceUpdateIfOlder is a helper method to define mock.On call
//   - context1 context.Context
//   - time1 time.Time
func (_e *MockRuntimeCache_Expecter) ForceUpdateIfOlder(context1 interface{}, time1 interface{}) *MockRuntimeCache_ForceUpdateIfOlder_Call {
	return &MockRuntimeCache_ForceUpdateIfOlder_Call{Call: _e.mock.On("ForceUpdateIfOlder", context1, time1)}
}

func (_c *MockRuntimeCache_ForceUpdateIfOlder_Call) Run(run func(context1 context.Context, time1 time.Time)) *MockRuntimeCache_ForceUpdateIfOlder_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 time.Time
		if args[1] != nil {
			arg1 = args[1].(time.Time)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockRuntimeCache_ForceUpdateIfOlder_Call) Return(err error) *MockRuntimeCache_ForceUpdateIfOlder_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRuntimeCache_ForceUpdateIfOlder_Call) RunAndReturn(run func(context1 context.Context, time1 time.Time) error) *MockRuntimeCache_ForceUpdateIfOlder_Call {
	_c.Call.Return(run)
	return _c
}

// GetPods provides a mock function for the type MockRuntimeCache
func (_mock *MockRuntimeCache) GetPods(context1 context.Context) ([]*container.Pod, error) {
	ret := _mock.Called(context1)

	if len(ret) == 0 {
		panic("no return value specified for GetPods")
	}

	var r0 []*container.Pod
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context) ([]*container.Pod, error)); ok {
		return returnFunc(context1)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context) []*container.Pod); ok {
		r0 = returnFunc(context1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*container.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = returnFunc(context1)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockRuntimeCache_GetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPods'
type MockRuntimeCache_GetPods_Call struct {
	*mock.Call
}

// GetPods is a helper method to define mock.On call
//   - context1 context.Context
func (_e *MockRuntimeCache_Expecter) GetPods(context1 interface{}) *MockRuntimeCache_GetPods_Call {
	return &MockRuntimeCache_GetPods_Call{Call: _e.mock.On("GetPods", context1)}
}

func (_c *MockRuntimeCache_GetPods_Call) Run(run func(context1 context.Context)) *MockRuntimeCache_GetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockRuntimeCache_GetPods_Call) Return(pods []*container.Pod, err error) *MockRuntimeCache_GetPods_Call {
	_c.Call.Return(pods, err)
	return _c
}

func (_c *MockRuntimeCache_GetPods_Call) RunAndReturn(run func(context1 context.Context) ([]*container.Pod, error)) *MockRuntimeCache_GetPods_Call {
	_c.Call.Return(run)
	return _c
}
