/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_vec extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "àrabo";
        final String metaValue_hy = "armen";
        final String metaValue_ban = "balineze";
        final String metaValue_bug = "bugineze";
        final String metaValue_ccp = "ciakma";
        final String metaValue_doi = "dogri";
        final String metaValue_ka = "jeorjan";
        final String metaValue_el = "grego";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebràego";
        final String metaValue_jv = "javaneze";
        final String metaValue_ja = "japoneze";
        final String metaValue_ko = "corean";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_mak = "makasar";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayàlam";
        final String metaValue_mn = "móngolo";
        final String metaValue_my = "birman";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "orija";
        final String metaValue_osa = "osage";
        final String metaValue_si = "singaleze";
        final String metaValue_su = "sundaneze";
        final String metaValue_syr = "sirìago";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugo";
        final String metaValue_th = "tailandeze";
        final String metaValue_bo = "tibetan";
        final Object[][] data = new Object[][] {
            { "001", "mondo" },
            { "002", "Àfrega" },
            { "003", "Mèrega de’l nord" },
            { "005", "Mèrega de’l sud" },
            { "009", "Oseania" },
            { "011", "Àfrega osidentale" },
            { "013", "Mèrega sentrale" },
            { "014", "Àfrega orientale" },
            { "015", "Àfrega setentrionale" },
            { "017", "Àfrega sentrale" },
            { "018", "Àfrega meridionale" },
            { "019", "Mèreghe" },
            { "021", "Mèrega setentrionale" },
            { "029", "Caràibi" },
            { "030", "Azia orientale" },
            { "034", "Azia meridionale" },
            { "035", "Azia de’l sudest" },
            { "039", "Europa meridionale" },
            { "053", "Australazia" },
            { "054", "Melanezia" },
            { "057", "Rejon microneziana" },
            { "061", "Polinezia" },
            { "142", "Azia" },
            { "143", "Azia sentrale" },
            { "145", "Azia osidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa setentrionale" },
            { "155", "Europa osidentale" },
            { "202", "Àfrega subsahariana" },
            { "419", "Mèrega Latina" },
            { "AC", "Ìzola Asension" },
            { "AD", "Andora" },
            { "AE", "Emirài Àrabi Unìi" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antàrtide" },
            { "AR", "Arjentina" },
            { "AS", "Samòa meregane" },
            { "AT", "Àustria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Ìzole Aland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Boznia e Erzegòvina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Beljo" },
            { "BF", "Burkina Fazo" },
            { "BG", "Bulgarìa" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S. Bartolomèo" },
            { "BM", "Bermuda" },
            { "BN", "Brunéi" },
            { "BO", "Bolivia" },
            { "BQ", "Paezi Basi caraìbeghi" },
            { "BR", "Brazile" },
            { "BS", "Bahamas" },
            { "BT", "Butan" },
            { "BV", "Ìzola Buvet" },
            { "BW", "Botzwana" },
            { "BY", "Belorusia" },
            { "BZ", "Belize" },
            { "CA", "Cànada" },
            { "CC", "Ìzole Cocos (Keeling)" },
            { "CD", "Repùblega Democràtega de’l Congo" },
            { "CF", "Repùblega Sentrafregana" },
            { "CG", "Repùblega de’l Congo" },
            { "CH", "Zvìsara" },
            { "CI", "Costa d’Avorio" },
            { "CK", "Ìzole Cook" },
            { "CL", "Cile" },
            { "CM", "Càmerun" },
            { "CN", "Sina" },
            { "CO", "Colonbia" },
            { "CP", "Ìzola de Clipperton" },
            { "CQ", "Sarc" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cao Verdo" },
            { "CW", "Curaçao" },
            { "CX", "Ìzola de Nadale" },
            { "CY", "Sipro" },
            { "CZ", "Cechia" },
            { "DE", "Jermania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Danimarca" },
            { "DM", "Doménega" },
            { "DO", "Repùblega Domenegana" },
            { "DZ", "Aljerìa" },
            { "EA", "Ceuta e Melila" },
            { "EC", "Ècuador" },
            { "EE", "Estonia" },
            { "EG", "Ejito" },
            { "EH", "Sahara Osidentale" },
            { "ER", "Eritrèa" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Union europèa" },
            { "EZ", "Eurozona" },
            { "FI", "Finlanda" },
            { "FJ", "Fiji" },
            { "FK", "Ìzole Malvine" },
            { "FM", "Micronezia" },
            { "FO", "Ìzole Fàroe" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Regno Unìo" },
            { "GD", "Granada" },
            { "GE", "Jeorja" },
            { "GF", "Guyana franseze" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibiltera" },
            { "GL", "Groenlanda" },
            { "GM", "Ganbia" },
            { "GN", "Guinèa" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinèa Ecuatoriale" },
            { "GR", "Grecia" },
            { "GS", "Georgia de’l sud e Sandwich de’l sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinèa Bisào" },
            { "GY", "Guyana" },
            { "HK", "RAS de Hong Kong" },
            { "HM", "Ìzole Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croasia" },
            { "HT", "Haiti" },
            { "HU", "Ongarìa" },
            { "IC", "Ìzole Canarie" },
            { "ID", "Indonezia" },
            { "IE", "Irlanda" },
            { "IL", "Izraele" },
            { "IM", "Ìzola de Man" },
            { "IN", "India" },
            { "IO", "Teritorio britànego de l’Osèano Indian" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Izlanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamàega" },
            { "JO", "Jordania" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Canboja" },
            { "KI", "Kiribati" },
            { "KM", "Ìzole Comore" },
            { "KN", "S. Cristofer e Nevis" },
            { "KP", "Corèa de’l nord" },
            { "KR", "Corèa de’l sud" },
            { "KW", "Kuwait" },
            { "KY", "Ìzole Caiman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Lìbano" },
            { "LC", "S. Lusìa" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lezoto" },
            { "LT", "Lituania" },
            { "LU", "Lusenburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Maroco" },
            { "MC", "Mònaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "S. Martin (Fransa)" },
            { "MG", "Madagascar" },
            { "MH", "Ìzole Marshall" },
            { "MK", "Masedonia de’l nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "RAS de Macào" },
            { "MP", "Ìzole Mariane setentrionali" },
            { "MQ", "Martiniga" },
            { "MR", "Mauritania" },
            { "MS", "Montserat" },
            { "MT", "Malta" },
            { "MU", "Ìzole Maurisio" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Mèsego" },
            { "MY", "Malèizia" },
            { "MZ", "Mozanbigo" },
            { "NA", "Namibia" },
            { "NC", "Nova Caledonia" },
            { "NE", "Niger" },
            { "NF", "Ìzola Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Paezi Basi" },
            { "NO", "Norveja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Pànama" },
            { "PE", "Perù" },
            { "PF", "Polinezia franseze" },
            { "PG", "Papua Nova Guinèa" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "S. Piero e Michelon" },
            { "PN", "Ìzole Pitcairn" },
            { "PR", "Portorico" },
            { "PS", "Teritori palestinezi" },
            { "PT", "Portogalo" },
            { "PW", "Palàu" },
            { "PY", "Paraguài" },
            { "QA", "Catar" },
            { "QO", "Oseania perifèrega" },
            { "RE", "Ìzola Reunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudìa" },
            { "SB", "Ìzole Salomon" },
            { "SC", "Ìzole Seisel" },
            { "SD", "Sudan" },
            { "SE", "Zvesia" },
            { "SG", "Singapore" },
            { "SH", "Ìzola S. Èlena" },
            { "SI", "Zlovenia" },
            { "SJ", "Zvàlbard e Jan Mayen" },
            { "SK", "Zlovachia" },
            { "SL", "Siera Leon" },
            { "SM", "San Marin" },
            { "SN", "Sènegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sud Sudan" },
            { "ST", "S. Tomazo e Prìnsipe" },
            { "SV", "El Salvador" },
            { "SX", "S. Martin (Paezi Basi)" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Tristan de Cugna" },
            { "TC", "Turks e Caicos" },
            { "TD", "Ciad" },
            { "TF", "Teritori fransezi de’l sud" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelàu" },
            { "TL", "Timor Est" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizìa" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidà e Tabaco" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Ìzołe perifèreghe meregane" },
            { "UN", "Nasion Unìe" },
            { "US", "Stadi Unìi" },
            { "UY", "Uruguài" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vategan" },
            { "VC", "S. Vincenso e Granadine" },
            { "VE", "Venesuela" },
            { "VG", "Ìzole Vèrjini britàneghe" },
            { "VI", "Ìzole Vèrjini meregane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samòa" },
            { "XA", "Pseudo asenti" },
            { "XB", "Pseudo bidi" },
            { "XK", "Kòsovo" },
            { "YE", "Yemen" },
            { "YT", "Ìzole Maiote" },
            { "ZA", "Sudàfrega" },
            { "ZM", "Zanbia" },
            { "ZW", "Zinbawe" },
            { "ZZ", "Rejon desconosùa" },
            { "aa", "afar" },
            { "ab", "abcazo" },
            { "af", "afregan" },
            { "ak", "akan" },
            { "am", "amàrego" },
            { "an", "aragoneze" },
            { "ar", metaValue_ar },
            { "as", "asameze" },
            { "av", "avàrego" },
            { "ay", "aimar" },
            { "az", "azerbaijan" },
            { "ba", "bashkir" },
            { "be", "beloruso" },
            { "bg", "bùlgaro" },
            { "bi", "bizlama" },
            { "bm", "banbara" },
            { "bn", "bangla" },
            { "bo", metaValue_bo },
            { "br", "brètone" },
            { "bs", "boznìago" },
            { "ca", "catalan" },
            { "ce", "cecen" },
            { "ch", "ciamoro" },
            { "co", "corso" },
            { "cs", "seco" },
            { "cu", "zlavo de cieza" },
            { "cv", "ciuvash" },
            { "cy", "galeze" },
            { "da", "daneze" },
            { "de", "todesco" },
            { "dv", "maldivian" },
            { "dz", "dzongka" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ingleze" },
            { "eo", "esperanto" },
            { "es", "spagnolo" },
            { "et", "estonian" },
            { "eu", "basco" },
            { "fa", "persian" },
            { "ff", "fula" },
            { "fi", "filandeze" },
            { "fj", "fijan" },
            { "fo", "faroeze" },
            { "fr", "franseze" },
            { "fy", "frìzone osidentale" },
            { "ga", "irlandeze" },
            { "gd", "gaèlego scoseze" },
            { "gl", "galisian" },
            { "gn", "guaranì" },
            { "gu", metaValue_gu },
            { "gv", "maneze" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "croà" },
            { "ht", "haitian" },
            { "hu", "ongareze" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlengua" },
            { "id", "indonezian" },
            { "ie", "interlengue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuan" },
            { "io", "ido" },
            { "is", "izlandeze" },
            { "it", "italian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groelandeze" },
            { "km", "canbojan" },
            { "kn", "canareze" },
            { "ko", metaValue_ko },
            { "kr", "canuri" },
            { "ks", "cashmiri" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "còrnego" },
            { "ky", "kirghizo" },
            { "la", metaValue_la },
            { "lb", "lusenburgheze" },
            { "lg", "ganda" },
            { "li", "linburgheze" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lu", "luba katanga" },
            { "lv", "lètone" },
            { "mg", "malgaso" },
            { "mh", "marshaleze" },
            { "mi", "maori" },
            { "mk", "masèdone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "maleze" },
            { "mt", "malteze" },
            { "my", metaValue_my },
            { "na", "nauruan" },
            { "nb", "norvejeze bokmal" },
            { "nd", "ndebele de’l nord" },
            { "ne", "nepaleze" },
            { "ng", "ndonga" },
            { "nl", "olandeze" },
            { "nn", "norvejeze nynorsk" },
            { "no", "norvejeze" },
            { "nr", "ndebele de’l sud" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "ositan" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osètego" },
            { "pa", "punjabi" },
            { "pl", "polaco" },
            { "ps", "pashto" },
            { "pt", "portogheze" },
            { "qu", "cuechua" },
            { "rm", "romancio" },
            { "rn", "rundi" },
            { "ro", "romen" },
            { "ru", "ruso" },
            { "rw", "kiniarwanda" },
            { "sa", "sànscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami setentrionale" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "zlovaco" },
            { "sl", "zloven" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "sòmalo" },
            { "sq", "albaneze" },
            { "sr", "serbo" },
            { "ss", "zwati" },
            { "st", "soto meridionale" },
            { "su", metaValue_su },
            { "sv", "zvedeze" },
            { "sw", "suaili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tàjego" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turcoman" },
            { "tn", "tswana" },
            { "to", "tongan" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tàtaro" },
            { "ty", "taitian" },
            { "ug", "uigur" },
            { "uk", "ucrain" },
            { "ur", "urdu" },
            { "uz", "uzbego" },
            { "ve", "venda" },
            { "vi", "vietnameze" },
            { "vo", "volapük" },
            { "wa", "valon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yidish" },
            { "yo", "yoruba" },
            { "za", "zuan" },
            { "zh", "sineze" },
            { "zu", "zulu" },
            { "ace", "acineze" },
            { "ada", "adangme" },
            { "ady", "adighe" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleutian" },
            { "alt", "altài meridionale" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "àrabo levantin" },
            { "arn", "mapudungun" },
            { "arp", "arapào" },
            { "ars", "àrabo najdi" },
            { "asa", "asu" },
            { "ast", "asturian" },
            { "atj", "atikamec" },
            { "awa", "awadi" },
            { "bal", "baluci" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bem", "benba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bgc", "harianvi" },
            { "bgn", "baluci osidentale" },
            { "bho", "bojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "blt", "tai dam" },
            { "brx", "bodo" },
            { "bss", "akos" },
            { "bug", metaValue_bug },
            { "byn", "blin" },
            { "cad", "cado" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebuan" },
            { "cgg", "ciga" },
            { "chk", "ciukeze" },
            { "chm", "mari" },
            { "cho", "ciòctaw" },
            { "chp", "cìpejan" },
            { "chr", "cerokee" },
            { "chy", "ceyen" },
            { "cic", "cìcasow" },
            { "ckb", "curdo sentrale" },
            { "clc", "cìlcotin" },
            { "crg", "mecif" },
            { "crj", "cree sud orientale" },
            { "crk", "cree de le pianure" },
            { "crl", "cree nord orientale" },
            { "crm", "cree mose" },
            { "crr", "algonchin de la Carolina" },
            { "csw", "cree de le paludi" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", metaValue_doi },
            { "dsb", "baso sorabo" },
            { "dua", "duala" },
            { "dyo", "jola foni" },
            { "dzg", "dazaga" },
            { "ebu", "enbu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipin" },
            { "fon", "fon" },
            { "frc", "cadian" },
            { "frr", "frìzone setentrionale" },
            { "fur", "furlan" },
            { "gaa", "ga" },
            { "gez", "geez" },
            { "gil", "gilberteze" },
            { "gor", "gorontalo" },
            { "gsw", "todesco zvìsaro" },
            { "guz", "gusi" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "haw", "hawaian" },
            { "hax", "haida meridionale" },
            { "hil", "hiligheno" },
            { "hmn", "mong" },
            { "hnj", "mong novo" },
            { "hsb", "alto sorabo" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadeze osidentale" },
            { "ilo", "ilocan" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngonba" },
            { "jmc", "machame" },
            { "kaa", "caracalpago" },
            { "kab", "cabil" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kanba" },
            { "kbd", "cabardian" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "caoverdian" },
            { "ken", "keniang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra cini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kinbundu" },
            { "kok", "konkani" },
            { "kpe", "kpele" },
            { "krc", "karaciài balkar" },
            { "krl", "carelian" },
            { "kru", "kuruk" },
            { "ksb", "shanbala" },
            { "ksf", "bafia" },
            { "ksh", "colognian" },
            { "kum", "kumyk" },
            { "kwk", "Kwakwala" },
            { "kxv", "kuvi" },
            { "lad", "judezmo" },
            { "lag", "langi" },
            { "lez", "lezghian" },
            { "lij", "lìguro" },
            { "lil", "liluet" },
            { "lkt", "lacota" },
            { "lld", "ladin" },
            { "lmo", "lonbardo" },
            { "lou", "crèolo de la Luiziana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrionale" },
            { "lsm", "samia" },
            { "ltg", "letgalian" },
            { "lua", "luba lulua" },
            { "lun", "lunda" },
            { "luo", "doluó" },
            { "lus", "mizo" },
            { "luy", "luja" },
            { "mad", "madureze" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "mas", "masài" },
            { "mdf", "moksha" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "maurisian" },
            { "mgh", "meeto" },
            { "mgo", "meta" },
            { "mhn", "mòcheno" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipur" },
            { "moe", "inu aimun" },
            { "moh", "mohawk" },
            { "mos", "mosi" },
            { "mua", "mundang" },
            { "mul", "multilengua" },
            { "mus", "crek" },
            { "mwl", "mirandeze" },
            { "myv", "erzyen" },
            { "mzn", "mazandarani" },
            { "nap", "napoletan" },
            { "naq", "nama" },
            { "nds", "baso todesco" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niuean" },
            { "nmg", "kwazio" },
            { "nnh", "ngienbon" },
            { "nog", "nogài" },
            { "nqo", metaValue_nqo },
            { "nso", "soto setentrionale" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa nord osidentale" },
            { "ojc", "ojibwa sentrale" },
            { "ojs", "oji cree" },
            { "ojw", "ojibwa osidentale" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "pag", "pangasinan" },
            { "pam", "panpanga" },
            { "pap", "papiamento" },
            { "pau", "palauan" },
            { "pcm", "pidgin nijerian" },
            { "pis", "pijin" },
            { "pqm", "malesita pasamacuody" },
            { "prg", "prusian" },
            { "quc", "kish" },
            { "raj", "rajastani" },
            { "rap", "rapanui" },
            { "rar", "rarotongan" },
            { "rhg", "roinga" },
            { "rif", "rifegno" },
            { "rof", "ronbo" },
            { "rup", "aromen" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakuto" },
            { "saq", "sanburu" },
            { "sat", "santali" },
            { "sba", "nganbay" },
            { "sbp", "sangu" },
            { "scn", "sisilian" },
            { "sco", "scoseze" },
            { "sdh", "curdo meridionale" },
            { "seh", "sena" },
            { "ses", "koyraboro seni" },
            { "shi", "tashelit" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "skr", "saraiki" },
            { "slh", "lushootseed meridionale" },
            { "sma", "sami meridionale" },
            { "smj", "sami de’l Lule" },
            { "smn", "sami inarian" },
            { "sms", "sami skolt" },
            { "snk", "soninké" },
            { "srn", "sranan tongo" },
            { "ssy", "saho" },
            { "str", "salish streto" },
            { "suk", "sukuma" },
            { "swb", "comorian" },
            { "syr", metaValue_syr },
            { "szl", "silezian" },
            { "tce", "tutchone meridionale" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tétum" },
            { "tgx", "tagish" },
            { "tht", "taltan" },
            { "tig", "tigré" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "trw", "torwali" },
            { "ttm", "tutchone setentrionale" },
            { "tum", "tunbuka" },
            { "tvl", "tuvaluan" },
            { "twq", "tasawac" },
            { "tyv", "tuvinian" },
            { "tzm", "tamazigh de l’Atlante sentrale" },
            { "udm", "udmurto" },
            { "umb", "unbundu" },
            { "und", "lengua desconoscùa" },
            { "vec", "veneto" },
            { "vmw", "macùa" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmik" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yenba" },
            { "yrl", "nengatu" },
            { "yue", "cantoneze" },
            { "zgh", "tamazight standard de’l Maroco" },
            { "zun", "zuni" },
            { "zxx", "gnaun contegnùo lenguìstego" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Aghb", "albaneze caucàzego" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "amàrego inperiale" },
            { "Armn", metaValue_hy },
            { "Avst", "avèstego" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamun" },
            { "Bass", "vah" },
            { "Batk", "batak" },
            { "Beng", "bengaleze" },
            { "Bhks", "baiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabaro aborìjeno canadeze unifegà" },
            { "Cari", "cario" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Chrs", "corazmian" },
            { "Copt", "copto" },
            { "Cpmn", "sipro minòego" },
            { "Cprt", "siprioto" },
            { "Cyrl", "sirìlego" },
            { "Cyrs", "zlavo de cieza antigo" },
            { "Deva", "devanàgari" },
            { "Diak", "dives akuru" },
            { "Dogr", metaValue_doi },
            { "Dsrt", "deseret" },
            { "Dupl", "duployan stenografà" },
            { "Egyp", "jeroglìfeghi ejisiani" },
            { "Elba", "elbasan" },
            { "Elym", "elimàego" },
            { "Ethi", "etiòpego" },
            { "Gara", "garay" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolìtego" },
            { "Gong", "gunjala" },
            { "Gonm", "gondi masaram" },
            { "Goth", "gòtego" },
            { "Gran", "granta" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Gukh", "gurung khema" },
            { "Guru", "gurmuki" },
            { "Hanb", "han co bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "senpio" },
            { "Hant", "tradisionale" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "jeroglìfeghi anatòleghi" },
            { "Hmng", "pahaw hmong" },
            { "Hmnp", "niakeng puachu hmong" },
            { "Hrkt", "silabari japonezi" },
            { "Hung", "ongareze antigo" },
            { "Ital", "itàlego antigo" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katanaka" },
            { "Kawi", "kawi" },
            { "Khar", "karosti" },
            { "Khmr", "kmer" },
            { "Khoj", "kojiki" },
            { "Kits", "kitan celo" },
            { "Knda", "kanada" },
            { "Kore", metaValue_ko },
            { "Krai", "kirat rai" },
            { "Kthi", "kaiti" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latf", "latin fraktur" },
            { "Latg", "latin gaèlego" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "linbu" },
            { "Lina", "linear A" },
            { "Linb", "linear B" },
            { "Lisu", "fraser" },
            { "Lyci", "lisio" },
            { "Lydi", "lidio" },
            { "Mahj", "mahajan" },
            { "Maka", metaValue_mak },
            { "Mand", "mandàego" },
            { "Mani", "manighèo" },
            { "Marc", "marchen" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "meroìtego corsivo" },
            { "Mero", "meroìtego" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitéi" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "àrabo antigo de’l nord" },
            { "Nbat", "nabatèo" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nushu" },
            { "Ogam", "ogam" },
            { "Olck", "ol ciki" },
            { "Onao", "ol onal" },
            { "Orkh", "orcon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "ozmania" },
            { "Ougr", "uigur antigo" },
            { "Palm", "palmiren" },
            { "Pauc", "pau cin hau" },
            { "Perm", "pèrmego antigo" },
            { "Phag", "pagspa" },
            { "Phli", "palavo de le iscrision" },
            { "Phlp", "palavo saltero" },
            { "Phnx", "feniso" },
            { "Plrd", "fonètego de Pollard" },
            { "Prti", "parto de le iscrision" },
            { "Qaag", "zovghi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Runr", "rùnego" },
            { "Samr", "samaritan" },
            { "Sarb", "àrabo antigo de’l sud" },
            { "Saur", "saurashtra" },
            { "Sgnw", "scritura de i segni" },
            { "Shaw", "shavian" },
            { "Shrd", "sharada" },
            { "Sidd", "sidam" },
            { "Sind", "kudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "sogdian" },
            { "Sogo", "sogdian antigo" },
            { "Sora", "sora sonpeng" },
            { "Soyo", "soyonbo" },
            { "Sund", metaValue_su },
            { "Sunu", "sunuwar" },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "sirìago estrànjelo" },
            { "Syrj", "sirìago osidentale" },
            { "Syrn", "sirìago orientale" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lu senpio" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinag" },
            { "Tglg", "tagalog" },
            { "Thaa", "thana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tiruta" },
            { "Tnsa", "tangsa" },
            { "Todr", "todhri" },
            { "Toto", "toto" },
            { "Tutg", "tigalari" },
            { "Ugar", "ugarìtego" },
            { "Vaii", "vai" },
            { "Vith", "beita kukju" },
            { "Wara", "warang siti" },
            { "Wcho", "wancho" },
            { "Xpeo", "persian antigo" },
            { "Xsux", "cugniforme sumero acadian" },
            { "Yezi", "yezidi" },
            { "Yiii", "yi" },
            { "Zanb", "zanabazar cuadrà" },
            { "Zinh", "redità" },
            { "Zmth", "notasion matemàtega" },
            { "Zsye", "emoji" },
            { "Zsym", "sìnboli" },
            { "Zxxx", "miga scrito" },
            { "Zyyy", "comun" },
            { "Zzzz", "desconosùo" },
            { "de_AT", "todesco austrìago" },
            { "de_CH", "alto todesco zvìsaro" },
            { "en_AU", "ingleze australian" },
            { "en_CA", "ingleze canadeze" },
            { "en_GB", "ingleze britànego" },
            { "en_US", "ingleze meregan" },
            { "fa_AF", "dari" },
            { "fr_CA", "franseze canadeze" },
            { "fr_CH", "franseze zvìsaro" },
            { "nl_BE", "fiamingo" },
            { "pt_BR", "portogheze braziłian" },
            { "pt_PT", "portogheze europèo" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "suaili de’l Congo" },
            { "%%1996", "ortografìa todesca de’l 1996" },
            { "ar_001", "àrabo moderno standard" },
            { "key.ca", "lunaro" },
            { "key.cf", "formà moneda" },
            { "key.co", "òrdane" },
            { "key.cu", "moneda" },
            { "key.hc", "sistema ore (12/24)" },
            { "key.lb", "stile de cao de linea" },
            { "key.ms", "sistema de mezurasion" },
            { "key.nu", "Nùmari" },
            { "nds_NL", "sàsone baso" },
            { "%%ALUKU", "dialeto aluku" },
            { "%%BARLA", "dialeto barlavento de’l caoverdian" },
            { "%%BOONT", "bontling" },
            { "%%KKCOR", "ortografìa comun" },
            { "%%NJIVA", "dialeto Gniva" },
            { "%%POSIX", "informàtega" },
            { "%%RIGIK", "volapuk clàsego" },
            { "%%DAJNKO", "alfabeto Dajnko" },
            { "%%FONIPA", "alfabeto fonètego internasionale IPA" },
            { "%%ALALC97", "romanizasion ALA-LC, varsion 1997" },
            { "%%BALANKA", "dialeto balanka de l’Anii" },
            { "%%BOHORIC", "alfabeto bohoric" },
            { "%%EMODENG", "ingleze moderno bonorivo" },
            { "%%HEPBURN", "romanizasion Hepburn" },
            { "%%1606NICT", "franseze mezo tardivo fin el 1606" },
            { "%%1694ACAD", "franseze moderno bonorivo" },
            { "%%1959ACAD", "acadèmego" },
            { "type.ca.roc", "lunaro mìnguo" },
            { "type.hc.h11", "sistema a 12 ore (0–11)" },
            { "type.hc.h12", "sistema a 12 ore (1–12)" },
            { "type.hc.h23", "sistema a 24 ore (0–23)" },
            { "type.hc.h24", "sistema a 12 ore (1–24)" },
            { "type.nu.arab", "Nùmari in indo àrabo" },
            { "type.nu.armn", "Nùmari in armen" },
            { "type.nu.beng", "Nùmari in bengaleze" },
            { "type.nu.cakm", "Nùmari in ciakma" },
            { "type.nu.deva", "Nùmari in devanàgari" },
            { "type.nu.ethi", "Nùmari in etiòpego" },
            { "type.nu.geor", "Nùmari in jeorjan" },
            { "type.nu.grek", "Nùmari in grego" },
            { "type.nu.gujr", "Nùmari in gujarati" },
            { "type.nu.guru", "Nùmari in gurmuki" },
            { "type.nu.hans", "Nùmari in sineze senpio" },
            { "type.nu.hant", "Nùmari in sineze tradisionale" },
            { "type.nu.hebr", "Nùmari in ebràego" },
            { "type.nu.java", "Nùmari in javaneze" },
            { "type.nu.jpan", "Nùmari in japoneze" },
            { "type.nu.khmr", "Nùmari in kmer" },
            { "type.nu.knda", "Nùmari in kanada" },
            { "type.nu.laoo", "Nùmari in lao" },
            { "type.nu.latn", "Nùmari osidentali" },
            { "type.nu.mlym", "Nùmari in malayàlam" },
            { "type.nu.mtei", "Nùmari in meitéi" },
            { "type.nu.mymr", "Nùmari in birman" },
            { "type.nu.olck", "Nùmari in ol ciki" },
            { "type.nu.orya", "Nùmari in orija" },
            { "type.nu.taml", "Nùmari in tamil tradisionale" },
            { "type.nu.telu", "Nùmari in telugo" },
            { "type.nu.thai", "Nùmari in tailandeze" },
            { "type.nu.tibt", "Nùmari tibetani" },
            { "type.nu.vaii", "Nùmari in vai" },
            { "type.ca.dangi", "lunaro dangi" },
            { "type.co.ducet", "òrdane predefenìo Unicode" },
            { "type.lb.loose", "cao de linea opsionale" },
            { "type.nu.roman", "Nùmari romani" },
            { "type.ca.coptic", "lunaro còptego" },
            { "type.ca.hebrew", "lunaro ebràego" },
            { "type.co.search", "reserca jenèrega" },
            { "type.lb.normal", "cao de linea normale" },
            { "type.lb.strict", "cao de linea forsà" },
            { "type.ms.metric", "sistema mètrego" },
            { "type.ca.chinese", "lunaro sineze" },
            { "type.ca.islamic", "lunaro izlàmego" },
            { "type.ca.iso8601", "lunaro ISO-8601" },
            { "type.ca.persian", "lunaro persian" },
            { "type.cf.account", "formà moneda contàbile" },
            { "type.nu.arabext", "Nùmari estendesti in indo àrabo" },
            { "type.nu.armnlow", "Nùmari minùscoli in armen" },
            { "type.nu.greklow", "Nùmari minùscoli in grego" },
            { "type.nu.hanidec", "Nùmari desimali in sineze" },
            { "type.nu.hansfin", "Nùmari finansiari in sineze senpio" },
            { "type.nu.hantfin", "Nùmari finansiari in sineze tradisionale" },
            { "type.nu.jpanfin", "Nùmari finansiari in japoneze" },
            { "type.nu.tamldec", "Nùmari in tamil" },
            { "type.ca.buddhist", "lunaro budista" },
            { "type.ca.ethiopic", "lunaro etiòpego" },
            { "type.ca.japanese", "lunaro japoneze" },
            { "type.cf.standard", "formà moneda standard" },
            { "type.co.standard", "òrdane standard" },
            { "type.ms.uksystem", "sistema inperiale" },
            { "type.ms.ussystem", "sistema meregan" },
            { "type.nu.fullwide", "Nùmari a larghesa piena" },
            { "type.nu.romanlow", "Nùmari minùscoli romani" },
            { "type.ca.gregorian", "lunaro gregorian" },
            { "type.ca.islamic-civil", "lunaro izlàmego (tabular)" },
            { "type.ca.islamic-umalqura", "lunaro izlàmego (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "lunaro etiòpego (amete alem)" },
        };
        return data;
    }
}
