/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mai extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रीनविच मीन टाइम",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Cuba = new String[] {
               "क्यूबा मानक टाइम",
               "CST",
               "क्यूबा डेलाइट टाइम",
               "CDT",
               "क्यूबा टाइम",
               "CT",
            };
        final String[] Gulf = new String[] {
               "गल्फ मानक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "होब्द मानक टाइम",
               "",
               "होब्द समर टाइम",
               "",
               "होब्द टाइम",
               "",
            };
        final String[] Iran = new String[] {
               "ईरानमानक टाइम",
               "",
               "ईरान डेलाइट टाइम",
               "",
               "ईरान टाइम",
               "",
            };
        final String[] Omsk = new String[] {
               "ओम्स्क मानक टाइम",
               "",
               "ओम्स्क समर टाइम",
               "",
               "ओम्स्क टाइम",
               "",
            };
        final String[] Peru = new String[] {
               "पेरू मानक टाइम",
               "",
               "पेरू समर टाइम",
               "",
               "पेरू टाइम",
               "",
            };
        final String[] Chile = new String[] {
               "चिली मानक टाइम",
               "",
               "चिली समर टाइम",
               "",
               "चिली टाइम",
               "",
            };
        final String[] China = new String[] {
               "चीनी मानत टाइम",
               "CST",
               "चीनी डेलाइट टाइम",
               "CDT",
               "चीनी टाइम",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कोकोस द्वीप टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "भारतीय मानक समय",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जापान मानक टाइम",
               "JST",
               "जापान डेलाइट टाइम",
               "JDT",
               "जापान टाइम",
               "JT",
            };
        final String[] Korea = new String[] {
               "कोरियन मानक टाइम",
               "KST",
               "कोरियन डेलाइट टाइम",
               "KST",
               "कोरियन टाइम",
               "KST",
            };
        final String[] Nepal = new String[] {
               "नेपाल टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "सामोआ मानक समय",
               "SST",
               "सामोआ समर समय",
               "SST",
               "सामोआ समय",
               "SST",
            };
        final String[] Yukon = new String[] {
               "यूकोन टाइम",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "अलास्का मानक समय",
               "AKST",
               "अलास्का डेलाइट समय",
               "AKDT",
               "अलास्का समय",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "अमेजन मानक टाइम",
               "",
               "अमेजन समर टाइम",
               "",
               "अमेजन टाइम",
               "",
            };
        final String[] Azores = new String[] {
               "एजोर्स मानक टाइम",
               "",
               "एजोर्स समर टाइम",
               "",
               "एजोर्स टाइम",
               "",
            };
        final String[] Bhutan = new String[] {
               "भूटान टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रूनेई दारेसलाम टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ईस्टर आइलैंड मानक टाइम",
               "",
               "ईस्टर आइलैंड समर टाइम",
               "",
               "ईस्टर आइलैंड टाइम",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "हवाई-एल्यूटियन मानक टाइम",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "इजरायल मानक टाइम",
               "IST",
               "इजरायल डेलाइट टाइम",
               "IDT",
               "इजरायल टाइम",
               "IT",
            };
        final String[] Moscow = new String[] {
               "मास्को मानक टाइम",
               "MSK",
               "मास्को समर टाइम",
               "MSK",
               "मास्को टाइम",
               "MSK",
            };
        final String[] Taipei = new String[] {
               "ताइपेई मानक टाइम",
               "CST",
               "ताइपेई डेलाइट टाइम",
               "CDT",
               "ताइपेई टाइम",
               "CT",
            };
        final String[] Arabian = new String[] {
               "अरेबियन मानक टाइम",
               "",
               "अरेबियन डेलाइट टाइम",
               "",
               "अरेबियन टाइम",
               "",
            };
        final String[] Armenia = new String[] {
               "आर्मेनिया मानक टाइम",
               "",
               "आर्मेनिया समर टाइम",
               "",
               "आर्मेनिया टाइम",
               "",
            };
        final String[] Bolivia = new String[] {
               "बोलीबिया टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "चेथम मानक टाइम",
               "",
               "चेथम डेलाइट टाइम",
               "",
               "चेथम टाइम",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "समन्वित वैश्विक समय",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "इक्वाडोर टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जार्जिया मानक टाइम",
               "",
               "जार्जिया समर टाइम",
               "",
               "जार्जिया टाइम",
               "",
            };
        final String[] Irkutsk = new String[] {
               "इरकूत्स्क मानक टाइम",
               "",
               "इरकूत्स्क समर टाइम",
               "",
               "इरकूत्स्क टाइम",
               "",
            };
        final String[] Magadan = new String[] {
               "मगादान मानक टाइम",
               "",
               "मगादान समर टाइम",
               "",
               "मगादान टाइम",
               "",
            };
        final String[] Myanmar = new String[] {
               "मयनमार टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "फाकलैंड द्वीप मानक टाइम",
               "",
               "फाकलैंड द्वीप डेलाइट टाइम",
               "",
               "फाकलैंड द्वीप टाइम",
               "",
            };
        final String[] Noronha = new String[] {
               "फर्नेंडो डी नोरोन्हा मानक टाइम",
               "",
               "फर्नेंडो डी नोरोन्हा समर टाइम",
               "",
               "फर्नेंडो डी नोरोन्हा टाइम",
               "",
            };
        final String[] Reunion = new String[] {
               "रियूनियन टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरुग्वे मानक टाइम",
               "",
               "उरुग्वे समर टाइम",
               "",
               "उरुग्वे टाइम",
               "",
            };
        final String[] Yakutsk = new String[] {
               "यकुत्स्क मानक टाइम",
               "",
               "यकुत्स्क समर टाइम",
               "",
               "यकुत्स्क टाइम",
               "",
            };
        final String[] Atlantic = new String[] {
               "अटलांटिक मानक समय",
               "AST",
               "अटलांटिक डेलाइट समय",
               "AST",
               "अटलांटिक समय",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राजीलिया मानक टाइम",
               "",
               "ब्राजीलिया समर टाइम",
               "",
               "ब्राजीलिया टाइम",
               "",
            };
        final String[] Colombia = new String[] {
               "कोलंबिया मानक टाइम",
               "",
               "कोलंबिया समर टाइम",
               "",
               "कोलंबिया टाइम",
               "",
            };
        final String[] Falkland = new String[] {
               "फाकलैंड आइलैंड मानक टाइम",
               "",
               "फाकलैंड आइलैंड समर टाइम",
               "",
               "फाकलैंड आइलैंड टाइम",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेशिया टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "मालदीव टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलनबटोर मानक टाइम",
               "",
               "उलनबटोर समर टाइम",
               "",
               "उलनबटोर टाइम",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्तान मानक टाइम",
               "PKT",
               "पाकिस्तान समर टाइम",
               "PKST",
               "पाकिस्तान टाइम",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "पराग्वे मानक टाइम",
               "",
               "पराग्वे समर टाइम",
               "",
               "पराग्वे टाइम",
               "",
            };
        final String[] Suriname = new String[] {
               "सुरीनाम टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "अर्जेंटीना मानक टाइम",
               "",
               "अर्जेंटीना समर टाइम",
               "",
               "अर्जेंटीना टाइम",
               "",
            };
        final String[] Christmas = new String[] {
               "क्रिसमस द्वीप टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "गैलापैगोस टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हांग कांग मानक टाइम",
               "HKT",
               "हांग कांग समर टाइम",
               "HKST",
               "हांग कांग टाइम",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "इंडोचाइना टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "किर्गिस्तान",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लार्ड होबे मानक टाइम",
               "",
               "लार्ड होबे डेलाइट टाइम",
               "",
               "लार्ड होबे टाइम",
               "",
            };
        final String[] Mauritius = new String[] {
               "मारीशस मानक टाइम",
               "",
               "मारीशस समर टाइम",
               "",
               "मारीशस टाइम",
               "",
            };
        final String[] Singapore = new String[] {
               "सिंगापुर मानक टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "बेनेजुएला टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "अजरबैजान मानक टाइम",
               "",
               "अजरबैजान समर टाइम",
               "",
               "अजरबैजान टाइम",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बंगलादेश मानक टाइम",
               "",
               "बंगलादेश समर टाइम",
               "",
               "बंगलादेश टाइम",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप बर्ड मानक टाइम",
               "",
               "केप बर्ड समर टाइम",
               "",
               "केप बर्डे टाइम",
               "",
            };
        final String[] East_Timor = new String[] {
               "पूरबी तिमोर टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेशेल्स टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ताजिकिस्तान",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उजबेकिस्तान मानक टाइम",
               "",
               "उजबेकिस्तान समर टाइम",
               "",
               "उजबेकिस्तान टाइम",
               "",
            };
        final String[] Afghanistan = new String[] {
               "अफगानिस्तान टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रेस्नोयार्स्क मानक टाइम",
               "",
               "क्रेस्नोयार्स्क समर टाइम",
               "",
               "क्रेस्नोयार्स्क",
               "",
            };
        final String[] New_Zealand = new String[] {
               "न्यूजीलैंड मानक टाइम",
               "NZST",
               "न्यूजीलैंड डेलाइट टाइम",
               "NZDT",
               "न्यूजीलैंड टाइम",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "फिलिपीन मानक टाइम",
               "PST",
               "फिलिपीन समर टाइम",
               "PDT",
               "फिलिपीन टाइम",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ब्लादिबोस्तोक मानक टाइम",
               "",
               "ब्लादिबोस्तोक समर टाइम",
               "",
               "ब्लादिबोस्तोक टाइम",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "हिंद महासागर टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "न्यूफाउंडलैंड मानक टाइम",
               "NST",
               "न्यूफाउंडलैंड डेलाइट टाइम",
               "NDT",
               "न्यूफाउंडलैंड टाइम",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनिस्तान मानक टाइम",
               "",
               "तुर्कमेनिस्तान समर टाइम",
               "",
               "तुर्कमेनिस्तान टाइम",
               "",
            };
        final String[] French_Guiana = new String[] {
               "फ्रेंच गुयाना टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "न्यू केलैडोनिया मानक समय",
               "",
               "न्यू केलैडोनिया डेलाइट समय",
               "",
               "न्यू केलैडोनिया समय",
               "",
            };
        final String[] South_Georgia = new String[] {
               "दक्षिण जार्जिया टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकाटैरिनबर्ग मानक टाइम",
               "",
               "येकाटैरिनबर्ग समर टाइम",
               "",
               "येकाटैरिनबर्ग टाइम",
               "",
            };
        final String[] Africa_Central = new String[] {
               "मध्य अफ्रीका टाइम",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "पूरब अफ्रीका टाइम",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "पश्चिम अफ्रीका टाइम",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] Europe_Central = new String[] {
               "मध्य यूरोपीय मानक समय",
               "CET",
               "मध्‍य यूरोपीय ग्रीष्‍मकालीन समय",
               "CEST",
               "मध्य यूरोपीय समय",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "पूर्वी यूरोपीय मानक समय",
               "EET",
               "पूर्वी यूरोपीय ग्रीष्मकालीन समय",
               "EEST",
               "पूर्वी यूरोपीय समय",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "पश्चिमी यूरोपीय मानक समय",
               "WET",
               "पश्चिमी यूरोपीय ग्रीष्‍मकालीन समय",
               "WEST",
               "पश्चिमी यूरोपीय समय",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मैक्सिकन पेसिफिक मानक टाइम",
               "MST",
               "मैक्सिकन पेसिफिक डेलाइट टाइम",
               "MDT",
               "मैक्सिकन पेसिफिक टाइम",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "दक्षिण अफ्रीका मानक टाइम",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "उत्तरी अमेरिकी केंद्रीय मानक समय",
               "CST",
               "उत्तरी अमेरिकी केंद्रीय डेलाइट समय",
               "CDT",
               "उत्तरी अमेरिकी केंद्रीय समय",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "उत्तरी अमेरिकी पूर्वी मानक समय",
               "EST",
               "उत्तरी अमेरिकी पूर्वी डेलाइट समय",
               "EST",
               "उत्तरी अमेरिकी पूर्वी समय",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "उत्तरी अमेरिकी प्रशांत मानक समय",
               "PST",
               "उत्तरी अमेरिकी प्रशांत डेलाइट समय",
               "PDT",
               "उत्तरी अमेरिकी प्रशांत समय",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "फ़्रांसीसी दक्षिणी क्षेत्र आ अंटार्कटिक टाइम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हवाई-एल्यूटियन मानक टाइम",
               "HST",
               "हवाई-एल्यूटियन डेलाइट टाइम",
               "HDT",
               "हवाई-एल्यूटियन टाइम",
               "HT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सेंट पिएरे आ मिक्वेलान मानक टाइम",
               "",
               "सेंट पिएरे आ मिक्वेलान डेलाइट टाइम",
               "",
               "सेंट पिएरे आ मिक्वेलान टाइम",
               "",
            };
        final String[] America_Mountain = new String[] {
               "उत्तरी अमेरिकी माउंटेन मानक समय",
               "MST",
               "उत्तरी अमेरिकी माउंटेन डेलाइट समय",
               "MST",
               "उत्तरी अमेरिकी माउंटेन समय",
               "MST",
            };
        final String[] Australia_Central = new String[] {
               "आस्ट्रेलियाई मध्य मानक टाइम",
               "ACST",
               "आस्ट्रेलियाई मध्य डेलाइट टाइम",
               "ACDT",
               "मध्य आस्ट्रेलिया टाइम",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "आस्ट्रेलियाई पूरबी मानक टाइम",
               "AEST",
               "आस्ट्रेलियाई पूरबी डेलाइट टाइम",
               "AEDT",
               "पूरबी आस्ट्रेलिया टाइम",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "आस्ट्रेलियाई पश्चिमी मानक टाइम",
               "AWST",
               "आस्ट्रेलियाई पश्चिमी डेलाइट टाइम",
               "AWDT",
               "पश्चिमी आस्ट्रेलिया टाइम",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "मध्य इंडोनेशिया टाइम",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "पूरबी इंडोनेशिया टाइम",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "पश्चिमी इंडोनेशिया टाइम",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "आस्ट्रेलियाई मध्य पश्चिमी मानक टाइम",
               "",
               "आस्ट्रेलियाई मध्य पश्चिमी डेलाइट टाइम",
               "",
               "आस्ट्रेलियाई मध्य पश्चिमी टाइम",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB", GMT },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "UCT",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire", GMT },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire", GMT },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "समन्वित वैश्विक समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Pago_Pago", Samoa },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "timezone.excity.Asia/Aden", "अदन" },
            { "timezone.excity.Asia/Baku", "बाकू" },
            { "timezone.excity.Asia/Dili", "डिली" },
            { "timezone.excity.Asia/Gaza", "गाजा" },
            { "timezone.excity.Asia/Hovd", "होब्द" },
            { "timezone.excity.Asia/Omsk", "ओमस्क" },
            { "timezone.excity.Asia/Oral", "ओराल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "अम्मान" },
            { "timezone.excity.Asia/Aqtau", "अक्ताउ" },
            { "timezone.excity.Asia/Chita", "चिता" },
            { "timezone.excity.Asia/Dhaka", "ढाका" },
            { "timezone.excity.Asia/Dubai", "दुबई" },
            { "timezone.excity.Asia/Kabul", "काबुल" },
            { "timezone.excity.Asia/Macau", "मकाऊ" },
            { "timezone.excity.Asia/Qatar", "कतर" },
            { "timezone.excity.Asia/Seoul", "सियोल" },
            { "timezone.excity.Asia/Tokyo", "टोक्यो" },
            { "timezone.excity.Asia/Tomsk", "टोम्स" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लोम" },
            { "timezone.excity.Asia/Almaty", "अल्माती" },
            { "timezone.excity.Asia/Anadyr", "एनाडिर" },
            { "timezone.excity.Asia/Aqtobe", "अक्तोब" },
            { "timezone.excity.Asia/Atyrau", "अतिराउ" },
            { "timezone.excity.Asia/Beirut", "बेरूत" },
            { "timezone.excity.Asia/Brunei", "ब्रूनेई" },
            { "timezone.excity.Asia/Hebron", "हैब्रान" },
            { "timezone.excity.Asia/Kuwait", "कुवैत" },
            { "timezone.excity.Asia/Manila", "मनीला" },
            { "timezone.excity.Asia/Muscat", "मस्कट" },
            { "timezone.excity.Asia/Riyadh", "रियाद" },
            { "timezone.excity.Asia/Saigon", "हो ची मिन्ह सिटी" },
            { "timezone.excity.Asia/Taipei", "ताइपेई" },
            { "timezone.excity.Asia/Tehran", "तेहरान" },
            { "timezone.excity.Asia/Urumqi", "उरूमकी" },
            { "timezone.excity.Etc/Unknown", "अज्ञात शहर" },
            { "timezone.excity.Europe/Kiev", "कीव" },
            { "timezone.excity.Europe/Oslo", "ओस्लो" },
            { "timezone.excity.Europe/Riga", "रिगा" },
            { "timezone.excity.Europe/Rome", "रोम" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "अकरा" },
            { "timezone.excity.Africa/Cairo", "काहिरा" },
            { "timezone.excity.Africa/Ceuta", "सिउता" },
            { "timezone.excity.Africa/Dakar", "डकार" },
            { "timezone.excity.Africa/Lagos", "लागोस" },
            { "timezone.excity.Africa/Tunis", "ट्यूनिस" },
            { "timezone.excity.America/Adak", "अदक" },
            { "timezone.excity.America/Lima", "लीमा" },
            { "timezone.excity.America/Nome", "नोम" },
            { "timezone.excity.Asia/Baghdad", "बगदाद" },
            { "timezone.excity.Asia/Bahrain", "बहरीन" },
            { "timezone.excity.Asia/Bangkok", "बैंकाक" },
            { "timezone.excity.Asia/Barnaul", "बर्नोल" },
            { "timezone.excity.Asia/Bishkek", "बिश्केक" },
            { "timezone.excity.Asia/Colombo", "कोलम्बो" },
            { "timezone.excity.Asia/Irkutsk", "इरकुस्क" },
            { "timezone.excity.Asia/Jakarta", "जकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कुचिंग" },
            { "timezone.excity.Asia/Magadan", "मगादान" },
            { "timezone.excity.Asia/Nicosia", "निकोशिया" },
            { "timezone.excity.Asia/Rangoon", "यांगुन" },
            { "timezone.excity.Asia/Tbilisi", "टबिलिसि" },
            { "timezone.excity.Asia/Thimphu", "थिम्पू" },
            { "timezone.excity.Asia/Yakutsk", "युकुत्स्क" },
            { "timezone.excity.Asia/Yerevan", "यैरेबन" },
            { "timezone.excity.Europe/Kirov", "किरोव" },
            { "timezone.excity.Europe/Malta", "मालटा" },
            { "timezone.excity.Europe/Minsk", "मिन्सक" },
            { "timezone.excity.Europe/Paris", "पेरिस" },
            { "timezone.excity.Europe/Sofia", "सोफिया" },
            { "timezone.excity.Europe/Vaduz", "बेदुज" },
            { "timezone.excity.Indian/Cocos", "कोकोस" },
            { "timezone.excity.Africa/Asmera", "असमारा" },
            { "timezone.excity.Africa/Bamako", "बमाको" },
            { "timezone.excity.Africa/Bangui", "बंगुई" },
            { "timezone.excity.Africa/Banjul", "बंजुल" },
            { "timezone.excity.Africa/Bissau", "बिसाऊ" },
            { "timezone.excity.Africa/Douala", "डाउला" },
            { "timezone.excity.Africa/Harare", "हरारे" },
            { "timezone.excity.Africa/Kigali", "किगाली" },
            { "timezone.excity.Africa/Luanda", "लुआंडा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मलाबो" },
            { "timezone.excity.Africa/Maputo", "मपूतो" },
            { "timezone.excity.Africa/Maseru", "मसैरू" },
            { "timezone.excity.Africa/Niamey", "नियामेय" },
            { "timezone.excity.America/Aruba", "अरूबा" },
            { "timezone.excity.America/Bahia", "बहिया" },
            { "timezone.excity.America/Belem", "बैलैम" },
            { "timezone.excity.America/Boise", "बोयजी" },
            { "timezone.excity.America/Jujuy", "जुजुय" },
            { "timezone.excity.America/Sitka", "सितका" },
            { "timezone.excity.America/Thule", "तुले" },
            { "timezone.excity.Asia/Ashgabat", "अश्गाबात" },
            { "timezone.excity.Asia/Calcutta", "कोलकाता" },
            { "timezone.excity.Asia/Damascus", "दमिश्क" },
            { "timezone.excity.Asia/Dushanbe", "दुशांबे" },
            { "timezone.excity.Asia/Jayapura", "जयापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमांडू" },
            { "timezone.excity.Asia/Khandyga", "खांध्यगा" },
            { "timezone.excity.Asia/Makassar", "मकासार" },
            { "timezone.excity.Asia/Qostanay", "कोस्ताने" },
            { "timezone.excity.Asia/Sakhalin", "साकलिन" },
            { "timezone.excity.Asia/Shanghai", "शांघाई" },
            { "timezone.excity.Asia/Tashkent", "ताशकंद" },
            { "timezone.excity.Asia/Ust-Nera", "उस्त-नेरा" },
            { "timezone.excity.Europe/Athens", "एथेंस" },
            { "timezone.excity.Europe/Berlin", "बर्लिन" },
            { "timezone.excity.Europe/Dublin", "डबलिन" },
            { "timezone.excity.Europe/Jersey", "जर्सी" },
            { "timezone.excity.Europe/Lisbon", "लिसबन" },
            { "timezone.excity.Europe/London", "लंदन" },
            { "timezone.excity.Europe/Madrid", "मेड्रिड" },
            { "timezone.excity.Europe/Monaco", "मोनेको" },
            { "timezone.excity.Europe/Moscow", "मास्को" },
            { "timezone.excity.Europe/Prague", "प्राग" },
            { "timezone.excity.Europe/Samara", "समारा" },
            { "timezone.excity.Europe/Skopje", "स्कोपये" },
            { "timezone.excity.Europe/Tirane", "टिराने" },
            { "timezone.excity.Europe/Vienna", "बिएना" },
            { "timezone.excity.Europe/Warsaw", "बारसा" },
            { "timezone.excity.Europe/Zagreb", "जगरैब" },
            { "timezone.excity.Europe/Zurich", "ज्यूरिख" },
            { "timezone.excity.Indian/Chagos", "चगोस" },
            { "timezone.excity.Indian/Comoro", "कोमोरो" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अबिजान" },
            { "timezone.excity.Africa/Algiers", "अल्जीयर्स" },
            { "timezone.excity.Africa/Conakry", "कोनाक्री" },
            { "timezone.excity.Africa/Kampala", "कमपाला" },
            { "timezone.excity.Africa/Mbabane", "मेंबाबाने" },
            { "timezone.excity.Africa/Nairobi", "नैरोबी" },
            { "timezone.excity.Africa/Tripoli", "त्रिपोली" },
            { "timezone.excity.America/Belize", "बेलिज" },
            { "timezone.excity.America/Bogota", "बोगोटा" },
            { "timezone.excity.America/Cancun", "कानकुन" },
            { "timezone.excity.America/Cayman", "कैमेन" },
            { "timezone.excity.America/Cuiaba", "कुयाबा" },
            { "timezone.excity.America/Dawson", "डाउसन" },
            { "timezone.excity.America/Denver", "डेनबर" },
            { "timezone.excity.America/Guyana", "गुयाना" },
            { "timezone.excity.America/Havana", "हवाना" },
            { "timezone.excity.America/Inuvik", "इनुबिक" },
            { "timezone.excity.America/Juneau", "जुनेउ" },
            { "timezone.excity.America/La_Paz", "ला पाज" },
            { "timezone.excity.America/Maceio", "मसीयो" },
            { "timezone.excity.America/Manaus", "मनौस" },
            { "timezone.excity.America/Merida", "मैरिडा" },
            { "timezone.excity.America/Nassau", "नसाउ" },
            { "timezone.excity.America/Panama", "पनामा" },
            { "timezone.excity.America/Recife", "रिसीफ" },
            { "timezone.excity.America/Regina", "रैगिना" },
            { "timezone.excity.Asia/Famagusta", "फामागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हांग कांग" },
            { "timezone.excity.Asia/Jerusalem", "जेरूसेलम" },
            { "timezone.excity.Asia/Kamchatka", "कमचटका" },
            { "timezone.excity.Asia/Pontianak", "पोंटियांक" },
            { "timezone.excity.Asia/Pyongyang", "प्योंगयांग" },
            { "timezone.excity.Asia/Qyzylorda", "किजिलोर्डा" },
            { "timezone.excity.Asia/Samarkand", "समरकंद" },
            { "timezone.excity.Asia/Singapore", "सिंगापुर" },
            { "timezone.excity.Asia/Vientiane", "बियंटियान" },
            { "timezone.excity.Europe/Andorra", "एंडोरा" },
            { "timezone.excity.Europe/Saratov", "सारातोब" },
            { "timezone.excity.Europe/Tallinn", "टालिन" },
            { "timezone.excity.Europe/Vatican", "बेटिकन" },
            { "timezone.excity.Europe/Vilnius", "बिलनिउस" },
            { "timezone.excity.Indian/Mayotte", "मयोते" },
            { "timezone.excity.Indian/Reunion", "रियूनियन" },
            { "timezone.excity.Pacific/Easter", "ईस्टर" },
            { "timezone.excity.Africa/Blantyre", "ब्लेंटायर" },
            { "timezone.excity.Africa/Djibouti", "जिबूती" },
            { "timezone.excity.Africa/El_Aaiun", "एल ऐयून" },
            { "timezone.excity.Africa/Freetown", "फ्रीटाउन" },
            { "timezone.excity.Africa/Gaborone", "गेबोरोन" },
            { "timezone.excity.Africa/Khartoum", "खारतौम" },
            { "timezone.excity.Africa/Kinshasa", "किंशासा" },
            { "timezone.excity.Africa/Monrovia", "मोनरोविया" },
            { "timezone.excity.Africa/Ndjamena", "नेजेमीना" },
            { "timezone.excity.Africa/Sao_Tome", "साओ टोम" },
            { "timezone.excity.Africa/Windhoek", "बिंडोएक" },
            { "timezone.excity.America/Antigua", "एंटिगुआ" },
            { "timezone.excity.America/Caracas", "काराकास" },
            { "timezone.excity.America/Cayenne", "कायेन" },
            { "timezone.excity.America/Chicago", "शिकागो" },
            { "timezone.excity.America/Cordoba", "कोर्डोबा" },
            { "timezone.excity.America/Creston", "क्रेस्टन" },
            { "timezone.excity.America/Curacao", "क्यूरासाओ" },
            { "timezone.excity.America/Detroit", "डेट्रायट" },
            { "timezone.excity.America/Godthab", "नुक" },
            { "timezone.excity.America/Grenada", "ग्रेनाडा" },
            { "timezone.excity.America/Halifax", "हेलिफेक्स" },
            { "timezone.excity.America/Iqaluit", "इकालविट" },
            { "timezone.excity.America/Jamaica", "जमैका" },
            { "timezone.excity.America/Managua", "मनागुआ" },
            { "timezone.excity.America/Marigot", "मारीगौट" },
            { "timezone.excity.America/Mendoza", "मेंडोजा" },
            { "timezone.excity.America/Moncton", "मान्कटान" },
            { "timezone.excity.America/Noronha", "नोरोन्हा" },
            { "timezone.excity.America/Ojinaga", "ओजिनागा" },
            { "timezone.excity.America/Phoenix", "फिनिक्स" },
            { "timezone.excity.America/Tijuana", "तिजुआना" },
            { "timezone.excity.America/Toronto", "टोरंटो" },
            { "timezone.excity.America/Tortola", "टोर्टोला" },
            { "timezone.excity.America/Yakutat", "यकुटाट" },
            { "timezone.excity.Asia/Phnom_Penh", "नोम पेन्ह" },
            { "timezone.excity.Atlantic/Azores", "एजोर्स" },
            { "timezone.excity.Atlantic/Canary", "केनेरी" },
            { "timezone.excity.Atlantic/Faeroe", "फराओ" },
            { "timezone.excity.Australia/Eucla", "इयूकला" },
            { "timezone.excity.Australia/Perth", "पर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रसेल्स" },
            { "timezone.excity.Europe/Budapest", "बुडापेस्ट" },
            { "timezone.excity.Europe/Busingen", "बसिंगेन" },
            { "timezone.excity.Europe/Chisinau", "चिसिनाऊ" },
            { "timezone.excity.Europe/Guernsey", "गर्नजी" },
            { "timezone.excity.Europe/Helsinki", "हैलसिंकी" },
            { "timezone.excity.Europe/Istanbul", "इस्ताम्बुल" },
            { "timezone.excity.Europe/Sarajevo", "सराजेबो" },
            { "timezone.excity.Indian/Maldives", "मालदीव" },
            { "timezone.excity.Pacific/Chatham", "चेथम" },
            { "timezone.excity.Pacific/Norfolk", "नारफाक" },
            { "timezone.excity.Africa/Bujumbura", "बुजुमबुरा" },
            { "timezone.excity.Africa/Mogadishu", "मोगादिशू" },
            { "timezone.excity.America/Anguilla", "एंग्विला" },
            { "timezone.excity.America/Asuncion", "असुनशियन" },
            { "timezone.excity.America/Barbados", "बारबडोस" },
            { "timezone.excity.America/Dominica", "डोमिनिका" },
            { "timezone.excity.America/Edmonton", "एडमोंटोन" },
            { "timezone.excity.America/Eirunepe", "ईरूनेपे" },
            { "timezone.excity.America/Mazatlan", "मजाटलान" },
            { "timezone.excity.America/Miquelon", "मिक्वेलान" },
            { "timezone.excity.America/New_York", "न्यूयार्क" },
            { "timezone.excity.America/Resolute", "रेसालूत" },
            { "timezone.excity.America/Santarem", "सांतारेम" },
            { "timezone.excity.America/Santiago", "सैंटियागो" },
            { "timezone.excity.America/St_Johns", "सेंट जान्स" },
            { "timezone.excity.America/St_Kitts", "सेंट किट्स" },
            { "timezone.excity.America/St_Lucia", "सेंट लूशिया" },
            { "timezone.excity.America/Winnipeg", "बिनिपैग" },
            { "timezone.excity.Antarctica/Casey", "केसी" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रेस्नोयार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नोबोसिबिरस्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलनबटोर" },
            { "timezone.excity.Asia/Vladivostok", "ब्लाडिबोस्तोक" },
            { "timezone.excity.Atlantic/Bermuda", "बरमूडा" },
            { "timezone.excity.Atlantic/Madeira", "मदैरा" },
            { "timezone.excity.Atlantic/Stanley", "स्टेनली" },
            { "timezone.excity.Australia/Darwin", "डार्बिन" },
            { "timezone.excity.Australia/Hobart", "होबर्ट" },
            { "timezone.excity.Australia/Sydney", "सिडनी" },
            { "timezone.excity.Europe/Amsterdam", "एम्सटर्डम" },
            { "timezone.excity.Europe/Astrakhan", "अस्ट्राकान" },
            { "timezone.excity.Europe/Bucharest", "बुखारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टर" },
            { "timezone.excity.Europe/Ljubljana", "लुबलियाना" },
            { "timezone.excity.Europe/Mariehamn", "मेरियेहम" },
            { "timezone.excity.Europe/Podgorica", "पोडगोरिशा" },
            { "timezone.excity.Europe/Stockholm", "स्टाकहोम" },
            { "timezone.excity.Europe/Ulyanovsk", "उल्येनोबोस्क" },
            { "timezone.excity.Europe/Volgograd", "बोलगोग्राद" },
            { "timezone.excity.Indian/Christmas", "क्रिसमस" },
            { "timezone.excity.Indian/Kerguelen", "कैरगुएलेन" },
            { "timezone.excity.Indian/Mauritius", "मारीशस" },
            { "timezone.excity.Pacific/Auckland", "आकलैंड" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लांका" },
            { "timezone.excity.Africa/Libreville", "लिब्रेविल" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुमबाशी" },
            { "timezone.excity.Africa/Nouakchott", "नौकचोट" },
            { "timezone.excity.Africa/Porto-Novo", "पोर्टो-नोवो" },
            { "timezone.excity.America/Anchorage", "एंकोरेज" },
            { "timezone.excity.America/Araguaina", "अरागुएना" },
            { "timezone.excity.America/Boa_Vista", "बोआ बिस्टा" },
            { "timezone.excity.America/Catamarca", "काटामार्का" },
            { "timezone.excity.America/Chihuahua", "चिहुआहुआ" },
            { "timezone.excity.America/Fortaleza", "फोर्टालेजा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस बे" },
            { "timezone.excity.America/Goose_Bay", "गूज बे" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "गुआयाक्विल" },
            { "timezone.excity.America/Matamoros", "माटामोरोस" },
            { "timezone.excity.America/Menominee", "मैनोमिनी" },
            { "timezone.excity.America/Monterrey", "मानटेैरी" },
            { "timezone.excity.America/Sao_Paulo", "साओ पाउलो" },
            { "timezone.excity.America/St_Thomas", "सेंट थोमस" },
            { "timezone.excity.America/Vancouver", "बैंकुबर" },
            { "timezone.excity.Asia/Kuala_Lumpur", "कुआलालम्पुर" },
            { "timezone.excity.Asia/Novokuznetsk", "कोबोकुजनेट्स" },
            { "timezone.excity.Europe/Bratislava", "बारितस्लावा" },
            { "timezone.excity.Europe/Copenhagen", "कोपेनहेगेन" },
            { "timezone.excity.Europe/Luxembourg", "लग्जमबर्ग" },
            { "timezone.excity.Europe/San_Marino", "सैन मरीनो" },
            { "timezone.excity.Europe/Simferopol", "सिम्फेरोपोल" },
            { "timezone.excity.Pacific/Galapagos", "गैलापैगोस" },
            { "timezone.excity.Africa/Addis_Ababa", "अदिस अबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्रेजाविल" },
            { "timezone.excity.Africa/Ouagadougou", "औगाडुगू" },
            { "timezone.excity.America/Costa_Rica", "कोस्टा रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रांड टर्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वाडेलूप" },
            { "timezone.excity.America/Hermosillo", "हरमोसिलो" },
            { "timezone.excity.America/Kralendijk", "केलेंडिज्क" },
            { "timezone.excity.America/Louisville", "लुइसविले" },
            { "timezone.excity.America/Martinique", "मार्टिनिक" },
            { "timezone.excity.America/Metlakatla", "मैटलाकाटला" },
            { "timezone.excity.America/Montevideo", "मोंटैविडियो" },
            { "timezone.excity.America/Montserrat", "मोंटसेरात" },
            { "timezone.excity.America/Paramaribo", "पारामारिबो" },
            { "timezone.excity.America/Rio_Branco", "रियो ब्रेंको" },
            { "timezone.excity.America/St_Vincent", "सेंट विंसेंट" },
            { "timezone.excity.America/Whitehorse", "वाइटहार्स" },
            { "timezone.excity.Asia/Srednekolymsk", "श्रेडनेकोलिमिस्क" },
            { "timezone.excity.Asia/Yekaterinburg", "यैकेटेरिनबर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रिकजेविक" },
            { "timezone.excity.Atlantic/St_Helena", "सेंट हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडिलेड" },
            { "timezone.excity.Australia/Brisbane", "ब्रिसबेन" },
            { "timezone.excity.Australia/Lindeman", "लिंडमैन" },
            { "timezone.excity.Europe/Isle_of_Man", "आइजल आफ मैन" },
            { "timezone.excity.Europe/Kaliningrad", "कलिनिनग्रेड" },
            { "timezone.excity.Africa/Johannesburg", "जोहानिसबर्ग" },
            { "timezone.excity.America/El_Salvador", "अल सल्वाडोर" },
            { "timezone.excity.America/Fort_Nelson", "फोर्ट नेलसन" },
            { "timezone.excity.America/Los_Angeles", "लास एंजिलिस" },
            { "timezone.excity.America/Mexico_City", "मैक्सिको सिटी" },
            { "timezone.excity.America/Porto_Velho", "पोर्टो बेल्हो" },
            { "timezone.excity.America/Puerto_Rico", "पोर्टो रिको" },
            { "timezone.excity.America/Tegucigalpa", "तेगुसिगाल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लान्गियरबेन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप बर्ड" },
            { "timezone.excity.Australia/Lord_Howe", "लार्ड होबे" },
            { "timezone.excity.Australia/Melbourne", "मेलबोर्न" },
            { "timezone.excity.Indian/Antananarivo", "अंतानानेरिवो" },
            { "timezone.excity.Africa/Dar_es_Salaam", "डारे सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लैंक-सबलोन" },
            { "timezone.excity.America/Buenos_Aires", "ब्यूनस आयर्स" },
            { "timezone.excity.America/Campo_Grande", "केम्पो ग्रेनडा" },
            { "timezone.excity.America/Danmarkshavn", "दमर्कशन" },
            { "timezone.excity.America/Dawson_Creek", "डाउसन क्रीक" },
            { "timezone.excity.America/Indiana/Knox", "नोक्स, इंडियाना" },
            { "timezone.excity.America/Indianapolis", "इंडियानापोलिस" },
            { "timezone.excity.America/Punta_Arenas", "पुंटा अरेनाज" },
            { "timezone.excity.America/Rankin_Inlet", "रेंकिन इनलेट" },
            { "timezone.excity.America/Scoresbysund", "इटोकोर्टूरमिट" },
            { "timezone.excity.Antarctica/Macquarie", "मैक्वैरी" },
            { "timezone.excity.America/Cambridge_Bay", "कैम्ब्रीज बे" },
            { "timezone.excity.America/Coral_Harbour", "अटिकोकन" },
            { "timezone.excity.America/Indiana/Vevay", "बीबे, इंडियाना" },
            { "timezone.excity.America/Lower_Princes", "लोअर प्रिंसेस क्वाटर" },
            { "timezone.excity.America/Port_of_Spain", "पोर्ट आफ स्पेन" },
            { "timezone.excity.America/Santo_Domingo", "सेंटो डोमिनगो" },
            { "timezone.excity.America/St_Barthelemy", "सेंट बर्थेलमी" },
            { "timezone.excity.America/Swift_Current", "स्विफ्ट करेंट" },
            { "timezone.excity.Australia/Broken_Hill", "ब्रोकेन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बहिया बंडेरास" },
            { "timezone.excity.America/Port-au-Prince", "पोर्ट आउ प्रिंस" },
            { "timezone.excity.Atlantic/South_Georgia", "दक्षिण जार्जिया" },
            { "timezone.excity.America/Argentina/Salta", "सालटा" },
            { "timezone.excity.America/Indiana/Marengo", "मेरैंगो, इंडियाना" },
            { "timezone.excity.America/Indiana/Winamac", "बिनामैक, इंडियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टुकुमान" },
            { "timezone.excity.America/Argentina/Ushuaia", "उशुयाया" },
            { "timezone.excity.America/Indiana/Tell_City", "टेल सिटी, इंडियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "विनसेंस, इंडियाना" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रियोजा" },
            { "timezone.excity.America/Argentina/San_Juan", "सन जुआन" },
            { "timezone.excity.America/Argentina/San_Luis", "सन लूईस" },
            { "timezone.excity.America/Indiana/Petersburg", "पीटर्सबर्ग, इंडियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मोंटीचेलो, केंटुकी" },
            { "timezone.excity.America/North_Dakota/Beulah", "बियूला, उत्तर डकोटा" },
            { "timezone.excity.America/North_Dakota/Center", "सेंटर, उत्तर डकोटा" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रियो गैलगस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "न्यू सलेम, उत्तर डकोटा" },
        };
        return data;
    }
}
