/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_si extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ග්‍රිනිච් මධ්‍යම වේලාව",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "අපියා සම්මත වේලාව",
               "",
               "අපියා දිවා වේලාව",
               "",
               "අපියා වේලාව",
               "",
            };
        final String[] Cook = new String[] {
               "කුක් දුපත් සම්මත වේලාව",
               "",
               "කුක් දුපත් භාග ග්‍රීෂ්ම වේලාව",
               "",
               "කුක් දුපත් වේලාව",
               "",
            };
        final String[] Cuba = new String[] {
               "කියුබානු සම්මත වේලාව",
               "CST",
               "කියුබානු දිවාආලෝක වේලාව",
               "CDT",
               "කියුබානු වේලාව",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ෆිජි සම්මත වේලාව",
               "",
               "ෆිජි ග්‍රීෂ්ම වේලාව",
               "",
               "ෆිජි වේලාව",
               "",
            };
        final String[] Gulf = new String[] {
               "ගල්ෆ් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "හොව්ඩ් සම්මත වේලාව",
               "",
               "හොව්ඩ් ග්‍රීෂ්ම වේලාව",
               "",
               "හොව්ඩ් වේලාව",
               "",
            };
        final String[] Iran = new String[] {
               "ඉරාන සම්මත වේලාව",
               "",
               "ඉරාන දිවා කාලය",
               "",
               "ඉරාන වේලාව",
               "",
            };
        final String[] Niue = new String[] {
               "නියු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ඔම්ස්ක් සම්මත වේලාව",
               "",
               "ඔම්ස්ක් ග්‍රීෂ්ම වේලාව",
               "",
               "ඔම්ස්ක් වේලාව",
               "",
            };
        final String[] Peru = new String[] {
               "පේරු සම්මත වේලාව",
               "",
               "පේරු ග්‍රීෂ්ම කාලය",
               "",
               "පේරු වේලාව",
               "",
            };
        final String[] Truk = new String[] {
               "චුක් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "වේක් දූපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "චිලී සම්මත වේලාව",
               "",
               "චිලී ග්‍රීෂ්ම කාලය",
               "",
               "චිලී වේලාව",
               "",
            };
        final String[] China = new String[] {
               "චීන සම්මත වේලාව",
               "CST",
               "චීන දහවල් වේලාව",
               "CDT",
               "චීන වේලාව",
               "CT",
            };
        final String[] Cocos = new String[] {
               "කොකෝස් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ඩාවිස් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ඉන්දියානු වේලාව",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ජපාන සම්මත වේලාව",
               "JST",
               "ජපාන දහවල් වේලාව",
               "JDT",
               "ජපාන වේලාව",
               "JT",
            };
        final String[] Korea = new String[] {
               "කොරියානු සම්මත වේලාව",
               "KST",
               "කොරියානු දහවල් වේලාව",
               "KST",
               "කොරියානු වේලාව",
               "KST",
            };
        final String[] Nauru = new String[] {
               "නාවුරු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "නේපාල වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "පලාවු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "සැමෝවා සම්මත වේලාව",
               "SST",
               "සැමෝවා ග්‍රීෂ්ම වේලාව",
               "SST",
               "සැමෝවා වේලාව",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ස්යෝවා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ටොංගා සම්මත වේලාව",
               "",
               "ටොංගා ග්‍රීෂ්ම වේලාව",
               "",
               "ටොංගා වේලාව",
               "",
            };
        final String[] Yukon = new String[] {
               "යුකොන් වේලාව",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ඇලස්කා සම්මත වේලාව",
               "AKST",
               "ඇලස්කා දිවාආලෝක වේලාව",
               "AKDT",
               "ඇලස්කා වේලාව",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ඇමර්සන් සම්මත වේලාව",
               "",
               "ඇමර්සන් ග්‍රීෂ්ම කාලය",
               "",
               "ඇමර්සන් වේලාව",
               "",
            };
        final String[] Azores = new String[] {
               "ඇසොර්ස් සම්මත වේලාව",
               "",
               "ඇසොර්ස් ග්‍රීෂ්ම වේලාව",
               "",
               "ඇසොර්ස් වේලාව",
               "",
            };
        final String[] Bhutan = new String[] {
               "භුතාන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "බෘනායි දරුස්සලාම් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ඊස්ටර් දූපත් සම්මත වේලාව",
               "",
               "ඊස්ටර් දූපත් ග්‍රීෂ්ම කාලය",
               "",
               "ඊස්ටර් දූපත් වේලාව",
               "",
            };
        final String[] Guyana = new String[] {
               "ගයනා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "හවායි-අලෙයුතියාන් සම්මත වේලාව",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ඊශ්‍රායල සම්මත වේලාව",
               "IST",
               "ඊශ්‍රායල දහවල් වේලාව",
               "IDT",
               "ඊශ්‍රායල වේලාව",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "කොස්රේ වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "මොව්සන් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "මොස්කව් සම්මත වේලාව",
               "MSK",
               "මොස්කව් ග්‍රීෂ්ම වේලාව",
               "MSK",
               "මොස්කව් වේලාව",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "පොනපේ වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ටාහිටි වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "තායිපේ සම්මත වේලාව",
               "CST",
               "තායිපේ දහවල් වේලාව",
               "CDT",
               "තායිපේ වේලාව",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ටුවාලු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "වොස්ටොක් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "වැලිස් සහ ෆුටුනා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "අරාබි සම්මත වේලාව",
               "",
               "අරාබි දහවල් වේලාව",
               "",
               "අරාබි වේලාව",
               "",
            };
        final String[] Armenia = new String[] {
               "ආමේනියානු සම්මත වේලාව",
               "",
               "ආමේනියානු ග්‍රීෂ්ම වේලාව",
               "",
               "ආමේනියානු වේලාව",
               "",
            };
        final String[] Bolivia = new String[] {
               "බොලිවියා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "චැතම් සම්මත වේලාව",
               "",
               "චැතම් දිවා වේලාව",
               "",
               "චැතම් වේලාව",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "සමකක්ෂ සාර්ව වේලාව",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ඉක්වදෝර් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ගැම්බියර් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ජෝර්ජියානු සම්මත වේලාව",
               "",
               "ජෝර්ජියානු ග්‍රීෂ්ම වේලාව",
               "",
               "ජෝර්ජියානු වේලාව",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ඉර්කුට්ස්ක් සම්මත වේලාව",
               "",
               "ඉර්කුට්ස්ක් ග්‍රීෂ්ම වේලාව",
               "",
               "ඉර්කුට්ස්ක් වේලාව",
               "",
            };
        final String[] Magadan = new String[] {
               "මෙගඩන් සම්මත වේලාව",
               "",
               "මෙගඩන් ග්‍රීෂ්ම වේලාව",
               "",
               "මෙගඩන් වේලාව",
               "",
            };
        final String[] Myanmar = new String[] {
               "මියන්මාර් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "නොෆොල්ක් දුපත් සම්මත වේලාව",
               "",
               "නොෆොල්ක් දුපත් ග්‍රීෂ්ම වේලාව",
               "",
               "නොෆොල්ක් දුපත් වේලාව",
               "",
            };
        final String[] Noronha = new String[] {
               "ෆර්නැන්ඩෝ ඩි නොරොන්හා සම්මත වේලාව",
               "",
               "ෆර්නැන්ඩෝ ඩි නොරොන්හා ග්‍රීෂ්ම කාලය",
               "",
               "ෆර්නැන්ඩෝ ඩි නොරොන්හා වේලාව",
               "",
            };
        final String[] Reunion = new String[] {
               "රියුනියන් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "රොතෙරා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "සොලොමන් දූපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ටොකෙලාවු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "උරුගුවේ සම්මත වේලාව",
               "",
               "උරුගුවේ ග්‍රීෂ්ම කාලය",
               "",
               "උරුගුවේ වේලාව",
               "",
            };
        final String[] Vanuatu = new String[] {
               "වනුආටු සම්මත වේලාව",
               "",
               "වනුආටු ගිම්හාන වේලාව",
               "",
               "වනුආටු වේලාව",
               "",
            };
        final String[] Yakutsk = new String[] {
               "යකුට්ස්ක් සම්මත වේලාව",
               "",
               "යකුට්ස්ක් ග්‍රීෂ්ම වේලාව",
               "",
               "යකුට්ස්ක් වේලාව",
               "",
            };
        final String[] Atlantic = new String[] {
               "අත්ලාන්තික් සම්මත වේලාව",
               "AST",
               "අත්ලාන්තික් දිවාආලෝක වේලාව",
               "AST",
               "අත්ලාන්තික් වේලාව",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "බ්‍රසීල සම්මත වේලාව",
               "",
               "බ්‍රසීල ග්‍රීෂ්ම කාලය",
               "",
               "බ්‍රසීල වේලාව",
               "",
            };
        final String[] Chamorro = new String[] {
               "චමොරෝ වේලාව",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "කොලොම්බියා සම්මත වේලාව",
               "",
               "කොලොම්බියා ග්‍රීෂ්ම කාලය",
               "",
               "කොලොම්බියා වේලාව",
               "",
            };
        final String[] Falkland = new String[] {
               "ෆෝක්ලන්ඩ් දූපත් සම්මත වේලාව",
               "",
               "ෆෝක්ලන්ඩ් දූපත් ග්‍රීෂ්ම කාලය",
               "",
               "ෆෝක්ලන්ඩ් දූපත් වේලාව",
               "",
            };
        final String[] Malaysia = new String[] {
               "මැලේසියානු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "මාලදිවයින් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "උලාන් බාටර් සම්මත වේලාව",
               "",
               "උලාන් බාටර් ග්‍රීෂ්ම වේලාව",
               "",
               "උලාන් බාටර් වේලාව",
               "",
            };
        final String[] Pakistan = new String[] {
               "පාකිස්ථාන සම්මත වේලාව",
               "PKT",
               "පාකිස්ථාන ග්‍රීෂ්ම කාලය",
               "PKST",
               "පාකිස්ථාන වේලාව",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "පැරගුවේ සම්මත වේලාව",
               "",
               "පැරගුවේ ග්‍රීෂ්ම කාලය",
               "",
               "පැරගුවේ වේලාව",
               "",
            };
        final String[] Pitcairn = new String[] {
               "පිට්කෙයාන් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "සුරිනාම වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ආර්ජන්ටිනා සම්මත වේලාව",
               "",
               "ආර්ජන්ටිනා ග්‍රීෂ්ම කාලය",
               "",
               "ආර්ජන්ටිනා වේලාව",
               "",
            };
        final String[] Christmas = new String[] {
               "ක්‍රිස්මස් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ගලපගොස් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "හොංකොං සම්මත වේලාව",
               "HKT",
               "හොංකොං ග්‍රීෂ්ම වේලාව",
               "HKST",
               "හොංකොං වේලාව",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ඉන්දුචීන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "කිර්ගිස්තාන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ලෝර්ඩ් හෝව් සම්මත වේලාව",
               "",
               "ලෝර්ඩ් හෝව් දිවා වේලාව",
               "",
               "ලෝර්ඩ් හෝව් වේලාව",
               "",
            };
        final String[] Marquesas = new String[] {
               "මාර්කුඑසාස් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "මුරුසි සම්මත වේලාව",
               "",
               "මුරුසි ග්‍රීෂ්ම කාලය",
               "",
               "මුරුසි වේලාව",
               "",
            };
        final String[] Singapore = new String[] {
               "සිංගප්පුරු වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "වෙනිසියුලා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "අසර්බයිජාන් සම්මත වේලාව",
               "",
               "අසර්බයිජාන් ග්‍රීෂ්ම වේලාව",
               "",
               "අසර්බයිජාන් වේලාව",
               "",
            };
        final String[] Bangladesh = new String[] {
               "බංගලාදේශ සම්මත වේලාව",
               "",
               "බංගලාදේශ ග්‍රීෂ්ම කාලය",
               "",
               "බංගලාදේශ වේලාව",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "කේප්වේඩ් සම්මත වේලාව",
               "",
               "කේප්වේඩ් ග්‍රීෂ්ම කාලය",
               "",
               "කේප්වේඩ් වේලාව",
               "",
            };
        final String[] East_Timor = new String[] {
               "නැගෙනහිර ටිමෝර් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "කසකස්තාන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "සීෂෙල්ස් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ටජිකිස්තාන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "උස්බෙකිස්තාන සම්මත වේලාව",
               "",
               "උස්බෙකිස්තාන ග්‍රීෂ්ම වේලාව",
               "",
               "උස්බෙකිස්තාන වේලාව",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ඇෆ්ගනිස්ථාන වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ක්‍රස්නොයාර්ස්ක් සම්මත වේලාව",
               "",
               "ක්‍රස්නොයාර්ස්ක් ග්‍රීෂ්ම වේලාව",
               "",
               "ක්‍රස්නොයාර්ස්ක් වේලාව",
               "",
            };
        final String[] New_Zealand = new String[] {
               "නවසීලන්ත සම්මත වේලාව",
               "NZST",
               "නවසීලන්ත දිවා වේලාව",
               "NZDT",
               "නවසීලන්ත වේලාව",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "පිලිපීන සම්මත වේලාව",
               "PST",
               "පිලිපීන ග්‍රීෂ්ම වේලාව",
               "PDT",
               "පිලිපීන වේලාව",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ව්ලදිවෝස්ටෝක් සම්මත වේලාව",
               "",
               "ව්ලදිවෝස්ටෝක් ග්‍රීෂ්ම වේලාව",
               "",
               "ව්ලදිවෝස්ටෝක් වේලාව",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ඉන්දියන් සාගර වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ලයින් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "නිව්ෆවුන්ලන්ත සම්මත වේලාව",
               "NST",
               "නිව්ෆවුන්ලන්ත දිවාආලෝක වේලාව",
               "NDT",
               "නිව්ෆවුන්ලන්ත වේලාව",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ටර්ක්මෙනිස්තාන සම්මත වේලාව",
               "",
               "ටර්ක්මෙනිස්තාන ග්‍රීෂ්ම වේලාව",
               "",
               "ටර්ක්මෙනිස්තාන වේලාව",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ප්‍රංශ ගයනා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "නව සෙලඩොනියානු සම්මත වේලාව",
               "",
               "නව සෙලඩොනියානු ග්‍රීෂ්ම වේලාව",
               "",
               "නව සෙලඩොනියානු වේලාව",
               "",
            };
        final String[] South_Georgia = new String[] {
               "දකුණු ජෝජියා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "යෙකටෙරින්බර්ග් සම්මත වේලාව",
               "",
               "යෙකටෙරින්බර්ග් ග්‍රීෂ්ම වේලාව",
               "",
               "යෙකටෙරින්බර්ග් වේලාව",
               "",
            };
        final String[] Africa_Central = new String[] {
               "මධ්‍යම අප්‍රිකානු වේලාව",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "නැගෙනහිර අප්‍රිකානු වේලාව",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "බටහිර අප්‍රිකානු වේලාව",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "දුමොන්ත්-ඩ්උර්විල් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "මධ්‍යම යුරෝපීය සම්මත වේලාව",
               "CET",
               "මධ්‍යම යුරෝපීය ග්‍රීෂ්ම වේලාව",
               "CEST",
               "මධ්‍යම යුරෝපීය වේලාව",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "නැගෙනහිර යුරෝපීය සම්මත වේලාව",
               "EET",
               "නැගෙනහිර යුරෝපීය ග්‍රීෂ්ම වේලාව",
               "EEST",
               "නැගෙනහිර යුරෝපීය වේලාව",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "බටහිර යුරෝපීය සම්මත වේලාව",
               "WET",
               "බටහිර යුරෝපීය ග්‍රීෂ්ම වේලාව",
               "WEST",
               "බටහිර යුරෝපීය වේලාව",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "මෙක්සිකෝ පැසිෆික් සම්මත වේලාව",
               "MST",
               "මෙක්සිකෝ පැසිෆික් දිවාආලෝක වේලාව",
               "MDT",
               "මෙක්සිකෝ පැසිෆික් වේලාව",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "දකුණු අප්‍රිකානු වේලාව",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "උතුරු ඇමරිකානු මධ්‍යම සම්මත වේලාව",
               "CST",
               "උතුරු ඇමරිකානු මධ්‍යම දිවාආලෝක වේලාව",
               "CDT",
               "උතුරු ඇමරිකානු මධ්‍යම වේලාව",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "උතුරු ඇමරිකානු නැගෙනහිර සම්මත වේලාව",
               "EST",
               "උතුරු ඇමරිකානු නැගෙනහිර දිවාආලෝක වේලාව",
               "EST",
               "උතුරු ඇමරිකානු නැගෙනහිර වේලාව",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "උතුරු ඇමරිකානු පැසිෆික් සම්මත වේලාව",
               "PST",
               "උතුරු ඇමරිකානු පැසිෆික් දිවාආලෝක වේලාව",
               "PDT",
               "උතුරු ඇමරිකානු පැසිෆික් වේලාව",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ප්‍රංශ දකුණුදිග සහ ඇන්ටාර්ක්ටික් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ගිල්බර්ට් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "හවායි-අලෙයුතියාන් සම්මත වේලාව",
               "HST",
               "හවායි-අලෙයුතියාන් දිවාආලෝක වේලාව",
               "HDT",
               "හවායි-අලෙයුතියාන් වේලාව",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ෆීනික්ස් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ශාන්ත පියරේ සහ මැකෝලන් සම්මත වේලාව",
               "",
               "ශාන්ත පියරේ සහ මැකෝලන් දිවාආලෝක වේලාව",
               "",
               "ශාන්ත පියරේ සහ මැකෝලන් වේලාව",
               "",
            };
        final String[] America_Mountain = new String[] {
               "උතුරු ඇමරිකානු කඳුකර සම්මත වේලාව",
               "MST",
               "උතුරු ඇමරිකානු කඳුකර දිවාආලෝක වේලාව",
               "MST",
               "උතුරු ඇමරිකානු කඳුකර වේලාව",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "මාර්ෂල් දුපත් වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "පැපුවා නිව් ගිනීයා වේලාව",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ඕස්ට්‍රේලියානු සම්මත වේලාව",
               "ACST",
               "මධ්‍යම ඔස්ට්‍රේලියානු දහවල් වේලාව",
               "ACDT",
               "මධ්‍යම ඕස්ට්‍රේලියානු වේලාව",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "නැගෙනහිර ඕස්ට්‍රේලියානු සම්මත වේලාව",
               "AEST",
               "නැඟෙනහිර ඕස්ට්‍රේලියානු දහවල් වේලාව",
               "AEDT",
               "නැගෙනහිර ඕස්ට්‍රේලියානු වේලාව",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "බටහිර ඕස්ට්‍රේලියානු සම්මත වේලාව",
               "AWST",
               "බටහිර ඔස්ට්‍රේලියානු දහවල් වේලාව",
               "AWDT",
               "බටහිර ඕස්ට්‍රේලියානු වේලාව",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "මධ්‍යම ඉන්දුනීසියානු වේලාව",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "නැගෙනහිර ඉන්දුනීසියානු වේලාව",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "බටහිර ඉන්දුනීසියානු වේලාව",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "මධ්‍යම බටහිර ඔස්ට්‍රේලියානු සම්මත වේලාව",
               "",
               "මධ්‍යම බටහිර ඔස්ට්‍රේලියානු දහවල් වේලාව",
               "",
               "මධ්‍යම බටහිර ඔස්ට්‍රේලියානු වේලාව",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "අයර්ලන්ත සම්මත වේලාව",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "සමකක්ෂ සාර්ව වේලාව",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "අයර්ලන්ත සම්මත වේලාව",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ග්‍රිනිච් මධ්‍යම වේලාව",
                    "GMT",
                    "බ්‍රිතාන්‍ය ගිම්හාන වේලාව",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ඒඩ්න්" },
            { "timezone.excity.Asia/Baku", "බාකු" },
            { "timezone.excity.Asia/Dili", "ඩිලි" },
            { "timezone.excity.Asia/Gaza", "ගාසා" },
            { "timezone.excity.Asia/Hovd", "හොව්ඩ්" },
            { "timezone.excity.Asia/Omsk", "ඔම්ස්ක්" },
            { "timezone.excity.Asia/Oral", "ඔරාල්" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "අම්මාන්" },
            { "timezone.excity.Asia/Aqtau", "අක්ටෝ" },
            { "timezone.excity.Asia/Chita", "චිටා" },
            { "timezone.excity.Asia/Dhaka", "ඩකා" },
            { "timezone.excity.Asia/Dubai", "ඩුබායි" },
            { "timezone.excity.Asia/Kabul", "කාබුල්" },
            { "timezone.excity.Asia/Macau", "මැකාවු" },
            { "timezone.excity.Asia/Qatar", "කටාර්" },
            { "timezone.excity.Asia/Seoul", "සෝල්" },
            { "timezone.excity.Asia/Tokyo", "ටෝකියෝ" },
            { "timezone.excity.Asia/Tomsk", "ටොම්ස්ක්" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ජුබා" },
            { "timezone.excity.Africa/Lome", "ලෝම්" },
            { "timezone.excity.Asia/Almaty", "අල්මටි" },
            { "timezone.excity.Asia/Anadyr", "ඇනාදිය්ර්" },
            { "timezone.excity.Asia/Aqtobe", "අක්ටෝබ්" },
            { "timezone.excity.Asia/Atyrau", "ඇටිරවු" },
            { "timezone.excity.Asia/Beirut", "බීරුට්" },
            { "timezone.excity.Asia/Brunei", "බෲනායි" },
            { "timezone.excity.Asia/Hebron", "හෙබ්රෝන්" },
            { "timezone.excity.Asia/Kuwait", "කුවේට්" },
            { "timezone.excity.Asia/Manila", "මැනිලා" },
            { "timezone.excity.Asia/Muscat", "මස්කට්" },
            { "timezone.excity.Asia/Riyadh", "රියාද්" },
            { "timezone.excity.Asia/Saigon", "හෝචි මිං නගරය" },
            { "timezone.excity.Asia/Taipei", "තායිපෙ" },
            { "timezone.excity.Asia/Tehran", "ටෙහෙරාන්" },
            { "timezone.excity.Asia/Urumqi", "උරුම්කි" },
            { "timezone.excity.Etc/Unknown", "හඳුනා නොගත් නගරය" },
            { "timezone.excity.Europe/Kiev", "කිව්" },
            { "timezone.excity.Europe/Oslo", "ඔස්ලෝ" },
            { "timezone.excity.Europe/Riga", "රිගා" },
            { "timezone.excity.Europe/Rome", "රෝමය" },
            { "timezone.excity.Indian/Mahe", "මාහේ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "අක්රා" },
            { "timezone.excity.Africa/Cairo", "කයිරෝ" },
            { "timezone.excity.Africa/Ceuta", "සෙයුටා" },
            { "timezone.excity.Africa/Dakar", "ඩකර්" },
            { "timezone.excity.Africa/Lagos", "ලාගෝස්" },
            { "timezone.excity.Africa/Tunis", "ටියුනිස්" },
            { "timezone.excity.America/Adak", "ඇඩක්" },
            { "timezone.excity.America/Lima", "ලීමා" },
            { "timezone.excity.America/Nome", "නෝම්" },
            { "timezone.excity.Asia/Baghdad", "බැග්ඩෑඩ්" },
            { "timezone.excity.Asia/Bahrain", "බහරේන්" },
            { "timezone.excity.Asia/Bangkok", "බැංකොක්" },
            { "timezone.excity.Asia/Barnaul", "බර්නෞල්" },
            { "timezone.excity.Asia/Bishkek", "බිශ්කෙක්" },
            { "timezone.excity.Asia/Colombo", "කොළඹ" },
            { "timezone.excity.Asia/Irkutsk", "ඉරකුට්ස්ක්" },
            { "timezone.excity.Asia/Jakarta", "ජකර්තා" },
            { "timezone.excity.Asia/Karachi", "කරච්චිචි" },
            { "timezone.excity.Asia/Kuching", "කුචිං" },
            { "timezone.excity.Asia/Magadan", "මගඩන්" },
            { "timezone.excity.Asia/Nicosia", "නිකෝසියා" },
            { "timezone.excity.Asia/Rangoon", "රැංගුන්" },
            { "timezone.excity.Asia/Tbilisi", "ට්බිලිසි" },
            { "timezone.excity.Asia/Thimphu", "තිම්පු" },
            { "timezone.excity.Asia/Yakutsk", "යකුට්ස්ක්" },
            { "timezone.excity.Asia/Yerevan", "යෙරෙවන්" },
            { "timezone.excity.Europe/Kirov", "කිරොව්" },
            { "timezone.excity.Europe/Malta", "මෝල්ටා" },
            { "timezone.excity.Europe/Minsk", "මින්ස්ක්" },
            { "timezone.excity.Europe/Paris", "පැරිස්" },
            { "timezone.excity.Europe/Sofia", "සොෆියා" },
            { "timezone.excity.Europe/Vaduz", "වඩුස්" },
            { "timezone.excity.Indian/Cocos", "කොකොස්" },
            { "timezone.excity.Pacific/Apia", "ඇපියා" },
            { "timezone.excity.Pacific/Fiji", "ෆීජි" },
            { "timezone.excity.Pacific/Guam", "ගුවාම්" },
            { "timezone.excity.Pacific/Niue", "නියු" },
            { "timezone.excity.Pacific/Truk", "චූක්" },
            { "timezone.excity.Pacific/Wake", "වේක්" },
            { "timezone.excity.Africa/Asmera", "අස්මාරා" },
            { "timezone.excity.Africa/Bamako", "බමකො" },
            { "timezone.excity.Africa/Bangui", "බන්ගුයි" },
            { "timezone.excity.Africa/Banjul", "බන්ජුල්" },
            { "timezone.excity.Africa/Bissau", "බිසෝ" },
            { "timezone.excity.Africa/Douala", "දෞඅලා" },
            { "timezone.excity.Africa/Harare", "හරාරේ" },
            { "timezone.excity.Africa/Kigali", "කිගාලි" },
            { "timezone.excity.Africa/Luanda", "ලුවන්ඩා" },
            { "timezone.excity.Africa/Lusaka", "ලුසාකා" },
            { "timezone.excity.Africa/Malabo", "මලබෝ" },
            { "timezone.excity.Africa/Maputo", "මපුටෝ" },
            { "timezone.excity.Africa/Maseru", "මසේරු" },
            { "timezone.excity.Africa/Niamey", "නියාමේ" },
            { "timezone.excity.America/Aruba", "අරූබා" },
            { "timezone.excity.America/Bahia", "බහියා" },
            { "timezone.excity.America/Belem", "බෙලෙම්" },
            { "timezone.excity.America/Boise", "බොයිසි" },
            { "timezone.excity.America/Jujuy", "ජුජුයි" },
            { "timezone.excity.America/Sitka", "සිට්කා" },
            { "timezone.excity.America/Thule", "තුලේ" },
            { "timezone.excity.Asia/Ashgabat", "අශ්ගබැට්" },
            { "timezone.excity.Asia/Calcutta", "කල්කටා" },
            { "timezone.excity.Asia/Damascus", "ඩැමස්කස්" },
            { "timezone.excity.Asia/Dushanbe", "ඩුශන්බේ" },
            { "timezone.excity.Asia/Jayapura", "ජයපුර" },
            { "timezone.excity.Asia/Katmandu", "කත්මන්ඩු" },
            { "timezone.excity.Asia/Khandyga", "ඛන්ඩිගා" },
            { "timezone.excity.Asia/Makassar", "මක්ස්සාර්" },
            { "timezone.excity.Asia/Qostanay", "කොස්තානේ" },
            { "timezone.excity.Asia/Sakhalin", "සක්හලින්" },
            { "timezone.excity.Asia/Shanghai", "ෂැන්හයි" },
            { "timezone.excity.Asia/Tashkent", "ටෂ්කෙන්ට්" },
            { "timezone.excity.Asia/Ust-Nera", "උස්ට්-නෙරා" },
            { "timezone.excity.Europe/Athens", "ඇතැන්ස්" },
            { "timezone.excity.Europe/Berlin", "බර්ලින්" },
            { "timezone.excity.Europe/Dublin", "ඩබ්ලින්" },
            { "timezone.excity.Europe/Jersey", "ජර්සි" },
            { "timezone.excity.Europe/Lisbon", "ලිස්බන්" },
            { "timezone.excity.Europe/London", "ලන්ඩන්" },
            { "timezone.excity.Europe/Madrid", "මැඩ්රිඩ්" },
            { "timezone.excity.Europe/Monaco", "මොනැකෝ" },
            { "timezone.excity.Europe/Moscow", "මොස්කව්" },
            { "timezone.excity.Europe/Prague", "ප්‍රෙග්" },
            { "timezone.excity.Europe/Samara", "සමරා" },
            { "timezone.excity.Europe/Skopje", "ස්කොප්ජේ" },
            { "timezone.excity.Europe/Tirane", "ටිරානේ" },
            { "timezone.excity.Europe/Vienna", "වියනා" },
            { "timezone.excity.Europe/Warsaw", "වර්සෝ" },
            { "timezone.excity.Europe/Zagreb", "සග්රෙබ්" },
            { "timezone.excity.Europe/Zurich", "සූරිච්" },
            { "timezone.excity.Indian/Chagos", "චාගොස්" },
            { "timezone.excity.Indian/Comoro", "කොමොරෝ" },
            { "timezone.excity.Pacific/Efate", "එෆාත්" },
            { "timezone.excity.Pacific/Nauru", "නවුරු" },
            { "timezone.excity.Pacific/Palau", "පලාවු" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "අබිජාන්" },
            { "timezone.excity.Africa/Algiers", "ඇල්ජියර්ස්" },
            { "timezone.excity.Africa/Conakry", "කොනක්‍රි" },
            { "timezone.excity.Africa/Kampala", "කම්පාලා" },
            { "timezone.excity.Africa/Mbabane", "ම්බබානේ" },
            { "timezone.excity.Africa/Nairobi", "නයිරෝබි" },
            { "timezone.excity.Africa/Tripoli", "ට්‍රිපොලි" },
            { "timezone.excity.America/Belize", "බෙලීස්" },
            { "timezone.excity.America/Bogota", "බොගොටා" },
            { "timezone.excity.America/Cancun", "කැන්කුන්" },
            { "timezone.excity.America/Cayman", "කේමන්" },
            { "timezone.excity.America/Cuiaba", "කුයිඅබා" },
            { "timezone.excity.America/Dawson", "ඩෝසන්" },
            { "timezone.excity.America/Denver", "ඩෙන්වර්" },
            { "timezone.excity.America/Guyana", "ගයනාව" },
            { "timezone.excity.America/Havana", "හවානා" },
            { "timezone.excity.America/Inuvik", "ඉනුවික්" },
            { "timezone.excity.America/Juneau", "ජූනෝ" },
            { "timezone.excity.America/La_Paz", "ලා පස්" },
            { "timezone.excity.America/Maceio", "මසේයියෝ" },
            { "timezone.excity.America/Manaus", "මැනෝස්" },
            { "timezone.excity.America/Merida", "මෙරිඩා" },
            { "timezone.excity.America/Nassau", "නස්සෝ" },
            { "timezone.excity.America/Panama", "පැනමා" },
            { "timezone.excity.America/Recife", "රෙසිෆ්" },
            { "timezone.excity.America/Regina", "රෙජිනා" },
            { "timezone.excity.Asia/Famagusta", "ෆැමගුස්ටා" },
            { "timezone.excity.Asia/Hong_Kong", "හොංකොං" },
            { "timezone.excity.Asia/Jerusalem", "ජෙරුසලම" },
            { "timezone.excity.Asia/Kamchatka", "කම්චට්කා" },
            { "timezone.excity.Asia/Pontianak", "පොන්ටියනක්" },
            { "timezone.excity.Asia/Pyongyang", "ප්යෝන්ග්යැන්ග්" },
            { "timezone.excity.Asia/Qyzylorda", "ක්යිසිලෝර්ඩා" },
            { "timezone.excity.Asia/Samarkand", "සාමාර්කන්ඩ්" },
            { "timezone.excity.Asia/Singapore", "සිංගප්පූරුව" },
            { "timezone.excity.Asia/Vientiane", "වියැන්ටියන්" },
            { "timezone.excity.Europe/Andorra", "ඇන්ඩෝරාව" },
            { "timezone.excity.Europe/Saratov", "සරටොව්" },
            { "timezone.excity.Europe/Tallinn", "ටලින්" },
            { "timezone.excity.Europe/Vatican", "වතිකානුව" },
            { "timezone.excity.Europe/Vilnius", "විල්නියුස්" },
            { "timezone.excity.Indian/Mayotte", "මයෝටි" },
            { "timezone.excity.Indian/Reunion", "රියුනියන්" },
            { "timezone.excity.Pacific/Easter", "ඊස්ටර්" },
            { "timezone.excity.Pacific/Kosrae", "කොස්රේ" },
            { "timezone.excity.Pacific/Majuro", "මජුරෝ" },
            { "timezone.excity.Pacific/Midway", "මිඩ්වේ" },
            { "timezone.excity.Pacific/Noumea", "නෝමියා" },
            { "timezone.excity.Pacific/Ponape", "පොන්පෙයි" },
            { "timezone.excity.Pacific/Saipan", "සයිපාන්" },
            { "timezone.excity.Pacific/Tahiti", "ටහිති" },
            { "timezone.excity.Pacific/Tarawa", "ටරාවා" },
            { "timezone.excity.Pacific/Wallis", "වැලිස්" },
            { "timezone.excity.Africa/Blantyre", "බ්ලන්ටයර්" },
            { "timezone.excity.Africa/Djibouti", "ජිබුටි" },
            { "timezone.excity.Africa/El_Aaiun", "එල් ආයුන්" },
            { "timezone.excity.Africa/Freetown", "ෆ්‍රීටවුන්" },
            { "timezone.excity.Africa/Gaborone", "ගැබරෝන්" },
            { "timezone.excity.Africa/Khartoum", "කාර්ටොම්" },
            { "timezone.excity.Africa/Kinshasa", "කින්ශාසා" },
            { "timezone.excity.Africa/Monrovia", "මොන්රොවියා" },
            { "timezone.excity.Africa/Ndjamena", "ද්ජමෙනා" },
            { "timezone.excity.Africa/Sao_Tome", "සාඕ තෝම්" },
            { "timezone.excity.Africa/Windhoek", "වින්ඩ්හොඑක්" },
            { "timezone.excity.America/Antigua", "ඇන්ටිගුවා" },
            { "timezone.excity.America/Caracas", "කරකස්" },
            { "timezone.excity.America/Cayenne", "කේයෙන්" },
            { "timezone.excity.America/Chicago", "චිකාගෝ" },
            { "timezone.excity.America/Cordoba", "කොර්දොබා" },
            { "timezone.excity.America/Creston", "ක්‍රෙස්ටන්" },
            { "timezone.excity.America/Curacao", "කුරකාවෝ" },
            { "timezone.excity.America/Detroit", "ඩෙත්රුවා" },
            { "timezone.excity.America/Godthab", "නූක්" },
            { "timezone.excity.America/Grenada", "ග්‍රැනඩා" },
            { "timezone.excity.America/Halifax", "හලිෆැක්ස්" },
            { "timezone.excity.America/Iqaluit", "ඉකාලුයිට්" },
            { "timezone.excity.America/Jamaica", "ජැමෙයිකා" },
            { "timezone.excity.America/Managua", "මනගුආ" },
            { "timezone.excity.America/Marigot", "මැරිගොට්" },
            { "timezone.excity.America/Mendoza", "මෙන්ඩෝසා" },
            { "timezone.excity.America/Moncton", "මොන්ක්ටන්" },
            { "timezone.excity.America/Noronha", "නොරොන්හා" },
            { "timezone.excity.America/Ojinaga", "ඔජිනගා" },
            { "timezone.excity.America/Phoenix", "ෆීනික්ස්" },
            { "timezone.excity.America/Tijuana", "ටිජුආනා" },
            { "timezone.excity.America/Toronto", "ටොරන්ටෝ" },
            { "timezone.excity.America/Tortola", "ටොර්ටෝලා" },
            { "timezone.excity.America/Yakutat", "යකුටට්" },
            { "timezone.excity.Asia/Phnom_Penh", "නොම් පෙන්" },
            { "timezone.excity.Atlantic/Azores", "ඇසොරේ" },
            { "timezone.excity.Atlantic/Canary", "කැනරි" },
            { "timezone.excity.Atlantic/Faeroe", "ෆාරෝ" },
            { "timezone.excity.Australia/Eucla", "ඉයුක්ලා" },
            { "timezone.excity.Australia/Perth", "පර්ත්" },
            { "timezone.excity.Europe/Belgrade", "බෙල්ග්‍රේඩ්ඩ්" },
            { "timezone.excity.Europe/Brussels", "බ්‍රසල්ස්" },
            { "timezone.excity.Europe/Budapest", "බුඩාපෙස්ට්" },
            { "timezone.excity.Europe/Busingen", "බුසින්ජෙන්" },
            { "timezone.excity.Europe/Chisinau", "චිසිනෝ" },
            { "timezone.excity.Europe/Guernsey", "ගුවන්සේ" },
            { "timezone.excity.Europe/Helsinki", "හෙල්සින්කි" },
            { "timezone.excity.Europe/Istanbul", "ඉස්තාන්බුල්" },
            { "timezone.excity.Europe/Sarajevo", "සරාජෙවෝ" },
            { "timezone.excity.Indian/Maldives", "මාල දිවයින" },
            { "timezone.excity.Pacific/Chatham", "චැතම්" },
            { "timezone.excity.Pacific/Fakaofo", "ෆාකාඕෆෝ" },
            { "timezone.excity.Pacific/Gambier", "ගම්බියෙර්" },
            { "timezone.excity.Pacific/Norfolk", "නෝෆෝක්" },
            { "timezone.excity.Africa/Bujumbura", "බුජුම්බුරා" },
            { "timezone.excity.Africa/Mogadishu", "මොගඩිෂු" },
            { "timezone.excity.America/Anguilla", "ඇන්ගුයිලාව" },
            { "timezone.excity.America/Asuncion", "අසුන්සියොන්" },
            { "timezone.excity.America/Barbados", "බාබඩෝස්" },
            { "timezone.excity.America/Dominica", "ඩොමිනිකා" },
            { "timezone.excity.America/Edmonton", "එඩ්මන්ටන්" },
            { "timezone.excity.America/Eirunepe", "එයිරුනේප්" },
            { "timezone.excity.America/Mazatlan", "මසට්ලාන්" },
            { "timezone.excity.America/Miquelon", "මිකියුලන්" },
            { "timezone.excity.America/New_York", "නිව්යෝක්" },
            { "timezone.excity.America/Resolute", "රෙසොලුට්" },
            { "timezone.excity.America/Santarem", "සන්ටරේම්" },
            { "timezone.excity.America/Santiago", "සන්තියාගෝ" },
            { "timezone.excity.America/St_Johns", "ශාන්ත ජෝන්ගේ" },
            { "timezone.excity.America/St_Kitts", "ශාන්ත කිට්ස්" },
            { "timezone.excity.America/St_Lucia", "ශාන්ත ලුසියා" },
            { "timezone.excity.America/Winnipeg", "විනිපෙග්" },
            { "timezone.excity.Antarctica/Casey", "කැසේ" },
            { "timezone.excity.Antarctica/Davis", "ඩේවිස්" },
            { "timezone.excity.Antarctica/Syowa", "සියෝවා" },
            { "timezone.excity.Antarctica/Troll", "ට්‍රෝල්" },
            { "timezone.excity.Asia/Krasnoyarsk", "ක්‍රස්නෝයාර්ස්ක්" },
            { "timezone.excity.Asia/Novosibirsk", "නොවොසිබර්ස්ක්" },
            { "timezone.excity.Asia/Ulaanbaatar", "උලාන්බාටර්" },
            { "timezone.excity.Asia/Vladivostok", "ව්ලඩිවොස්ටොක්" },
            { "timezone.excity.Atlantic/Bermuda", "බර්මියුඩා" },
            { "timezone.excity.Atlantic/Madeira", "මඩෙයිරා" },
            { "timezone.excity.Atlantic/Stanley", "ස්ටැන්ලි" },
            { "timezone.excity.Australia/Darwin", "ඩාවින්" },
            { "timezone.excity.Australia/Hobart", "හෝබාර්ට්" },
            { "timezone.excity.Australia/Sydney", "සිඩ්නි" },
            { "timezone.excity.Europe/Amsterdam", "ඇම්ස්ටර්ඩෑම්" },
            { "timezone.excity.Europe/Astrakhan", "අස්ට්‍රඛාන්" },
            { "timezone.excity.Europe/Bucharest", "බුකාරෙස්ට්" },
            { "timezone.excity.Europe/Gibraltar", "ජිබ්රෝල්ටා" },
            { "timezone.excity.Europe/Ljubljana", "ල්ජුබුල්ජනා" },
            { "timezone.excity.Europe/Mariehamn", "මරියෙහම්න්" },
            { "timezone.excity.Europe/Podgorica", "පොඩ්ගොරිකා" },
            { "timezone.excity.Europe/Stockholm", "ස්ටොක්හෝම්" },
            { "timezone.excity.Europe/Ulyanovsk", "උල්යනොව්ස්ක්" },
            { "timezone.excity.Europe/Volgograd", "වොල්ගොග්‍රෑඩ්" },
            { "timezone.excity.Indian/Christmas", "ක්‍රිස්මස්" },
            { "timezone.excity.Indian/Kerguelen", "කෙර්ගුඑලෙන්" },
            { "timezone.excity.Indian/Mauritius", "මුරුසිය" },
            { "timezone.excity.Pacific/Auckland", "ඕක්ලන්ඩ්" },
            { "timezone.excity.Pacific/Funafuti", "ෆුනෆුටි" },
            { "timezone.excity.Pacific/Honolulu", "හොනොලුලු" },
            { "timezone.excity.Pacific/Pitcairn", "පිට්කෙයාන්" },
            { "timezone.excity.Africa/Casablanca", "කැසබ්ලන්කා" },
            { "timezone.excity.Africa/Libreville", "ලිබ්රවිල්" },
            { "timezone.excity.Africa/Lubumbashi", "ලුබුම්බාශි" },
            { "timezone.excity.Africa/Nouakchott", "නුආක්චොට්" },
            { "timezone.excity.Africa/Porto-Novo", "පොර්තෝ-නොවෝ" },
            { "timezone.excity.America/Anchorage", "ඇනකොරාජ්" },
            { "timezone.excity.America/Araguaina", "ඇරගුඅයිනා" },
            { "timezone.excity.America/Boa_Vista", "බොආ විස්ටා" },
            { "timezone.excity.America/Catamarca", "කටමර්කා" },
            { "timezone.excity.America/Chihuahua", "චිහුආහුආ" },
            { "timezone.excity.America/Coyhaique", "කොයිහයික්" },
            { "timezone.excity.America/Fortaleza", "ෆොර්ටලේසා" },
            { "timezone.excity.America/Glace_Bay", "ග්ලේස් බොක්ක" },
            { "timezone.excity.America/Goose_Bay", "ගූස් බොක්ක" },
            { "timezone.excity.America/Guatemala", "ගෝතමාලාව" },
            { "timezone.excity.America/Guayaquil", "ගුඅයාකුයිල්" },
            { "timezone.excity.America/Matamoros", "මටමොරොස්" },
            { "timezone.excity.America/Menominee", "මෙනොමිනී" },
            { "timezone.excity.America/Monterrey", "මොන්ටෙරේ" },
            { "timezone.excity.America/Sao_Paulo", "සාවෝ පෝලො" },
            { "timezone.excity.America/St_Thomas", "ශාන්ත තෝමස්" },
            { "timezone.excity.America/Vancouver", "වැන්කුවර්" },
            { "timezone.excity.Antarctica/Mawson", "මව්සන්" },
            { "timezone.excity.Antarctica/Palmer", "පැල්මර්" },
            { "timezone.excity.Antarctica/Vostok", "වොස්ටොක්" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ක්වාලාලම්පූර්" },
            { "timezone.excity.Asia/Novokuznetsk", "නොවොකුස්නේට්ස්ක්" },
            { "timezone.excity.Europe/Bratislava", "බ්‍රටිස්ලවා" },
            { "timezone.excity.Europe/Copenhagen", "කෝපන්හේගන්" },
            { "timezone.excity.Europe/Luxembourg", "ලක්සැම්බර්ග්" },
            { "timezone.excity.Europe/San_Marino", "සැන් මැරිනෝ" },
            { "timezone.excity.Europe/Simferopol", "සිම්ෆෙරෝපොල්" },
            { "timezone.excity.Pacific/Enderbury", "කැන්ටන්" },
            { "timezone.excity.Pacific/Galapagos", "ගලපගෝස්" },
            { "timezone.excity.Pacific/Kwajalein", "ක්වාජලෙයින්" },
            { "timezone.excity.Pacific/Marquesas", "මාකුවෙසාස්" },
            { "timezone.excity.Pacific/Pago_Pago", "පගෝ පගෝ" },
            { "timezone.excity.Pacific/Rarotonga", "රරෝටෝන්ගා" },
            { "timezone.excity.Pacific/Tongatapu", "ටොන්ගටාපු" },
            { "timezone.excity.Africa/Addis_Ababa", "අඩිස් අබාබා" },
            { "timezone.excity.Africa/Brazzaville", "බ්‍රසාවිල්" },
            { "timezone.excity.Africa/Ouagadougou", "ඔආගඩොගො" },
            { "timezone.excity.America/Costa_Rica", "කොස්ටරිකා" },
            { "timezone.excity.America/Grand_Turk", "ග්රෑන්ඩ් ටර්ක්" },
            { "timezone.excity.America/Guadeloupe", "ග්වාඩ්ලෝප්" },
            { "timezone.excity.America/Hermosillo", "හෙමොසිලෝ" },
            { "timezone.excity.America/Kralendijk", "ක්‍රලෙන්දිජ්ක්" },
            { "timezone.excity.America/Louisville", "ලුවිස්විල්" },
            { "timezone.excity.America/Martinique", "මාටිනික්" },
            { "timezone.excity.America/Metlakatla", "මෙට්ලකට්ලා" },
            { "timezone.excity.America/Montevideo", "මොන්ටෙවිඩියෝ" },
            { "timezone.excity.America/Montserrat", "මොන්ට්සේරාට්" },
            { "timezone.excity.America/Paramaribo", "පැරාමරිබෝ" },
            { "timezone.excity.America/Rio_Branco", "රියෝ බ්‍රන්කෝ" },
            { "timezone.excity.America/St_Vincent", "ශාන්ත වින්ට්සන්" },
            { "timezone.excity.America/Whitehorse", "වයිට්හෝර්ස්" },
            { "timezone.excity.Antarctica/McMurdo", "මැක්මුර්ඩෝ" },
            { "timezone.excity.Antarctica/Rothera", "රොතෙරා" },
            { "timezone.excity.Asia/Srednekolymsk", "ශ්‍රෙඩ්නෙකෝලිම්සක්" },
            { "timezone.excity.Asia/Yekaterinburg", "යෙකටරින්බර්ග්" },
            { "timezone.excity.Atlantic/Reykjavik", "රෙයික්ජාවික්" },
            { "timezone.excity.Atlantic/St_Helena", "ශා. හෙලේනා" },
            { "timezone.excity.Australia/Adelaide", "ඇඩිලේඩ්" },
            { "timezone.excity.Australia/Brisbane", "බ්‍රිස්බේන්" },
            { "timezone.excity.Australia/Lindeman", "ලින්ඩේමන්" },
            { "timezone.excity.Europe/Isle_of_Man", "අයිල් ඔෆ් මෑන්" },
            { "timezone.excity.Europe/Kaliningrad", "කලිනින්ග්‍රෑඩ්" },
            { "timezone.excity.Pacific/Kiritimati", "කිරිමටි" },
            { "timezone.excity.Africa/Johannesburg", "ජොහන්නස්බර්ග්" },
            { "timezone.excity.America/El_Salvador", "එල්සැල්වදෝර්" },
            { "timezone.excity.America/Fort_Nelson", "ෆෝට් නෙල්සන්" },
            { "timezone.excity.America/Los_Angeles", "ලොස් ඇන්ජලීස්" },
            { "timezone.excity.America/Mexico_City", "මෙක්සිකෝ නගරය" },
            { "timezone.excity.America/Porto_Velho", "පොර්තෝ වෙල්හෝ" },
            { "timezone.excity.America/Puerto_Rico", "පුවටොරිකෝව" },
            { "timezone.excity.America/Tegucigalpa", "ටෙගුසිගල්පා" },
            { "timezone.excity.Arctic/Longyearbyen", "ලෝන්ග්ඉයර්බියෙන්" },
            { "timezone.excity.Atlantic/Cape_Verde", "කේප් වර්ඩ්" },
            { "timezone.excity.Australia/Lord_Howe", "ලෝර්ඩ් හෝව්" },
            { "timezone.excity.Australia/Melbourne", "මෙල්බෝර්න්" },
            { "timezone.excity.Indian/Antananarivo", "ඇන්ටනානරිවෝ" },
            { "timezone.excity.Pacific/Guadalcanal", "ගුවාඩල්කැනල්" },
            { "timezone.excity.Africa/Dar_es_Salaam", "දාර් එස් සලාම්" },
            { "timezone.excity.America/Blanc-Sablon", "බ්ලැන්ක්-සැබ්ලන්" },
            { "timezone.excity.America/Buenos_Aires", "බුවනෝස් අයර්ස්" },
            { "timezone.excity.America/Campo_Grande", "කම්පෝ ග්‍රෑන්ඩ්" },
            { "timezone.excity.America/Danmarkshavn", "ඩෙන්මාර්ක්ශව්න්" },
            { "timezone.excity.America/Dawson_Creek", "ඩෝසන් ක්‍රීක්" },
            { "timezone.excity.America/Indiana/Knox", "නොක්ස්, ඉන්දියානා" },
            { "timezone.excity.America/Indianapolis", "ඉන්ඩියානපොලිස්" },
            { "timezone.excity.America/Punta_Arenas", "පුන්ටා ඇරිනාස්" },
            { "timezone.excity.America/Rankin_Inlet", "රැන්කින් පිවිසුම" },
            { "timezone.excity.America/Scoresbysund", "ඉටොකොර්ටෝමිට්" },
            { "timezone.excity.Antarctica/Macquarie", "මක්කුවරි" },
            { "timezone.excity.Pacific/Bougainville", "බෝගන්විලා" },
            { "timezone.excity.Pacific/Port_Moresby", "පොර්ට් මොරෙස්බි" },
            { "timezone.excity.America/Cambridge_Bay", "කේම්බ්‍රිජ් බොක්ක" },
            { "timezone.excity.America/Ciudad_Juarez", "සියුඩාඩ් ජුවාරෙස්" },
            { "timezone.excity.America/Coral_Harbour", "ඇටිකොකන්" },
            { "timezone.excity.America/Indiana/Vevay", "වෙවේ, ඉන්දියානා" },
            { "timezone.excity.America/Lower_Princes", "ලෝවර් ප්‍රින්සස් ක්වාටර්" },
            { "timezone.excity.America/Port_of_Spain", "පොර්ට් ඔෆ් ස්පෙයින්" },
            { "timezone.excity.America/Santo_Domingo", "සැන්ටෝ ඩොමින්ගෝ" },
            { "timezone.excity.America/St_Barthelemy", "ශාන්ත බර්තලෙමි" },
            { "timezone.excity.America/Swift_Current", "ස්විෆ්ට් කරන්ට්" },
            { "timezone.excity.Australia/Broken_Hill", "බ්‍රෝකන් හිල්" },
            { "timezone.excity.America/Bahia_Banderas", "බහියා බන්දෙරාස්" },
            { "timezone.excity.America/Port-au-Prince", "පොර්ට්-ඕ-ප්‍රින්ස්" },
            { "timezone.excity.Atlantic/South_Georgia", "දකුණු ජෝර්ජියාව" },
            { "timezone.excity.America/Argentina/Salta", "සොල්ටා" },
            { "timezone.excity.America/Indiana/Marengo", "මරෙන්ගෝ, ඉන්දියානා" },
            { "timezone.excity.America/Indiana/Winamac", "විනමැක්, ඉන්දියානා" },
            { "timezone.excity.America/Argentina/Tucuman", "ටුකුමන්" },
            { "timezone.excity.America/Argentina/Ushuaia", "උෂුඅයියා" },
            { "timezone.excity.America/Indiana/Tell_City", "ටෙල් නගරය, ඉන්දියානා" },
            { "timezone.excity.America/Indiana/Vincennes", "වින්සනස්, ඉන්දියානා" },
            { "timezone.excity.Antarctica/DumontDUrville", "ඩුමොන්ට් ඩු‘ර්විල්" },
            { "timezone.excity.America/Argentina/La_Rioja", "ලා රිජෝලා" },
            { "timezone.excity.America/Argentina/San_Juan", "සැන් ජුවාන්" },
            { "timezone.excity.America/Argentina/San_Luis", "සැන් ලුවිස්" },
            { "timezone.excity.America/Indiana/Petersburg", "පීටර්ස්බර්ග්, ඉන්දියානා" },
            { "timezone.excity.America/Kentucky/Monticello", "මොන්ටිසෙලෝ, කෙන්ටකි" },
            { "timezone.excity.America/North_Dakota/Beulah", "බියුලා, උතුරු ඩකෝටා" },
            { "timezone.excity.America/North_Dakota/Center", "මධ්‍යම, උතුරු ඩකෝටා" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "රියෝ ගලෙගොස්" },
            { "timezone.excity.America/North_Dakota/New_Salem", "නව සලෙම්ම, උතුරු ඩකෝටා" },
        };
        return data;
    }
}
