/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.collectors;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/collectors/InstanceCollector;", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "klass", "Ljava/lang/Class;", "visitNestedDeclarations", "", "<init>", "(Ljava/lang/Class;Z)V", "getKlass", "()Ljava/lang/Class;", "getVisitNestedDeclarations", "()Z", "collected", "", "getCollected", "()Ljava/util/List;", "visitFunction", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "visitElement", "node", "js.translator"})
public final class InstanceCollector<T extends JsNode>
extends RecursiveJsVisitor {
    @NotNull
    private final Class<T> klass;
    private final boolean visitNestedDeclarations;
    @NotNull
    private final List<T> collected;

    public InstanceCollector(@NotNull Class<T> klass, boolean visitNestedDeclarations) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
        this.visitNestedDeclarations = visitNestedDeclarations;
        this.collected = new ArrayList();
    }

    @NotNull
    public final Class<T> getKlass() {
        return this.klass;
    }

    public final boolean getVisitNestedDeclarations() {
        return this.visitNestedDeclarations;
    }

    @NotNull
    public final List<T> getCollected() {
        return this.collected;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (this.visitNestedDeclarations) {
            this.visitElement(x);
        }
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (this.visitNestedDeclarations) {
            this.visitElement(x);
        }
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.klass.isInstance(node)) {
            T t = this.klass.cast(node);
            Intrinsics.checkNotNull(t);
            this.collected.add(t);
        }
        super.visitElement(node);
    }
}

