/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;

class ServiceLoaderRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaderRegistry.class);

    ServiceLoaderRegistry() {
    }

    <T> Iterable<T> load(Class<T> serviceProviderClass) {
        ServiceLoader listeners = ServiceLoader.load(serviceProviderClass, ClassLoaderUtils.getDefaultClassLoader());
        logger.config(() -> "Loaded " + serviceProviderClass.getSimpleName() + " instances: " + StreamSupport.stream(listeners.spliterator(), false).map(Object::toString).collect(Collectors.toList()));
        return listeners;
    }
}

