/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.jetty.certificate.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGenerator
implements BundleActivator {
    private static final String JETTY_KEYSTORE_PATH_PROPERTY = "jetty.keystore.path";
    private static final String KEYSTORE_PASSWORD = "openhab";
    private static final String KEYSTORE_ENTRY_ALIAS = "mykey";
    private static final String KEYSTORE_JKS_TYPE = "JKS";
    private static final String CURVE_NAME = "prime256v1";
    private static final String KEY_PAIR_GENERATOR_TYPE = "EC";
    private static final String KEY_FACTORY_TYPE = "EC";
    private static final String CONTENT_SIGNER_ALGORITHM = "SHA256withECDSA";
    private static final String CERTIFICATE_X509_TYPE = "X.509";
    private static final String X500_NAME = "CN=openhab.org, OU=None, O=None, L=None, C=None";
    private Logger logger;
    private File keystoreFile;

    public void start(BundleContext context) throws Exception {
        this.logger = LoggerFactory.getLogger(CertificateGenerator.class);
        try {
            KeyStore keystore = this.ensureKeystore();
            if (!this.isCertificateInKeystore(keystore)) {
                this.logger.debug("{} alias not found. Generating a new certificate.", (Object)KEYSTORE_ENTRY_ALIAS);
                this.generateCertificate(keystore);
            } else {
                this.logger.debug("{} alias found. Do nothing.", (Object)KEYSTORE_ENTRY_ALIAS);
            }
        }
        catch (KeyStoreException | CertificateException e) {
            this.logger.error("Failed to generate a new SSL Certificate.", (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private KeyStore ensureKeystore() throws KeyStoreException {
        String keystorePath = System.getProperty(JETTY_KEYSTORE_PATH_PROPERTY);
        this.keystoreFile = new File(keystorePath);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_JKS_TYPE);
        if (!this.keystoreFile.exists()) {
            try {
                this.logger.debug("No keystore found. Creation of {}", (Object)this.keystoreFile.getAbsolutePath());
                boolean newFileCreated = this.keystoreFile.createNewFile();
                if (!newFileCreated) {
                    throw new IOException("Keystore file creation failed.");
                }
                keyStore.load(null, null);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new KeyStoreException("Failed to create the keystore " + this.keystoreFile.getAbsolutePath(), e);
            }
        }
        try {
            Throwable e = null;
            Object var4_8 = null;
            try (FileInputStream keystoreStream = new FileInputStream(this.keystoreFile);){
                this.logger.debug("Keystore found. Trying to load {}", (Object)this.keystoreFile.getAbsolutePath());
                keyStore.load(keystoreStream, KEYSTORE_PASSWORD.toCharArray());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Failed to load the keystore " + this.keystoreFile.getAbsolutePath(), e);
        }
        return keyStore;
    }

    private boolean isCertificateInKeystore(KeyStore keystore) throws KeyStoreException {
        return keystore.getCertificate(KEYSTORE_ENTRY_ALIAS) != null;
    }

    private void generateCertificate(KeyStore keystore) throws CertificateException, KeyStoreException {
        try {
            long startTime = System.currentTimeMillis();
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(CURVE_NAME);
            ECFieldFp field = new ECFieldFp(ecSpec.getCurve().getField().getCharacteristic());
            EllipticCurve curve = new EllipticCurve(field, ecSpec.getCurve().getA().toBigInteger(), ecSpec.getCurve().getB().toBigInteger());
            ECPoint pointG = new ECPoint(ecSpec.getG().getXCoord().toBigInteger(), ecSpec.getG().getYCoord().toBigInteger());
            ECParameterSpec spec = new ECParameterSpec(curve, pointG, ecSpec.getN(), ecSpec.getH().intValue());
            KeyPairGenerator g = KeyPairGenerator.getInstance("EC");
            g.initialize(spec, new SecureRandom());
            KeyPair keysPair = g.generateKeyPair();
            ECPrivateKeySpec ecPrivSpec = new ECPrivateKeySpec(((ECPrivateKey)keysPair.getPrivate()).getS(), spec);
            ECPublicKeySpec ecPublicSpec = new ECPublicKeySpec(((ECPublicKey)keysPair.getPublic()).getW(), spec);
            KeyFactory kf = KeyFactory.getInstance("EC");
            PrivateKey privateKey = kf.generatePrivate(ecPrivSpec);
            PublicKey publicKey = kf.generatePublic(ecPublicSpec);
            this.logger.debug("Keys generated in {} ms.", (Object)(System.currentTimeMillis() - startTime));
            X500Name issuerDN = new X500Name(X500_NAME);
            Integer randomNumber = new Random().nextInt();
            BigInteger serialNumber = BigInteger.valueOf(randomNumber >= 0 ? randomNumber : randomNumber * -1);
            Date notBefore = new Date(System.currentTimeMillis() - 2592000000L);
            Date notAfter = new Date(System.currentTimeMillis() + 315360000000L);
            X500Name subjectDN = new X500Name(X500_NAME);
            byte[] publickeyb = publicKey.getEncoded();
            ASN1Sequence sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(publickeyb);
            SubjectPublicKeyInfo subPubKeyInfo = new SubjectPublicKeyInfo(sequence);
            X509v3CertificateBuilder v3CertGen = new X509v3CertificateBuilder(issuerDN, serialNumber, notBefore, notAfter, subjectDN, subPubKeyInfo);
            ContentSigner contentSigner = new JcaContentSignerBuilder(CONTENT_SIGNER_ALGORITHM).build(keysPair.getPrivate());
            X509CertificateHolder certificateHolder = v3CertGen.build(contentSigner);
            Certificate certificate = CertificateFactory.getInstance(CERTIFICATE_X509_TYPE).generateCertificate(new ByteArrayInputStream(ByteBuffer.wrap(certificateHolder.toASN1Structure().getEncoded()).array()));
            this.logger.debug("Total certificate generation time: {} ms.", (Object)(System.currentTimeMillis() - startTime));
            keystore.setKeyEntry(KEYSTORE_ENTRY_ALIAS, privateKey, KEYSTORE_PASSWORD.toCharArray(), new Certificate[]{certificate});
            this.logger.debug("Save the keystore into {}.", (Object)this.keystoreFile.getAbsolutePath());
            keystore.store(new FileOutputStream(this.keystoreFile), KEYSTORE_PASSWORD.toCharArray());
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidKeySpecException | OperatorCreationException e) {
            throw new CertificateException("Failed to generate the new certificate.", e);
        }
    }
}

