/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.lang.reflect.ReflectPermission;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegateFinder;

public abstract class RuntimeDelegate {
    public static final String JAXRS_RUNTIME_DELEGATE_PROPERTY = "javax.ws.rs.ext.RuntimeDelegate";
    private static final Object LOCK = new Object();
    private static ReflectPermission suppressAccessChecksPermission = new ReflectPermission("suppressAccessChecks");
    private static volatile RuntimeDelegate cachedDelegate;

    protected RuntimeDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeDelegate getInstance() {
        RuntimeDelegate result = cachedDelegate;
        if (result == null) {
            Object object = LOCK;
            synchronized (object) {
                result = cachedDelegate;
                if (result == null) {
                    cachedDelegate = result = RuntimeDelegate.findDelegate();
                }
            }
        }
        return result;
    }

    private static RuntimeDelegate findDelegate() {
        try {
            Object delegate = RuntimeDelegateFinder.find(JAXRS_RUNTIME_DELEGATE_PROPERTY);
            if (!RuntimeDelegate.class.isInstance(delegate)) {
                throw new LinkageError(delegate + " not an instance of RuntimeDelegate");
            }
            return (RuntimeDelegate)RuntimeDelegate.class.cast(delegate);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(RuntimeDelegate rd) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(suppressAccessChecksPermission);
        }
        Object object = LOCK;
        synchronized (object) {
            cachedDelegate = rd;
        }
    }

    public abstract UriBuilder createUriBuilder();

    public abstract Response.ResponseBuilder createResponseBuilder();

    public abstract Variant.VariantListBuilder createVariantListBuilder();

    public abstract <T> T createEndpoint(Application var1, Class<T> var2) throws IllegalArgumentException, UnsupportedOperationException;

    public abstract <T> HeaderDelegate<T> createHeaderDelegate(Class<T> var1) throws IllegalArgumentException;

    public abstract Link.Builder createLinkBuilder();

    public static interface HeaderDelegate<T> {
        public T fromString(String var1);

        public String toString(T var1);
    }
}

