/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx;

import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;

public class WithSingleStrictSubscriber<F, S>
implements FlowableWithSingleSubscriber<F, S>,
Subscription {
    @NotNull
    private final WithSingleSubscriber<F, S> subscriber;
    private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
    @NotNull
    private final AtomicLong requested = new AtomicLong();
    @NotNull
    private final AtomicInteger wip = new AtomicInteger();
    @Nullable
    private Throwable error;

    public WithSingleStrictSubscriber(@NotNull WithSingleSubscriber<F, S> subscriber) {
        this.subscriber = subscriber;
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        if (this.subscription.compareAndSet(null, this)) {
            this.subscriber.onSubscribe(this);
            if (this.subscription.compareAndSet(this, subscription)) {
                long requested = this.requested.getAndSet(0L);
                if (requested != 0L) {
                    subscription.request(requested);
                }
            } else {
                subscription.cancel();
            }
        } else {
            subscription.cancel();
            this.cancel();
            this.onError(new IllegalStateException("\u00a72.12 violated: onSubscribe must be called at most once"));
        }
    }

    @Override
    public void onSingle(@NotNull S s) {
        this.subscriber.onSingle(s);
    }

    public void onNext(@NotNull F f) {
        if (this.wip.compareAndSet(0, 1)) {
            this.subscriber.onNext(f);
            if (this.wip.decrementAndGet() != 0) {
                if (this.error == null) {
                    this.subscriber.onComplete();
                } else {
                    this.subscriber.onError(this.error);
                    this.error = null;
                }
            }
        }
    }

    public void onError(@NotNull Throwable throwable) {
        this.error = throwable;
        if (this.wip.getAndIncrement() == 0) {
            this.subscriber.onError(throwable);
            this.error = null;
        }
    }

    public void onComplete() {
        if (this.wip.getAndIncrement() == 0) {
            this.subscriber.onComplete();
        }
    }

    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.onError(new IllegalArgumentException("\u00a73.9 violated: positive request amount required but it was " + n));
        } else {
            Subscription subscription = this.subscription.get();
            if (subscription != null && subscription != this) {
                subscription.request(n);
            } else {
                long requested;
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                subscription = this.subscription.get();
                if (subscription != null && subscription != this && (requested = this.requested.getAndSet(0L)) != 0L) {
                    subscription.request(requested);
                }
            }
        }
    }

    public void cancel() {
        Subscription subscription = this.subscription.getAndSet((Subscription)SubscriptionHelper.CANCELLED);
        if (subscription != null && subscription != this && subscription != SubscriptionHelper.CANCELLED) {
            subscription.cancel();
        }
    }
}

