/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AISqlFormatter;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.impl.AIDatabaseSnapshotService;
import org.jkiss.dbeaver.model.ai.impl.AIEngineRequestFactory;
import org.jkiss.dbeaver.model.ai.impl.DummyTokenCounter;
import org.jkiss.dbeaver.model.ai.impl.SimpleSqlFormatterImpl;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.ThrowableSupplier;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AIAssistantImpl
implements AIAssistant {
    private static final Log log = Log.getLog(AIAssistantImpl.class);
    private static final int MANY_REQUESTS_RETRIES = 3;
    private static final int MANY_REQUESTS_TIMEOUT = 500;
    public static final String LOG_INDENT = "\t";
    protected final DBPWorkspace workspace;
    protected final AIEngineRequestFactory requestFactory;
    protected AISqlFormatter sqlFormatter;

    public AIAssistantImpl(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
        this.requestFactory = this.createRequestFactory();
        try {
            this.sqlFormatter = AIAssistantRegistry.getInstance().getDescriptor().createSqlFormatter();
        }
        catch (DBException e) {
            log.error((Object)"Error creating SQL formatter", (Throwable)e);
            this.sqlFormatter = new SimpleSqlFormatterImpl();
        }
    }

    protected AIEngineRequestFactory createRequestFactory() {
        return new AIEngineRequestFactory(new AIDatabaseSnapshotService(), new DummyTokenCounter());
    }

    @Override
    @NotNull
    public String generateText(@NotNull DBRProgressMonitor monitor, @Nullable AIDatabaseContext context, @NotNull AIPromptGenerator systemGenerator, @NotNull List<AIMessage> messages) throws DBException {
        AIAssistantImpl.checkAiEnablement();
        Throwable throwable = null;
        Object var6_7 = null;
        try (AIEngine engine = this.createEngine();){
            String systemPrompt = systemGenerator.build();
            AIEngineRequest completionRequest = this.requestFactory.build(monitor, systemPrompt, context, messages, engine.getContextWindowSize(monitor));
            AIEngineResponse completionResponse = this.requestCompletion(engine, monitor, completionRequest);
            return (String)completionResponse.variants().stream().findFirst().orElseThrow(() -> new DBException("Empty AI response when executing command"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void checkAiEnablement() throws DBException {
        if (AISettingsManager.getInstance().getSettings().isAiDisabled()) {
            throw new DBException("AI integration is disabled");
        }
    }

    public static String getActiveEngineId() {
        return AISettingsManager.getInstance().getSettings().activeEngine();
    }

    public boolean isEngineSupports(Class<?> api) {
        return AIEngineRegistry.getInstance().isEngineSupports(AIAssistantImpl.getActiveEngineId(), api);
    }

    @NotNull
    public AIEngine createEngine() throws DBException {
        return AIEngineRegistry.getInstance().createEngine(AIAssistantImpl.getActiveEngineId());
    }

    protected AIEngineResponse requestCompletion(@NotNull AIEngine engine, @NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        try {
            boolean loggingEnabled = this.isLoggingEnabled();
            if (loggingEnabled) {
                log.debug((Object)("AI request:\n" + CommonUtils.addTextIndent((String)request.toString(), (String)LOG_INDENT)));
            }
            AIEngineResponse completionResponse = AIAssistantImpl.callWithRetry(() -> engine.requestCompletion(monitor, request));
            if (loggingEnabled) {
                log.debug((Object)("AI response:\n" + CommonUtils.addTextIndent((String)completionResponse.toString(), (String)LOG_INDENT)));
            }
            return completionResponse;
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw (DBException)((Object)e);
            }
            throw new DBException("Error requesting completion", (Throwable)e);
        }
    }

    protected boolean isLoggingEnabled() throws DBException {
        AIEngineProperties activeEngineConfiguration = this.getActiveEngineConfiguration();
        if (activeEngineConfiguration == null) {
            log.warn((Object)"No active AI engine configuration found");
            return false;
        }
        return activeEngineConfiguration.isLoggingEnabled();
    }

    @Nullable
    private AIEngineProperties getActiveEngineConfiguration() throws DBException {
        AISettingsManager settingsManager = AISettingsManager.getInstance();
        String activeEngine = settingsManager.getSettings().activeEngine();
        if (activeEngine == null || activeEngine.isEmpty()) {
            log.warn((Object)"No active AI engine configured");
            return null;
        }
        return settingsManager.getSettings().getEngineConfiguration(activeEngine);
    }

    protected static <T> T callWithRetry(ThrowableSupplier<T, DBException> supplier) throws DBException {
        int retry = 0;
        while (retry < 3) {
            try {
                return supplier.get();
            }
            catch (TooManyRequestsException tooManyRequestsException) {
                if (++retry >= 3) continue;
                log.debug((Object)"Too many engine requests. Retry after 500ms");
                RuntimeUtils.pause((int)500);
            }
        }
        throw new DBException("Request failed after 3 attempts");
    }
}

