/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class TypeNullability {
    public static final TypeNullability UNKNOWN = new TypeNullability(Nullability.UNKNOWN, NullabilitySource.Standard.NONE);
    public static final TypeNullability NOT_NULL_MANDATED = new TypeNullability(Nullability.NOT_NULL, NullabilitySource.Standard.MANDATED);
    public static final TypeNullability NULLABLE_MANDATED = new TypeNullability(Nullability.NULLABLE, NullabilitySource.Standard.MANDATED);
    @NotNull
    private final Nullability myNullability;
    @NotNull
    private final NullabilitySource mySource;

    public TypeNullability(@NotNull Nullability nullability, @NotNull NullabilitySource source) {
        if (nullability == null) {
            TypeNullability.$$$reportNull$$$0(0);
        }
        if (source == null) {
            TypeNullability.$$$reportNull$$$0(1);
        }
        this.myNullability = nullability;
        this.mySource = source;
        if (nullability != Nullability.UNKNOWN && source == NullabilitySource.Standard.NONE) {
            throw new IllegalArgumentException("Source must be specified for non-unknown nullability");
        }
    }

    @NotNull
    public Nullability nullability() {
        Nullability nullability = this.myNullability;
        if (nullability == null) {
            TypeNullability.$$$reportNull$$$0(2);
        }
        return nullability;
    }

    @NotNull
    public NullabilitySource source() {
        NullabilitySource nullabilitySource = this.mySource;
        if (nullabilitySource == null) {
            TypeNullability.$$$reportNull$$$0(3);
        }
        return nullabilitySource;
    }

    @NotNull
    public TypeNullability inherited() {
        NullabilitySource inherited = this.mySource.inherited();
        return inherited.equals(this.mySource) ? this : new TypeNullability(this.myNullability, inherited);
    }

    @NotNull
    public TypeNullability instantiatedWith(@NotNull TypeNullability nullability) {
        if (nullability == null) {
            TypeNullability.$$$reportNull$$$0(4);
        }
        if (this.nullability() == nullability.nullability()) {
            return TypeNullability.intersect(Arrays.asList(this, nullability));
        }
        if (this.nullability() == Nullability.NOT_NULL) {
            TypeNullability typeNullability = this;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(5);
            }
            return typeNullability;
        }
        if (nullability.nullability() == Nullability.NOT_NULL && this.source() instanceof NullabilitySource.ExtendsBound) {
            TypeNullability typeNullability = nullability;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(6);
            }
            return typeNullability;
        }
        if (this.source() == NullabilitySource.Standard.NONE) {
            TypeNullability typeNullability = nullability;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(7);
            }
            return typeNullability;
        }
        TypeNullability typeNullability = this;
        if (typeNullability == null) {
            TypeNullability.$$$reportNull$$$0(8);
        }
        return typeNullability;
    }

    @NotNull
    public TypeNullability join(@NotNull TypeNullability other) {
        if (other == null) {
            TypeNullability.$$$reportNull$$$0(9);
        }
        if (this.nullability() == other.nullability()) {
            if (this.source().equals(other.source())) {
                TypeNullability typeNullability = this;
                if (typeNullability == null) {
                    TypeNullability.$$$reportNull$$$0(10);
                }
                return typeNullability;
            }
            return new TypeNullability(this.nullability(), NullabilitySource.multiSource(Arrays.asList(this.source(), other.source())));
        }
        if (this.nullability() == Nullability.NULLABLE) {
            TypeNullability typeNullability = this;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(11);
            }
            return typeNullability;
        }
        if (other.nullability() == Nullability.NULLABLE) {
            TypeNullability typeNullability = other;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(12);
            }
            return typeNullability;
        }
        TypeNullability typeNullability = this.nullability() == Nullability.UNKNOWN ? this : other;
        if (typeNullability == null) {
            TypeNullability.$$$reportNull$$$0(13);
        }
        return typeNullability;
    }

    @NotNull
    public TypeNullability meet(@NotNull TypeNullability other) {
        if (other == null) {
            TypeNullability.$$$reportNull$$$0(14);
        }
        if (this.nullability() == other.nullability()) {
            if (this.source().equals(other.source())) {
                TypeNullability typeNullability = this;
                if (typeNullability == null) {
                    TypeNullability.$$$reportNull$$$0(15);
                }
                return typeNullability;
            }
            return new TypeNullability(Nullability.NOT_NULL, NullabilitySource.multiSource(Arrays.asList(this.source(), other.source())));
        }
        if (this.nullability() == Nullability.NOT_NULL) {
            TypeNullability typeNullability = this;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(16);
            }
            return typeNullability;
        }
        if (other.nullability() == Nullability.NOT_NULL) {
            TypeNullability typeNullability = other;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(17);
            }
            return typeNullability;
        }
        TypeNullability typeNullability = this.nullability() == Nullability.NULLABLE ? this : other;
        if (typeNullability == null) {
            TypeNullability.$$$reportNull$$$0(18);
        }
        return typeNullability;
    }

    @NotNull
    public static TypeNullability ofTypeParameter(@NotNull PsiTypeParameter parameter) {
        NullabilityAnnotationInfo typeUseNullability;
        TypeNullability nullability;
        if (parameter == null) {
            TypeNullability.$$$reportNull$$$0(19);
        }
        if (!(nullability = TypeNullability.intersect(ContainerUtil.map((Object[])parameter.getSuperTypes(), PsiType::getNullability)).inherited()).equals(UNKNOWN)) {
            TypeNullability typeNullability = nullability;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(20);
            }
            return typeNullability;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(parameter.getProject());
        if (manager != null && (typeUseNullability = manager.findDefaultTypeUseNullability(parameter)) != null) {
            TypeNullability typeNullability = typeUseNullability.toTypeNullability();
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(21);
            }
            return typeNullability;
        }
        TypeNullability typeNullability = UNKNOWN;
        if (typeNullability == null) {
            TypeNullability.$$$reportNull$$$0(22);
        }
        return typeNullability;
    }

    @NotNull
    public static TypeNullability intersect(@NotNull @NotNull Collection<@NotNull TypeNullability> collection) {
        if (collection == null) {
            TypeNullability.$$$reportNull$$$0(23);
        }
        if (collection.isEmpty()) {
            TypeNullability typeNullability = UNKNOWN;
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(24);
            }
            return typeNullability;
        }
        if (collection.size() == 1) {
            TypeNullability typeNullability = collection.iterator().next();
            if (typeNullability == null) {
                TypeNullability.$$$reportNull$$$0(25);
            }
            return typeNullability;
        }
        Map map2 = collection.stream().collect(Collectors.groupingBy(TypeNullability::nullability, Collectors.mapping(TypeNullability::source, Collectors.toSet())));
        Set<NullabilitySource> sources = map2.get((Object)Nullability.NOT_NULL);
        if (sources != null) {
            return new TypeNullability(Nullability.NOT_NULL, NullabilitySource.multiSource(sources));
        }
        sources = map2.get((Object)Nullability.NULLABLE);
        if (sources != null) {
            return new TypeNullability(Nullability.NULLABLE, NullabilitySource.multiSource(sources));
        }
        sources = map2.get((Object)Nullability.UNKNOWN);
        if (sources != null) {
            return new TypeNullability(Nullability.UNKNOWN, NullabilitySource.multiSource(sources));
        }
        TypeNullability typeNullability = UNKNOWN;
        if (typeNullability == null) {
            TypeNullability.$$$reportNull$$$0(26);
        }
        return typeNullability;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeNullability that = (TypeNullability)o;
        return this.myNullability == that.myNullability && this.mySource.equals(that.mySource);
    }

    public int hashCode() {
        int result = this.myNullability.hashCode();
        result = 31 * result + this.mySource.hashCode();
        return result;
    }

    public String toString() {
        return (Object)((Object)this.myNullability) + " (" + this.mySource + ")";
    }

    @Nullable
    public NullabilityAnnotationInfo toNullabilityAnnotationInfo() {
        NullabilitySource source = this.source();
        if (source instanceof NullabilitySource.ExtendsBound) {
            source = ((NullabilitySource.ExtendsBound)source).boundSource();
        }
        if (source instanceof NullabilitySource.MultiSource) {
            source = ((NullabilitySource.MultiSource)source).sources().iterator().next();
        }
        if (source instanceof NullabilitySource.ExplicitAnnotation) {
            return new NullabilityAnnotationInfo(((NullabilitySource.ExplicitAnnotation)source).annotation(), this.nullability(), false);
        }
        if (source instanceof NullabilitySource.ContainerAnnotation) {
            return new NullabilityAnnotationInfo(((NullabilitySource.ContainerAnnotation)source).annotation(), this.nullability(), true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TypeNullability";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TypeNullability";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "nullability";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "source";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiatedWith";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "ofTypeParameter";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiatedWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ofTypeParameter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

