/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PsiArrayInitializerMemberValueImpl
extends CompositePsiElement
implements PsiArrayInitializerMemberValue {
    private static final Logger LOG = Logger.getInstance(PsiArrayInitializerMemberValueImpl.class);
    private static final TokenSet MEMBER_SET = ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET;

    public PsiArrayInitializerMemberValueImpl() {
        super(JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
    }

    @Override
    public PsiAnnotationMemberValue @NotNull [] getInitializers() {
        PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = (PsiAnnotationMemberValue[])this.getChildrenAsPsiElements(MEMBER_SET, PsiAnnotationMemberValue.ARRAY_FACTORY);
        if (psiAnnotationMemberValueArray == null) {
            PsiArrayInitializerMemberValueImpl.$$$reportNull$$$0(0);
        }
        return psiAnnotationMemberValueArray;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: {
                return this.findChildByType(JavaTokenType.RBRACE);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiArrayInitializerMemberValueImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LBRACE) {
            return 18;
        }
        if (i == JavaTokenType.RBRACE) {
            return 19;
        }
        if (MEMBER_SET.contains(child.getElementType())) {
            return 249;
        }
        return 0;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (MEMBER_SET.contains(first.getElementType()) && MEMBER_SET.contains(last.getElementType())) {
            TreeElement firstAdded = super.addInternal(first, last, anchor, before);
            JavaSourceUtil.addSeparatingComma((CompositeElement)this, (ASTNode)first, MEMBER_SET);
            return firstAdded;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiArrayInitializerMemberValueImpl.$$$reportNull$$$0(2);
        }
        if (MEMBER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma((CompositeElement)this, child);
        }
        super.deleteChildInternal(child);
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiArrayInitializerMemberValueImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationArrayInitializer(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiArrayInitializerMemberValue:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerMemberValueImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerMemberValueImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

