/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.jfr.ProgressTrackerStep;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "", "progressSteps", "", "Lcom/intellij/profiler/ultimate/jfr/ProgressTrackerStep;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "progressUIUpdater", "Ljava/util/concurrent/ScheduledFuture;", "currentStepIndex", "", "stepFractionOfTotal", "", "currentStep", "getCurrentStep", "()Lcom/intellij/profiler/ultimate/jfr/ProgressTrackerStep;", "switchToStep", "name", "", "progressTotalSteps", "", "updateIndicator", "", "addProgress", "steps", "checkCanceled", "stop", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nMultipleStepsProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleStepsProgressTracker.kt\ncom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n1#2:139\n360#3,7:140\n14#4:147\n*S KotlinDebug\n*F\n+ 1 MultipleStepsProgressTracker.kt\ncom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker\n*L\n82#1:140,7\n136#1:147\n*E\n"})
public final class MultipleStepsProgressTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ProgressTrackerStep> progressSteps;
    @NotNull
    private final ProgressIndicator indicator;
    @Nullable
    private ScheduledFuture<?> progressUIUpdater;
    private int currentStepIndex;
    private final double stepFractionOfTotal;
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy(MultipleStepsProgressTracker::LOG_delegate$lambda$5);

    public MultipleStepsProgressTracker(@NotNull List<? extends ProgressTrackerStep> progressSteps, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(progressSteps, (String)"progressSteps");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.progressSteps = progressSteps;
        this.indicator = indicator;
        this.currentStepIndex = -1;
        this.stepFractionOfTotal = 1.0 / (double)this.progressSteps.size();
        Set names = new LinkedHashSet();
        if (!(!((Collection)this.progressSteps).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (ProgressTrackerStep step : this.progressSteps) {
            if (!(!names.contains(step.getName()))) {
                boolean bl = false;
                String string = "All `progressSteps` should have unique names, '" + step.getName() + "' used twice.";
                throw new IllegalArgumentException(string.toString());
            }
            ((Collection)names).add(step.getName());
        }
        this.indicator.setIndeterminate(true);
    }

    @NotNull
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    private final ProgressTrackerStep getCurrentStep() {
        int n = ((Collection)this.progressSteps).size();
        int n2 = this.currentStepIndex;
        return (0 <= n2 ? n2 < n : false) ? this.progressSteps.get(this.currentStepIndex) : null;
    }

    @NotNull
    public final synchronized ProgressTrackerStep switchToStep(@NotNull String name, long progressTotalSteps) {
        int index;
        block5: {
            int n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List<ProgressTrackerStep> $this$indexOfFirst$iv = this.progressSteps;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<ProgressTrackerStep> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                ProgressTrackerStep item$iv;
                ProgressTrackerStep it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(index >= 0)) {
            boolean $i$a$-require-MultipleStepsProgressTracker$switchToStep$32 = false;
            String $i$a$-require-MultipleStepsProgressTracker$switchToStep$32 = "No such step: `" + name + "`";
            throw new IllegalArgumentException($i$a$-require-MultipleStepsProgressTracker$switchToStep$32.toString());
        }
        if (!(index > this.currentStepIndex)) {
            boolean bl = false;
            String string = "Step `" + name + "` is already finished";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.progressUIUpdater == null) {
            this.progressUIUpdater = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> MultipleStepsProgressTracker.switchToStep$lambda$4(this), 100L, 100L, TimeUnit.MILLISECONDS);
        }
        this.currentStepIndex = index;
        this.progressSteps.get(this.currentStepIndex).setFullProgress(progressTotalSteps);
        return this.progressSteps.get(this.currentStepIndex);
    }

    public final synchronized void updateIndicator() {
        ProgressTrackerStep step = this.getCurrentStep();
        if (step == null) {
            this.indicator.setIndeterminate(true);
            return;
        }
        this.indicator.setText(step.getText());
        double fraction = this.stepFractionOfTotal * ((double)this.currentStepIndex + step.getCurrentFraction());
        boolean bl = 0.0 <= fraction ? fraction <= 1.0 : false;
        if (bl) {
            if (fraction < this.indicator.getFraction()) {
                this.indicator.setIndeterminate(true);
                ProgressTrackerStep progressTrackerStep = this.getCurrentStep();
                Companion.getLOG().warn((progressTrackerStep != null ? progressTrackerStep.getName() : null) + " fraction: " + fraction + " is less than indicator.fraction: " + this.indicator.getFraction());
            } else {
                this.indicator.setIndeterminate(false);
                this.indicator.setFraction(fraction);
            }
        } else {
            ProgressTrackerStep progressTrackerStep = this.getCurrentStep();
            Companion.getLOG().warn((progressTrackerStep != null ? progressTrackerStep.getName() : null) + " fraction: " + fraction + ", should be in [0; 1]");
            this.indicator.setIndeterminate(true);
        }
    }

    public final synchronized void addProgress(long steps) {
        block0: {
            ProgressTrackerStep progressTrackerStep = this.getCurrentStep();
            if (progressTrackerStep == null) break block0;
            progressTrackerStep.addProgress(steps);
        }
    }

    public final void checkCanceled() throws ProcessCanceledException {
        this.indicator.checkCanceled();
    }

    public final synchronized void stop() {
        block0: {
            this.indicator.setText("");
            this.indicator.setIndeterminate(true);
            this.currentStepIndex = this.progressSteps.size();
            ScheduledFuture<?> scheduledFuture = this.progressUIUpdater;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    private static final void switchToStep$lambda$4(MultipleStepsProgressTracker this$0) {
        this$0.updateIndicator();
    }

    private static final Logger LOG_delegate$lambda$5() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MultipleStepsProgressTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

