/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.DefaultRepositoryLocation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public final class PerforceRepositoryLocation
extends DefaultRepositoryLocation {
    private final Project myProject;
    private P4Connection myConnection;
    private PerforceClient myClient;

    private PerforceRepositoryLocation(@NotNull String URL2, @Nullable P4Connection connection, @Nullable Project project) {
        if (URL2 == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(0);
        }
        super(URL2);
        assert (connection != null || project != null);
        this.myConnection = connection;
        this.myProject = project;
    }

    private PerforceRepositoryLocation(@NotNull String URL2, String location, @Nullable P4Connection connection, @Nullable Project project) {
        if (URL2 == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(1);
        }
        super(URL2, location);
        assert (connection != null || project != null);
        this.myConnection = connection;
        this.myProject = project;
    }

    @NotNull
    public static PerforceRepositoryLocation create(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(2);
        }
        return new PerforceRepositoryLocation(file.getPath(), null, project);
    }

    @NotNull
    public static PerforceRepositoryLocation create(@NotNull FilePath p, String location, Project project) {
        if (p == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(3);
        }
        return new PerforceRepositoryLocation(p.getPath(), location, null, project);
    }

    public void onAfterBatch() {
        this.myConnection = null;
        this.myClient = null;
    }

    public void onBeforeBatch() throws VcsException {
        this.myConnection = this.getConnection();
        this.myClient = this.getClient();
    }

    @NotNull
    private static P4Connection getConnection(Project project, String url) throws VcsException {
        P4Connection connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(new File(url));
        if (connection == null) {
            throw new VcsException(PerforceBundle.message("error.can.not.get.p4.connection", url));
        }
        P4Connection p4Connection = connection;
        if (p4Connection == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(4);
        }
        return p4Connection;
    }

    @NotNull
    public P4Connection getConnection() throws VcsException {
        if (this.myConnection != null) {
            P4Connection p4Connection = this.myConnection;
            if (p4Connection == null) {
                PerforceRepositoryLocation.$$$reportNull$$$0(5);
            }
            return p4Connection;
        }
        return PerforceRepositoryLocation.getConnection(this.myProject, this.getURL());
    }

    @NotNull
    public PerforceClient getClient() throws VcsException {
        if (this.myClient == null) {
            return this.createClient(this.getConnection());
        }
        PerforceClient perforceClient = this.myClient;
        if (perforceClient == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(6);
        }
        return perforceClient;
    }

    @NotNull
    private PerforceClient createClient(@NotNull P4Connection connection) {
        if (connection == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(7);
        }
        PerforceClient perforceClient = PerforceManager.getInstance(this.myProject).getClient(connection);
        if (perforceClient == null) {
            PerforceRepositoryLocation.$$$reportNull$$$0(8);
        }
        return perforceClient;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "URL";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClient";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

