/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalSimpleLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
public final class HorizontalSimpleLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    public HorizontalSimpleLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, breaks, theme);
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (this.getBreaks().isEmpty()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        if (!this.getTheme().showLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        DoubleRectangle bounds = null;
        boolean overlap = false;
        List<Double> ticks = this.getBreaks().projectOnAxis(axisDomain, axisLength, true);
        List<DoubleRectangle> boundsList = this.labelBoundsList(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        for (DoubleRectangle labelBounds : boundsList) {
            overlap = overlap || bounds != null && bounds.xRange().connected(labelBounds.xRange().expanded(4.0));
            bounds = GeometryUtil.INSTANCE.union(labelBounds, bounds);
        }
        Text.VerticalAnchor verticalAnchor = WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()] == 1 ? Text.VerticalAnchor.TOP : Text.VerticalAnchor.BOTTOM;
        DoubleRectangle doubleRectangle = bounds;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return this.createAxisLabelsLayoutInfoBuilder(doubleRectangle, overlap).labelAdditionalOffsets(null).labelHorizontalAnchor(Text.HorizontalAnchor.MIDDLE).labelVerticalAnchor(verticalAnchor).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        return BreakLabelsLayoutUtil.INSTANCE.horizontalCenteredLabelBounds(labelNormalSize);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

