/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.subPlots;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FigureSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponentHelper;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/subPlots/CompositeFigureSvgComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "elements", "", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureSvgRoot;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "elementsAreaBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "title", "", "subtitle", "caption", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "styleSheet", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;)V", "getElements$plot_builder", "()Ljava/util/List;", "getStyleSheet", "()Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "buildComponent", "", "clear", "Companion", "plot-builder"})
public final class CompositeFigureSvgComponent
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FigureSvgRoot> elements;
    @NotNull
    private final DoubleVector size;
    @NotNull
    private final DoubleRectangle elementsAreaBounds;
    @Nullable
    private final String title;
    @Nullable
    private final String subtitle;
    @Nullable
    private final String caption;
    @NotNull
    private final Theme theme;
    @NotNull
    private final StyleSheet styleSheet;
    private static final boolean DEBUG_DRAWING = false;

    public CompositeFigureSvgComponent(@NotNull List<? extends FigureSvgRoot> elements, @NotNull DoubleVector size2, @NotNull DoubleRectangle elementsAreaBounds, @Nullable String title, @Nullable String subtitle, @Nullable String caption, @NotNull Theme theme, @NotNull StyleSheet styleSheet) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter((Object)elementsAreaBounds, (String)"elementsAreaBounds");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        this.elements = elements;
        this.size = size2;
        this.elementsAreaBounds = elementsAreaBounds;
        this.title = title;
        this.subtitle = subtitle;
        this.caption = caption;
        this.theme = theme;
        this.styleSheet = styleSheet;
    }

    @NotNull
    public final List<FigureSvgRoot> getElements$plot_builder() {
        return this.elements;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @NotNull
    public final StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildComponent() {
        block3: {
            DoubleRectangle it;
            Pair<DoubleRectangle, DoubleRectangle> pair2;
            PlotTheme plotTheme = this.theme.plot();
            if (plotTheme.showBackground()) {
                void $this$buildComponent_u24lambda_u240;
                DoubleRectangle r = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.size);
                Thickness plotInset = Thickness.Companion.uniform(plotTheme.backgroundStrokeWidth() / (double)2);
                DoubleRectangle backgroundRect = plotInset.shrinkRect(r);
                Pair<DoubleRectangle, DoubleRectangle> pair3 = pair2 = new Pair<DoubleRectangle, DoubleRectangle>(backgroundRect);
                CompositeFigureSvgComponent compositeFigureSvgComponent = this;
                boolean bl = false;
                $this$buildComponent_u24lambda_u240.fillColor().set(plotTheme.backgroundFill());
                $this$buildComponent_u24lambda_u240.strokeColor().set(plotTheme.backgroundColor());
                $this$buildComponent_u24lambda_u240.strokeWidth().set(plotTheme.backgroundStrokeWidth());
                StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildComponent_u24lambda_u240, plotTheme.backgroundStrokeWidth(), plotTheme.backgroundLineType());
                compositeFigureSvgComponent.add((SvgNode)pair2);
            }
            DoubleRectangle outerBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.size);
            Thickness plotLayoutMargins = this.theme.plot().layoutMargins();
            DoubleRectangle contentAreaBounds = plotLayoutMargins.shrinkRect(outerBounds);
            pair2 = PlotSvgComponentHelper.INSTANCE.titleElementAndTextBounds(this.title, contentAreaBounds, this.elementsAreaBounds, plotTheme);
            DoubleRectangle plotTitleElementRect = (DoubleRectangle)pair2.component1();
            DoubleRectangle plotTitleTextRect = (DoubleRectangle)pair2.component2();
            Pair<DoubleRectangle, DoubleRectangle> pair4 = PlotSvgComponentHelper.INSTANCE.subtitleElementAndTextBounds(this.subtitle, contentAreaBounds, this.elementsAreaBounds, plotTitleElementRect, plotTheme);
            DoubleRectangle subtitleElementRect = (DoubleRectangle)pair4.component1();
            DoubleRectangle subtitleTextRect = (DoubleRectangle)pair4.component2();
            Pair<DoubleRectangle, DoubleRectangle> pair5 = PlotSvgComponentHelper.INSTANCE.captionElementAndTextBounds(this.caption, contentAreaBounds, this.elementsAreaBounds, plotTheme);
            DoubleRectangle captionElementRect = (DoubleRectangle)pair5.component1();
            DoubleRectangle captionTextRect = (DoubleRectangle)pair5.component2();
            DoubleRectangle doubleRectangle = plotTitleTextRect;
            if (doubleRectangle != null) {
                it = doubleRectangle;
                boolean bl = false;
                PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.title, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), plotTheme.titleJustification(), it, null, "plot-title", 32, null);
            }
            DoubleRectangle doubleRectangle2 = subtitleTextRect;
            if (doubleRectangle2 != null) {
                it = doubleRectangle2;
                boolean bl = false;
                PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), plotTheme.subtitleJustification(), it, null, "plot-subtitle", 32, null);
            }
            DoubleRectangle doubleRectangle3 = captionTextRect;
            if (doubleRectangle3 == null) break block3;
            it = doubleRectangle3;
            boolean bl = false;
            PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.caption, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), plotTheme.captionJustification(), it, null, "plot-caption", 32, null);
        }
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/subPlots/CompositeFigureSvgComponent$Companion;", "", "()V", "DEBUG_DRAWING", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

