/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.events.FilterEventData;
import org.ops4j.pax.web.service.spi.util.Path;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.PreprocessorDTO;

public class FilterModel
extends ElementModel<Filter, FilterEventData> {
    private final List<Mapping> mappingsPerDispatcherTypes = new LinkedList<Mapping>();
    private String[] flatUrlPatterns;
    private String[] flatServletNames;
    private String[] flatRegexPatterns;
    private String[] flatDispatcherTypes;
    private final List<DynamicMapping> dynamicUrlPatterns = new LinkedList<DynamicMapping>();
    private final List<DynamicMapping> dynamicServletNames = new LinkedList<DynamicMapping>();
    private final String name;
    private Map<String, String> initParams;
    private Boolean asyncSupported;
    private final Filter filter;
    private final Class<? extends Filter> filterClass;
    private boolean dynamic = false;
    private boolean preprocessor = false;

    public FilterModel(String filterName, Filter filter, Class<? extends Filter> filterClass, ServiceReference<Filter> reference) {
        this.name = filterName;
        this.filter = filter;
        this.filterClass = filterClass;
        this.setElementReference(reference);
    }

    public FilterModel(String filterName, String[] urlPatterns, String[] servletNames, String[] regexPatterns, Filter filter, Dictionary<String, String> initParams, Boolean asyncSupported) {
        this(urlPatterns, servletNames, regexPatterns, null, filterName, Utils.toMap(initParams), asyncSupported, filter, null, null, null, null);
    }

    public FilterModel(String filterName, String[] urlPatterns, String[] servletNames, String[] regexPatterns, Class<? extends Filter> filterClass, Dictionary<String, String> initParams, Boolean asyncSupported) {
        this(urlPatterns, servletNames, regexPatterns, null, filterName, Utils.toMap(initParams), asyncSupported, null, filterClass, null, null, null);
    }

    private FilterModel(String[] urlPatterns, String[] servletNames, String[] regexPatterns, String[] dispatcherTypes, String name, Map<String, String> initParams, Boolean asyncSupported, Filter filter, Class<? extends Filter> filterClass, ServiceReference<Filter> reference, Supplier<Filter> supplier, Bundle registeringBundle) {
        Class<? extends Filter> c;
        DispatcherType[] dts = new DispatcherType[dispatcherTypes == null ? 0 : dispatcherTypes.length];
        if (dts.length > 0) {
            for (int i = 0; i < dispatcherTypes.length; ++i) {
                dts[i] = DispatcherType.valueOf((String)dispatcherTypes[i].toUpperCase(Locale.ROOT));
            }
        }
        if (dts.length == 0 && initParams != null) {
            String dispatchers = initParams.remove("filter-mapping-dispatcher");
            if (dispatchers != null) {
                String[] types = dispatchers.split("\\s*,\\s*");
                dts = new DispatcherType[types.length];
                int i = 0;
                for (String t : types) {
                    dts[i++] = DispatcherType.valueOf((String)t.toUpperCase());
                }
            } else {
                dts = new DispatcherType[]{DispatcherType.REQUEST};
            }
        }
        Mapping map = new Mapping();
        map.dispatcherTypes = dts;
        map.urlPatterns = urlPatterns != null ? Path.normalizePatterns(urlPatterns) : null;
        map.servletNames = servletNames != null ? Arrays.copyOf(servletNames, servletNames.length) : null;
        String[] stringArray = map.regexPatterns = regexPatterns != null ? Arrays.copyOf(regexPatterns, regexPatterns.length) : null;
        if (map.urlPatterns != null || map.servletNames != null || map.regexPatterns != null) {
            this.mappingsPerDispatcherTypes.add(map);
        }
        this.initParams = initParams == null ? Collections.emptyMap() : new LinkedHashMap<String, String>(initParams);
        this.asyncSupported = asyncSupported;
        this.filter = filter;
        this.filterClass = filterClass;
        this.setElementReference(reference);
        this.setElementSupplier(supplier);
        this.setRegisteringBundle(registeringBundle);
        if (name == null) {
            name = this.initParams.get("filter-name");
            this.initParams.remove("filter-name");
        }
        if (name == null && (c = this.getActualClass()) != null) {
            name = c.getName();
        }
        if (name == null) {
            name = UUID.randomUUID().toString();
        }
        this.name = name;
        if (this.asyncSupported == null) {
            this.asyncSupported = "true".equalsIgnoreCase(this.initParams.remove("async-supported"));
        }
    }

    @Override
    public Boolean performValidation() {
        int sources = 0;
        sources += this.filter != null ? 1 : 0;
        sources += this.filterClass != null ? 1 : 0;
        sources += this.getElementReference() != null ? 1 : 0;
        if ((sources += this.getElementSupplier() != null ? 1 : 0) == 0) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Filter Model must specify one of: filter instance, filter class or service reference");
        }
        if (sources != 1) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Filter Model should specify a filter uniquely as instance, class or service reference");
        }
        if (this.preprocessor) {
            this.dynamicServletNames.clear();
            this.dynamicUrlPatterns.clear();
            this.mappingsPerDispatcherTypes.clear();
            Mapping mapping = new Mapping();
            mapping.setDispatcherTypes(new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC});
            mapping.setUrlPatterns(new String[]{"/*"});
            this.mappingsPerDispatcherTypes.add(mapping);
        }
        if (!this.dynamic) {
            for (Mapping map : this.mappingsPerDispatcherTypes) {
                sources = 0;
                sources += map.servletNames != null && map.servletNames.length > 0 ? 1 : 0;
                sources += map.urlPatterns != null && map.urlPatterns.length > 0 ? 1 : 0;
                if ((sources += map.regexPatterns != null && map.regexPatterns.length > 0 ? 1 : 0) != 0) continue;
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Please specify one of: servlet name mapping, url pattern mapping or regex mapping");
            }
        }
        if (this.dynamic) {
            sources = 0;
            sources += this.dynamicUrlPatterns != null && this.dynamicUrlPatterns.size() > 0 ? 1 : 0;
            if ((sources += this.dynamicServletNames != null && this.dynamicServletNames.size() > 0 ? 1 : 0) == 0) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("For dynamic filter registration, please specify one of: servlet name mapping or url pattern mapping");
            }
        }
        ArrayList<String> up = new ArrayList<String>();
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> rp = new ArrayList<String>();
        for (Mapping map : this.mappingsPerDispatcherTypes) {
            if (map.urlPatterns != null) {
                up.addAll(Arrays.asList(map.urlPatterns));
            }
            if (map.servletNames != null) {
                sn.addAll(Arrays.asList(map.servletNames));
            }
            if (map.regexPatterns == null) continue;
            rp.addAll(Arrays.asList(map.regexPatterns));
        }
        if (!up.isEmpty()) {
            this.flatUrlPatterns = up.toArray(new String[0]);
        }
        if (!sn.isEmpty()) {
            this.flatServletNames = sn.toArray(new String[0]);
        }
        if (!rp.isEmpty()) {
            this.flatRegexPatterns = rp.toArray(new String[0]);
        }
        HashSet dispatcherTypes = new HashSet();
        for (Mapping map : this.mappingsPerDispatcherTypes) {
            dispatcherTypes.addAll(Arrays.stream(map.getDispatcherTypes()).map(Enum::name).collect(Collectors.toSet()));
        }
        this.flatDispatcherTypes = dispatcherTypes.toArray(new String[0]);
        this.dtoFailureCode = -1;
        return Boolean.TRUE;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerFilter(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterFilter(this);
    }

    @Override
    public FilterEventData asEventData() {
        FilterEventData data = new FilterEventData(this.name, this.mappingsPerDispatcherTypes, this.filter, this.filterClass);
        this.setCommonEventProperties(data);
        return data;
    }

    @Override
    public int compareTo(ElementModel<Filter, FilterEventData> o) {
        int superCompare = super.compareTo(o);
        if (superCompare == 0 && o instanceof FilterModel) {
            return this.name.compareTo(((FilterModel)o).name);
        }
        return superCompare;
    }

    public FilterDTO toFilterDTO() {
        FilterDTO dto = new FilterDTO();
        dto.name = this.name;
        dto.asyncSupported = this.asyncSupported != null && this.asyncSupported != false;
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.flatUrlPatterns == null ? new String[]{} : new String[this.flatUrlPatterns.length];
        if (this.flatUrlPatterns != null) {
            System.arraycopy(this.flatUrlPatterns, 0, dto.patterns, 0, this.flatUrlPatterns.length);
        }
        String[] stringArray2 = dto.dispatcher = this.flatDispatcherTypes == null ? new String[]{} : new String[this.flatDispatcherTypes.length];
        if (this.flatDispatcherTypes != null) {
            System.arraycopy(this.flatDispatcherTypes, 0, dto.dispatcher, 0, this.flatDispatcherTypes.length);
        }
        String[] stringArray3 = dto.regexs = this.flatRegexPatterns == null ? new String[]{} : new String[this.flatRegexPatterns.length];
        if (this.flatRegexPatterns != null) {
            System.arraycopy(this.flatRegexPatterns, 0, dto.regexs, 0, this.flatRegexPatterns.length);
        }
        String[] stringArray4 = dto.servletNames = this.flatServletNames == null ? new String[]{} : new String[this.flatServletNames.length];
        if (this.flatServletNames != null) {
            System.arraycopy(this.flatServletNames, 0, dto.servletNames, 0, this.flatServletNames.length);
        }
        dto.serviceId = this.getServiceId();
        return dto;
    }

    public FailedFilterDTO toFailedFilterDTO(int dtoFailureCode) {
        FailedFilterDTO dto = new FailedFilterDTO();
        dto.name = this.name;
        dto.asyncSupported = this.asyncSupported != null && this.asyncSupported != false;
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.flatUrlPatterns == null ? new String[]{} : new String[this.flatUrlPatterns.length];
        if (this.flatUrlPatterns != null) {
            System.arraycopy(this.flatUrlPatterns, 0, dto.patterns, 0, this.flatUrlPatterns.length);
        }
        String[] stringArray2 = dto.dispatcher = this.flatDispatcherTypes == null ? new String[]{} : new String[this.flatDispatcherTypes.length];
        if (this.flatDispatcherTypes != null) {
            System.arraycopy(this.flatDispatcherTypes, 0, dto.dispatcher, 0, this.flatDispatcherTypes.length);
        }
        String[] stringArray3 = dto.regexs = this.flatRegexPatterns == null ? new String[]{} : new String[this.flatRegexPatterns.length];
        if (this.flatRegexPatterns != null) {
            System.arraycopy(this.flatRegexPatterns, 0, dto.regexs, 0, this.flatRegexPatterns.length);
        }
        String[] stringArray4 = dto.servletNames = this.flatServletNames == null ? new String[]{} : new String[this.flatServletNames.length];
        if (this.flatServletNames != null) {
            System.arraycopy(this.flatServletNames, 0, dto.servletNames, 0, this.flatServletNames.length);
        }
        dto.serviceId = this.getServiceId();
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    public PreprocessorDTO toPreprocessorDTO() {
        PreprocessorDTO dto = new PreprocessorDTO();
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.serviceId = this.getServiceId();
        return dto;
    }

    public FailedPreprocessorDTO toFailedPreprocessorDTO(int dtoFailureCode) {
        FailedPreprocessorDTO dto = new FailedPreprocessorDTO();
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.serviceId = this.getServiceId();
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    @Override
    public String toString() {
        return "FilterModel{id=" + this.getId() + ",name='" + this.name + "'" + (this.preprocessor ? ",preprocessor" : "") + (this.flatUrlPatterns == null ? "" : ",urlPatterns=" + Arrays.toString(this.flatUrlPatterns)) + (this.flatServletNames == null ? "" : ",servletNames=" + Arrays.toString(this.flatServletNames)) + (this.flatRegexPatterns == null ? "" : ",regexPatterns=" + Arrays.toString(this.flatRegexPatterns)) + (this.filter == null ? "" : ",filter=" + this.filter) + (this.filterClass == null ? "" : ",filterClass=" + this.filterClass) + ",contexts=" + this.getContextModelsInfo() + "}";
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(Boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isPreprocessor() {
        return this.preprocessor;
    }

    public void setPreprocessor(boolean preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }

    public Class<? extends Filter> getActualClass() {
        if (this.filterClass != null) {
            return this.filterClass;
        }
        if (this.filter != null) {
            return this.filter.getClass();
        }
        if (this.getElementSupplier() != null) {
            Filter s = (Filter)this.getElementSupplier().get();
            return s.getClass();
        }
        if (this.getElementReference() != null) {
            return Filter.class;
        }
        return null;
    }

    public List<Mapping> getMappingsPerDispatcherTypes() {
        return this.mappingsPerDispatcherTypes;
    }

    public List<DynamicMapping> getDynamicUrlPatterns() {
        return this.dynamicUrlPatterns;
    }

    public List<DynamicMapping> getDynamicServletNames() {
        return this.dynamicServletNames;
    }

    public void addDynamicServletNameMapping(EnumSet<DispatcherType> dispatcherTypes, String[] servletNames, boolean isMatchAfter) {
        this.dynamicServletNames.add(DynamicMapping.forServletNames(dispatcherTypes, servletNames, isMatchAfter));
    }

    public void addDynamicUrlPatternMapping(EnumSet<DispatcherType> dispatcherTypes, String[] urlPatterns, boolean isMatchAfter) {
        this.dynamicUrlPatterns.add(DynamicMapping.forUrlPatterns(dispatcherTypes, urlPatterns, isMatchAfter));
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public static class DynamicMapping
    extends Mapping {
        protected boolean after;

        public static DynamicMapping forServletNames(EnumSet<DispatcherType> dispatcherTypes, String[] servletNames, boolean isMatchAfter) {
            DynamicMapping mapping = new DynamicMapping();
            mapping.after = isMatchAfter;
            mapping.dispatcherTypes = dispatcherTypes != null ? dispatcherTypes.toArray(new DispatcherType[0]) : new DispatcherType[]{DispatcherType.REQUEST};
            mapping.servletNames = servletNames;
            return mapping;
        }

        public static DynamicMapping forUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, String[] urlPatterns, boolean isMatchAfter) {
            DynamicMapping mapping = new DynamicMapping();
            mapping.after = isMatchAfter;
            mapping.dispatcherTypes = dispatcherTypes != null ? dispatcherTypes.toArray(new DispatcherType[0]) : new DispatcherType[]{DispatcherType.REQUEST};
            mapping.urlPatterns = urlPatterns;
            return mapping;
        }

        public boolean isAfter() {
            return this.after;
        }
    }

    public static class Mapping {
        protected DispatcherType[] dispatcherTypes;
        protected String[] servletNames;
        protected String[] urlPatterns;
        protected String[] regexPatterns;
        protected int order = -1;

        public Mapping() {
        }

        public Mapping(String[] urlPatterns, String[] servletNames) {
            this.urlPatterns = urlPatterns;
            this.servletNames = servletNames;
        }

        public DispatcherType[] getDispatcherTypes() {
            return this.dispatcherTypes;
        }

        public void setDispatcherTypes(DispatcherType[] dispatcherTypes) {
            this.dispatcherTypes = dispatcherTypes;
        }

        public String[] getServletNames() {
            return this.servletNames;
        }

        public void setServletNames(String[] servletNames) {
            this.servletNames = servletNames;
        }

        public String[] getUrlPatterns() {
            return this.urlPatterns;
        }

        public void setUrlPatterns(String[] urlPatterns) {
            this.urlPatterns = urlPatterns;
        }

        public String[] getRegexPatterns() {
            return this.regexPatterns;
        }

        public void setRegexPatterns(String[] regexPatterns) {
            this.regexPatterns = regexPatterns;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }

    public static class Builder {
        private String[] urlPatterns;
        private String[] servletNames;
        private String[] regexPatterns;
        private String[] dispatcherTypes;
        private String filterName;
        private Map<String, String> initParams;
        private Boolean asyncSupported;
        private Filter filter;
        private Class<? extends Filter> filterClass;
        private ServiceReference<Filter> reference;
        private Supplier<Filter> supplier;
        private final List<OsgiContextModel> list = new LinkedList<OsgiContextModel>();
        private Bundle bundle;
        private int rank;
        private long serviceId;
        private boolean preprocessor = false;

        public Builder() {
        }

        public Builder(String filterName) {
            this.filterName = filterName;
        }

        public Builder withUrlPatterns(String[] urlPatterns) {
            this.urlPatterns = urlPatterns;
            return this;
        }

        public Builder withServletNames(String[] servletNames) {
            this.servletNames = servletNames;
            return this;
        }

        public Builder withRegexMapping(String[] regexPatterns) {
            this.regexPatterns = regexPatterns;
            return this;
        }

        public Builder withDispatcherTypes(String[] dispatcherTypes) {
            this.dispatcherTypes = dispatcherTypes;
            return this;
        }

        public Builder withFilterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public Builder withInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
            return this;
        }

        public Builder withAsyncSupported(Boolean asyncSupported) {
            this.asyncSupported = asyncSupported;
            return this;
        }

        public Builder withFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withFilterClass(Class<? extends Filter> filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        public Builder withFilterReference(ServiceReference<Filter> reference) {
            this.reference = reference;
            return this;
        }

        public Builder withFilterReference(Bundle bundle, ServiceReference<Filter> reference) {
            this.bundle = bundle;
            this.reference = reference;
            return this;
        }

        public Builder withFilterSupplier(Supplier<Filter> supplier) {
            this.supplier = supplier;
            return this;
        }

        public Builder withOsgiContextModel(OsgiContextModel osgiContextModel) {
            this.list.add(osgiContextModel);
            return this;
        }

        public Builder withOsgiContextModels(Collection<OsgiContextModel> osgiContextModels) {
            this.list.addAll(osgiContextModels);
            return this;
        }

        public Builder withRegisteringBundle(Bundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public Builder withServiceRankAndId(int rank, long id) {
            this.rank = rank;
            this.serviceId = id;
            return this;
        }

        public Builder isPreprocessor(boolean preprocessor) {
            this.preprocessor = preprocessor;
            return this;
        }

        public FilterModel build() {
            FilterModel model = new FilterModel(this.urlPatterns, this.servletNames, this.regexPatterns, this.dispatcherTypes, this.filterName, this.initParams, this.asyncSupported, this.filter, this.filterClass, this.reference, this.supplier, this.bundle);
            this.list.forEach(model::addContextModel);
            model.setServiceRank(this.rank);
            model.setServiceId(this.serviceId);
            model.setPreprocessor(this.preprocessor);
            return model;
        }
    }
}

