/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.events;

import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WebElementEvent {
    private final boolean replay;
    private final State type;
    private final Bundle bundle;
    private final long bundleId;
    private final String bundleName;
    private final String bundleVersion;
    private final long timestamp;
    private final WebElementEventData data;
    private final Exception exception;

    public WebElementEvent(WebElementEvent event, boolean replay) {
        this.type = event.getType();
        this.bundle = event.getBundle();
        this.bundleId = event.getBundleId();
        this.bundleName = event.getBundleName();
        this.bundleVersion = event.getBundleVersion();
        this.timestamp = event.getTimestamp();
        this.exception = event.exception;
        this.data = event.getData();
        this.replay = replay;
    }

    public WebElementEvent(State type, WebElementEventData data) {
        this(type, data, null);
    }

    public WebElementEvent(State type, WebElementEventData data, Exception exception) {
        this.type = type;
        this.bundle = data.getOriginBundle();
        this.bundleId = this.bundle.getBundleId();
        this.bundleName = this.bundle.getSymbolicName();
        this.bundleVersion = this.bundle.getVersion() == null ? Version.emptyVersion.toString() : this.bundle.getVersion().toString();
        this.timestamp = System.currentTimeMillis();
        this.data = data;
        this.exception = exception;
        this.replay = false;
    }

    public String toString() {
        return String.format("%s (%s/%s): %s%s", new Object[]{this.type, this.bundleName, this.bundleVersion, this.data.toString(), this.exception == null ? "" : " " + this.exception.getMessage()});
    }

    public boolean isReplay() {
        return this.replay;
    }

    public State getType() {
        return this.type;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public WebElementEventData getData() {
        return this.data;
    }

    public static enum State {
        DEPLOYING,
        DEPLOYED,
        UNDEPLOYING,
        UNDEPLOYED,
        FAILED,
        WAITING;

    }
}

