//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayDelete.json
func ExampleApplicationGatewaysClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginDelete(ctx, "rg1", "appgw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayGet.json
func ExampleApplicationGatewaysClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().Get(ctx, "rg1", "appgw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGateway = armnetwork.ApplicationGateway{
	// 	Name: to.Ptr("appgw"),
	// 	Type: to.Ptr("Microsoft.Network/applicationGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw"),
	// 	Location: to.Ptr("southcentralus"),
	// 	Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
	// 		AuthenticationCertificates: []*armnetwork.ApplicationGatewayAuthenticationCertificate{
	// 		},
	// 		BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 				Name: to.Ptr("appgwpool"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
	// 					BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
	// 				Name: to.Ptr("appgwpool1"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
	// 					BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
	// 						{
	// 						},
	// 						{
	// 					}},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 				Name: to.Ptr("appgwbhs"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
	// 					CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequestTimeout: to.Ptr[int32](30),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 				Name: to.Ptr("appgwfip"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
	// 					PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicIPAddress: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"),
	// 					},
	// 				},
	// 		}},
	// 		FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
	// 				Name: to.Ptr("appgwfp"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
	// 					Port: to.Ptr[int32](443),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
	// 				Name: to.Ptr("appgwfp80"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/gatewayIPConfigurations/appgwipc"),
	// 				Name: to.Ptr("appgwipc"),
	// 				Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					Subnet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
	// 					},
	// 				},
	// 		}},
	// 		GlobalConfiguration: &armnetwork.ApplicationGatewayGlobalConfiguration{
	// 			EnableRequestBuffering: to.Ptr(true),
	// 			EnableResponseBuffering: to.Ptr(true),
	// 		},
	// 		HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
	// 				Name: to.Ptr("appgwhl"),
	// 				Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
	// 					FrontendIPConfiguration: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 					},
	// 					FrontendPort: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequireServerNameIndication: to.Ptr(false),
	// 					SSLCertificate: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
	// 					},
	// 					SSLProfile: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
	// 					},
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTPS),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
	// 				Name: to.Ptr("appgwhttplistener"),
	// 				Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
	// 					FrontendIPConfiguration: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 					},
	// 					FrontendPort: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		LoadDistributionPolicies: []*armnetwork.ApplicationGatewayLoadDistributionPolicy{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
	// 				Name: to.Ptr("ldp1"),
	// 				Properties: &armnetwork.ApplicationGatewayLoadDistributionPolicyPropertiesFormat{
	// 					LoadDistributionAlgorithm: to.Ptr(armnetwork.ApplicationGatewayLoadDistributionAlgorithmRoundRobin),
	// 					LoadDistributionTargets: []*armnetwork.ApplicationGatewayLoadDistributionTarget{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
	// 							Name: to.Ptr("ld11"),
	// 							Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
	// 								BackendAddressPool: &armnetwork.SubResource{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 								},
	// 								WeightPerServer: to.Ptr[int32](40),
	// 							},
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
	// 							Name: to.Ptr("ld11"),
	// 							Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
	// 								BackendAddressPool: &armnetwork.SubResource{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
	// 								},
	// 								WeightPerServer: to.Ptr[int32](60),
	// 							},
	// 					}},
	// 				},
	// 		}},
	// 		OperationalState: to.Ptr(armnetwork.ApplicationGatewayOperationalStateRunning),
	// 		PrivateEndpointConnections: []*armnetwork.ApplicationGatewayPrivateEndpointConnection{
	// 		},
	// 		PrivateLinkConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1"),
	// 				Name: to.Ptr("privateLink1"),
	// 				Properties: &armnetwork.ApplicationGatewayPrivateLinkConfigurationProperties{
	// 					IPConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkIPConfiguration{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig1"),
	// 							Name: to.Ptr("natNicIpconfig1"),
	// 							Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
	// 								Primary: to.Ptr(true),
	// 								PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 								Subnet: &armnetwork.SubResource{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
	// 								},
	// 							},
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig2"),
	// 							Name: to.Ptr("natNicIpconfig2"),
	// 							Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
	// 								PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 								Subnet: &armnetwork.SubResource{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
	// 								},
	// 							},
	// 					}},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		Probes: []*armnetwork.ApplicationGatewayProbe{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwrule"),
	// 				Name: to.Ptr("appgwrule"),
	// 				Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
	// 					BackendAddressPool: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 					},
	// 					BackendHTTPSettings: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 					},
	// 					HTTPListener: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
	// 					},
	// 					LoadDistributionPolicy: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
	// 					},
	// 					Priority: to.Ptr[int32](10),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RewriteRuleSet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 					},
	// 					RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwPathBasedRule"),
	// 				Name: to.Ptr("appgwPathBasedRule"),
	// 				Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
	// 					HTTPListener: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
	// 					},
	// 					Priority: to.Ptr[int32](20),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypePathBasedRouting),
	// 					URLPathMap: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
	// 					},
	// 				},
	// 		}},
	// 		RewriteRuleSets: []*armnetwork.ApplicationGatewayRewriteRuleSet{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 				Name: to.Ptr("rewriteRuleSet1"),
	// 				Properties: &armnetwork.ApplicationGatewayRewriteRuleSetPropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RewriteRules: []*armnetwork.ApplicationGatewayRewriteRule{
	// 						{
	// 							Name: to.Ptr("Set X-Forwarded-For"),
	// 							ActionSet: &armnetwork.ApplicationGatewayRewriteRuleActionSet{
	// 								RequestHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
	// 									{
	// 										HeaderName: to.Ptr("X-Forwarded-For"),
	// 										HeaderValue: to.Ptr("{var_remote-addr}"),
	// 								}},
	// 								ResponseHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
	// 									{
	// 										HeaderName: to.Ptr("Strict-Transport-Security"),
	// 										HeaderValue: to.Ptr("max-age=31536000"),
	// 								}},
	// 								URLConfiguration: &armnetwork.ApplicationGatewayURLConfiguration{
	// 									ModifiedPath: to.Ptr("/abc"),
	// 									ModifiedQueryString: to.Ptr("x=y&a=b"),
	// 									Reroute: to.Ptr(false),
	// 								},
	// 							},
	// 							Conditions: []*armnetwork.ApplicationGatewayRewriteRuleCondition{
	// 								{
	// 									IgnoreCase: to.Ptr(true),
	// 									Negate: to.Ptr(false),
	// 									Pattern: to.Ptr("^Bearer"),
	// 									Variable: to.Ptr("http_req_Authorization"),
	// 							}},
	// 							RuleSequence: to.Ptr[int32](102),
	// 					}},
	// 				},
	// 		}},
	// 		SKU: &armnetwork.ApplicationGatewaySKU{
	// 			Name: to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardMedium),
	// 			Capacity: to.Ptr[int32](3),
	// 			Tier: to.Ptr(armnetwork.ApplicationGatewayTierStandard),
	// 		},
	// 		SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
	// 				Name: to.Ptr("sslcert"),
	// 				Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicCertData: to.Ptr("*****"),
	// 				},
	// 		}},
	// 		SSLProfiles: []*armnetwork.ApplicationGatewaySSLProfile{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
	// 				Name: to.Ptr("sslProfile1"),
	// 				Properties: &armnetwork.ApplicationGatewaySSLProfilePropertiesFormat{
	// 					ClientAuthConfiguration: &armnetwork.ApplicationGatewayClientAuthConfiguration{
	// 						VerifyClientCertIssuerDN: to.Ptr(true),
	// 						VerifyClientRevocation: to.Ptr(armnetwork.ApplicationGatewayClientRevocationOptionsOCSP),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SSLPolicy: &armnetwork.ApplicationGatewaySSLPolicy{
	// 						CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
	// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256)},
	// 							MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
	// 							PolicyType: to.Ptr(armnetwork.ApplicationGatewaySSLPolicyTypeCustom),
	// 						},
	// 						TrustedClientCertificates: []*armnetwork.SubResource{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
	// 						}},
	// 					},
	// 			}},
	// 			TrustedClientCertificates: []*armnetwork.ApplicationGatewayTrustedClientCertificate{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
	// 					Name: to.Ptr("clientcert"),
	// 					Properties: &armnetwork.ApplicationGatewayTrustedClientCertificatePropertiesFormat{
	// 						ClientCertIssuerDN: to.Ptr("CN=User1, OU=Eng, O=Company Ltd, L=D4, S=Arizona, C=US"),
	// 						Data: to.Ptr("****"),
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						ValidatedCertData: to.Ptr("****"),
	// 					},
	// 			}},
	// 			URLPathMaps: []*armnetwork.ApplicationGatewayURLPathMap{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
	// 					Name: to.Ptr("pathMap1"),
	// 					Properties: &armnetwork.ApplicationGatewayURLPathMapPropertiesFormat{
	// 						DefaultBackendAddressPool: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 						},
	// 						DefaultBackendHTTPSettings: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 						},
	// 						DefaultLoadDistributionPolicy: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
	// 						},
	// 						DefaultRewriteRuleSet: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 						},
	// 						PathRules: []*armnetwork.ApplicationGatewayPathRule{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1/pathRules/apiPaths"),
	// 								Name: to.Ptr("apiPaths"),
	// 								Properties: &armnetwork.ApplicationGatewayPathRulePropertiesFormat{
	// 									BackendAddressPool: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 									},
	// 									BackendHTTPSettings: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 									},
	// 									LoadDistributionPolicy: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
	// 									},
	// 									Paths: []*string{
	// 										to.Ptr("/api"),
	// 										to.Ptr("/v1/api")},
	// 										ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 										RewriteRuleSet: &armnetwork.SubResource{
	// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 										},
	// 									},
	// 							}},
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						},
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayCreate.json
func ExampleApplicationGatewaysClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginCreateOrUpdate(ctx, "rg1", "appgw", armnetwork.ApplicationGateway{
		Location: to.Ptr("eastus"),
		Identity: &armnetwork.ManagedServiceIdentity{
			Type: to.Ptr(armnetwork.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armnetwork.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
				"/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {},
			},
		},
		Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
			BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
				{
					Name: to.Ptr("appgwpool"),
					Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
						BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
							{
								IPAddress: to.Ptr("10.0.1.1"),
							},
							{
								IPAddress: to.Ptr("10.0.1.2"),
							}},
					},
				},
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
					Name: to.Ptr("appgwpool1"),
					Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
						BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
							{
								IPAddress: to.Ptr("10.0.0.1"),
							},
							{
								IPAddress: to.Ptr("10.0.0.2"),
							}},
					},
				}},
			BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
				{
					Name: to.Ptr("appgwbhs"),
					Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
						CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
						Port:                to.Ptr[int32](80),
						RequestTimeout:      to.Ptr[int32](30),
						Protocol:            to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
					},
				}},
			FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
				{
					Name: to.Ptr("appgwfip"),
					Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"),
						},
					},
				}},
			FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
				{
					Name: to.Ptr("appgwfp"),
					Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
						Port: to.Ptr[int32](443),
					},
				},
				{
					Name: to.Ptr("appgwfp80"),
					Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
						Port: to.Ptr[int32](80),
					},
				}},
			GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
				{
					Name: to.Ptr("appgwipc"),
					Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet/subnets/appgwsubnet"),
						},
					},
				}},
			GlobalConfiguration: &armnetwork.ApplicationGatewayGlobalConfiguration{
				EnableRequestBuffering:  to.Ptr(true),
				EnableResponseBuffering: to.Ptr(true),
			},
			HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
				{
					Name: to.Ptr("appgwhl"),
					Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
						FrontendIPConfiguration: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
						},
						FrontendPort: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
						},
						RequireServerNameIndication: to.Ptr(false),
						SSLCertificate: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
						},
						SSLProfile: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
						},
						Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTPS),
					},
				},
				{
					Name: to.Ptr("appgwhttplistener"),
					Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
						FrontendIPConfiguration: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
						},
						FrontendPort: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
						},
						Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
					},
				}},
			RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
				{
					Name: to.Ptr("appgwrule"),
					Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
						BackendAddressPool: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
						},
						BackendHTTPSettings: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
						},
						HTTPListener: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
						},
						Priority: to.Ptr[int32](10),
						RewriteRuleSet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
						},
						RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
					},
				}},
			RewriteRuleSets: []*armnetwork.ApplicationGatewayRewriteRuleSet{
				{
					Name: to.Ptr("rewriteRuleSet1"),
					Properties: &armnetwork.ApplicationGatewayRewriteRuleSetPropertiesFormat{
						RewriteRules: []*armnetwork.ApplicationGatewayRewriteRule{
							{
								Name: to.Ptr("Set X-Forwarded-For"),
								ActionSet: &armnetwork.ApplicationGatewayRewriteRuleActionSet{
									RequestHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
										{
											HeaderName:  to.Ptr("X-Forwarded-For"),
											HeaderValue: to.Ptr("{var_add_x_forwarded_for_proxy}"),
										}},
									ResponseHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
										{
											HeaderName:  to.Ptr("Strict-Transport-Security"),
											HeaderValue: to.Ptr("max-age=31536000"),
										}},
									URLConfiguration: &armnetwork.ApplicationGatewayURLConfiguration{
										ModifiedPath: to.Ptr("/abc"),
									},
								},
								Conditions: []*armnetwork.ApplicationGatewayRewriteRuleCondition{
									{
										IgnoreCase: to.Ptr(true),
										Negate:     to.Ptr(false),
										Pattern:    to.Ptr("^Bearer"),
										Variable:   to.Ptr("http_req_Authorization"),
									}},
								RuleSequence: to.Ptr[int32](102),
							}},
					},
				}},
			SKU: &armnetwork.ApplicationGatewaySKU{
				Name:     to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardV2),
				Capacity: to.Ptr[int32](3),
				Tier:     to.Ptr(armnetwork.ApplicationGatewayTierStandardV2),
			},
			SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
				{
					Name: to.Ptr("sslcert"),
					Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
						Data:     to.Ptr("****"),
						Password: to.Ptr("****"),
					},
				},
				{
					Name: to.Ptr("sslcert2"),
					Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
						KeyVaultSecretID: to.Ptr("https://kv/secret"),
					},
				}},
			SSLProfiles: []*armnetwork.ApplicationGatewaySSLProfile{
				{
					Name: to.Ptr("sslProfile1"),
					Properties: &armnetwork.ApplicationGatewaySSLProfilePropertiesFormat{
						ClientAuthConfiguration: &armnetwork.ApplicationGatewayClientAuthConfiguration{
							VerifyClientCertIssuerDN: to.Ptr(true),
						},
						SSLPolicy: &armnetwork.ApplicationGatewaySSLPolicy{
							CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
								to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256)},
							MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
							PolicyType:         to.Ptr(armnetwork.ApplicationGatewaySSLPolicyTypeCustom),
						},
						TrustedClientCertificates: []*armnetwork.SubResource{
							{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
							}},
					},
				}},
			TrustedClientCertificates: []*armnetwork.ApplicationGatewayTrustedClientCertificate{
				{
					Name: to.Ptr("clientcert"),
					Properties: &armnetwork.ApplicationGatewayTrustedClientCertificatePropertiesFormat{
						Data: to.Ptr("****"),
					},
				}},
			TrustedRootCertificates: []*armnetwork.ApplicationGatewayTrustedRootCertificate{
				{
					Name: to.Ptr("rootcert"),
					Properties: &armnetwork.ApplicationGatewayTrustedRootCertificatePropertiesFormat{
						Data: to.Ptr("****"),
					},
				},
				{
					Name: to.Ptr("rootcert1"),
					Properties: &armnetwork.ApplicationGatewayTrustedRootCertificatePropertiesFormat{
						KeyVaultSecretID: to.Ptr("https://kv/secret"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGateway = armnetwork.ApplicationGateway{
	// 	Name: to.Ptr("appgw"),
	// 	Type: to.Ptr("Microsoft.Network/applicationGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw"),
	// 	Location: to.Ptr("southcentralus"),
	// 	Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
	// 		AuthenticationCertificates: []*armnetwork.ApplicationGatewayAuthenticationCertificate{
	// 		},
	// 		BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 				Name: to.Ptr("appgwpool"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
	// 					BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
	// 						{
	// 							IPAddress: to.Ptr("10.0.1.1"),
	// 						},
	// 						{
	// 							IPAddress: to.Ptr("10.0.1.2"),
	// 					}},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
	// 				Name: to.Ptr("appgwpool1"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
	// 					BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
	// 						{
	// 							IPAddress: to.Ptr("10.0.0.1"),
	// 						},
	// 						{
	// 							IPAddress: to.Ptr("10.0.0.2"),
	// 					}},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 				Name: to.Ptr("appgwbhs"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
	// 					CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequestTimeout: to.Ptr[int32](30),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 				Name: to.Ptr("appgwfip"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
	// 					PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicIPAddress: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"),
	// 					},
	// 				},
	// 		}},
	// 		FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
	// 				Name: to.Ptr("appgwfp"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
	// 					Port: to.Ptr[int32](443),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
	// 				Name: to.Ptr("appgwfp80"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/gatewayIPConfigurations/appgwipc"),
	// 				Name: to.Ptr("appgwipc"),
	// 				Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					Subnet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
	// 					},
	// 				},
	// 		}},
	// 		GlobalConfiguration: &armnetwork.ApplicationGatewayGlobalConfiguration{
	// 			EnableRequestBuffering: to.Ptr(true),
	// 			EnableResponseBuffering: to.Ptr(true),
	// 		},
	// 		HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
	// 				Name: to.Ptr("appgwhl"),
	// 				Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
	// 					FrontendIPConfiguration: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 					},
	// 					FrontendPort: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequireServerNameIndication: to.Ptr(false),
	// 					SSLCertificate: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
	// 					},
	// 					SSLProfile: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
	// 					},
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTPS),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
	// 				Name: to.Ptr("appgwhttplistener"),
	// 				Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
	// 					FrontendIPConfiguration: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
	// 					},
	// 					FrontendPort: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		Listeners: []*armnetwork.ApplicationGatewayListener{
	// 		},
	// 		LoadDistributionPolicies: []*armnetwork.ApplicationGatewayLoadDistributionPolicy{
	// 		},
	// 		OperationalState: to.Ptr(armnetwork.ApplicationGatewayOperationalStateRunning),
	// 		PrivateEndpointConnections: []*armnetwork.ApplicationGatewayPrivateEndpointConnection{
	// 		},
	// 		Probes: []*armnetwork.ApplicationGatewayProbe{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		RedirectConfigurations: []*armnetwork.ApplicationGatewayRedirectConfiguration{
	// 		},
	// 		RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwrule"),
	// 				Name: to.Ptr("appgwrule"),
	// 				Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
	// 					BackendAddressPool: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
	// 					},
	// 					BackendHTTPSettings: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
	// 					},
	// 					HTTPListener: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RewriteRuleSet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 					},
	// 					RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
	// 				},
	// 		}},
	// 		RewriteRuleSets: []*armnetwork.ApplicationGatewayRewriteRuleSet{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
	// 				Name: to.Ptr("rewriteRuleSet1"),
	// 				Properties: &armnetwork.ApplicationGatewayRewriteRuleSetPropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RewriteRules: []*armnetwork.ApplicationGatewayRewriteRule{
	// 						{
	// 							Name: to.Ptr("Set X-Forwarded-For"),
	// 							ActionSet: &armnetwork.ApplicationGatewayRewriteRuleActionSet{
	// 								RequestHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
	// 									{
	// 										HeaderName: to.Ptr("X-Forwarded-For"),
	// 										HeaderValue: to.Ptr("{var_remote-addr}"),
	// 								}},
	// 								ResponseHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
	// 									{
	// 										HeaderName: to.Ptr("Strict-Transport-Security"),
	// 										HeaderValue: to.Ptr("max-age=31536000"),
	// 								}},
	// 								URLConfiguration: &armnetwork.ApplicationGatewayURLConfiguration{
	// 									ModifiedPath: to.Ptr("/abc"),
	// 									ModifiedQueryString: to.Ptr("x=y&a=b"),
	// 								},
	// 							},
	// 							Conditions: []*armnetwork.ApplicationGatewayRewriteRuleCondition{
	// 								{
	// 									IgnoreCase: to.Ptr(true),
	// 									Negate: to.Ptr(false),
	// 									Pattern: to.Ptr("^Bearer"),
	// 									Variable: to.Ptr("http_req_Authorization"),
	// 							}},
	// 							RuleSequence: to.Ptr[int32](102),
	// 					}},
	// 				},
	// 		}},
	// 		RoutingRules: []*armnetwork.ApplicationGatewayRoutingRule{
	// 		},
	// 		SKU: &armnetwork.ApplicationGatewaySKU{
	// 			Name: to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardMedium),
	// 			Capacity: to.Ptr[int32](3),
	// 			Tier: to.Ptr(armnetwork.ApplicationGatewayTierStandard),
	// 		},
	// 		SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
	// 				Name: to.Ptr("sslcert"),
	// 				Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicCertData: to.Ptr("*****"),
	// 				},
	// 		}},
	// 		SSLProfiles: []*armnetwork.ApplicationGatewaySSLProfile{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
	// 				Name: to.Ptr("sslProfile1"),
	// 				Properties: &armnetwork.ApplicationGatewaySSLProfilePropertiesFormat{
	// 					ClientAuthConfiguration: &armnetwork.ApplicationGatewayClientAuthConfiguration{
	// 						VerifyClientCertIssuerDN: to.Ptr(true),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SSLPolicy: &armnetwork.ApplicationGatewaySSLPolicy{
	// 						CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
	// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256)},
	// 							MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
	// 							PolicyType: to.Ptr(armnetwork.ApplicationGatewaySSLPolicyTypeCustom),
	// 						},
	// 						TrustedClientCertificates: []*armnetwork.SubResource{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
	// 						}},
	// 					},
	// 			}},
	// 			TrustedClientCertificates: []*armnetwork.ApplicationGatewayTrustedClientCertificate{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
	// 					Name: to.Ptr("clientcert"),
	// 					Properties: &armnetwork.ApplicationGatewayTrustedClientCertificatePropertiesFormat{
	// 						Data: to.Ptr("****"),
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					},
	// 			}},
	// 			URLPathMaps: []*armnetwork.ApplicationGatewayURLPathMap{
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayUpdateTags.json
func ExampleApplicationGatewaysClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().UpdateTags(ctx, "rg1", "AppGw", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGateway = armnetwork.ApplicationGateway{
	// 	Name: to.Ptr("AppGw"),
	// 	Type: to.Ptr("Microsoft.Network/applicationGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
	// 		AuthenticationCertificates: []*armnetwork.ApplicationGatewayAuthenticationCertificate{
	// 		},
	// 		BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/backendAddressPools/Pool01"),
	// 				Name: to.Ptr("Pool01"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
	// 					BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
	// 						{
	// 							IPAddress: to.Ptr("10.10.10.1"),
	// 						},
	// 						{
	// 							IPAddress: to.Ptr("10.10.10.2"),
	// 						},
	// 						{
	// 							IPAddress: to.Ptr("10.10.10.3"),
	// 					}},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/backendHttpSettingsCollection/PoolSetting01"),
	// 				Name: to.Ptr("PoolSetting01"),
	// 				Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
	// 					CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
	// 					PickHostNameFromBackendAddress: to.Ptr(false),
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequestTimeout: to.Ptr[int32](30),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/frontendIPConfigurations/FrontEndConfig01"),
	// 				Name: to.Ptr("FrontEndConfig01"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
	// 					PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicIPAddress: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/publicIp1"),
	// 					},
	// 				},
	// 		}},
	// 		FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/frontendPorts/FrontEndPort01"),
	// 				Name: to.Ptr("FrontEndPort01"),
	// 				Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
	// 					Port: to.Ptr[int32](80),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/gatewayIPConfigurations/GatewayIp01"),
	// 				Name: to.Ptr("GatewayIp01"),
	// 				Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					Subnet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet/subnets/subnet1"),
	// 					},
	// 				},
	// 		}},
	// 		HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/httpListeners/listener1"),
	// 				Name: to.Ptr("listener1"),
	// 				Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
	// 					FrontendIPConfiguration: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/frontendIPConfigurations/FrontEndConfig01"),
	// 					},
	// 					FrontendPort: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/frontendPorts/FrontEndPort01"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RequireServerNameIndication: to.Ptr(false),
	// 					Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	// 				},
	// 		}},
	// 		OperationalState: to.Ptr(armnetwork.ApplicationGatewayOperationalStateRunning),
	// 		Probes: []*armnetwork.ApplicationGatewayProbe{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		RedirectConfigurations: []*armnetwork.ApplicationGatewayRedirectConfiguration{
	// 		},
	// 		RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/requestRoutingRules/Rule01"),
	// 				Name: to.Ptr("Rule01"),
	// 				Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
	// 					BackendAddressPool: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/backendAddressPools/Pool01"),
	// 					},
	// 					BackendHTTPSettings: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/backendHttpSettingsCollection/PoolSetting01"),
	// 					},
	// 					HTTPListener: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/AppGw/httpListeners/listener1"),
	// 					},
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
	// 				},
	// 		}},
	// 		ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		SKU: &armnetwork.ApplicationGatewaySKU{
	// 			Name: to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardSmall),
	// 			Capacity: to.Ptr[int32](2),
	// 			Tier: to.Ptr(armnetwork.ApplicationGatewayTierStandard),
	// 		},
	// 		SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
	// 		},
	// 		URLPathMaps: []*armnetwork.ApplicationGatewayURLPathMap{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayList.json
func ExampleApplicationGatewaysClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationGatewaysClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationGatewayListResult = armnetwork.ApplicationGatewayListResult{
		// 	Value: []*armnetwork.ApplicationGateway{
		// 		{
		// 			Name: to.Ptr("appgw"),
		// 			Type: to.Ptr("Microsoft.Network/applicationGateways"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw"),
		// 			Location: to.Ptr("southcentralus"),
		// 			Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
		// 				AuthenticationCertificates: []*armnetwork.ApplicationGatewayAuthenticationCertificate{
		// 				},
		// 				BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 						Name: to.Ptr("appgwpool"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
		// 							BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
		// 						Name: to.Ptr("appgwpool1"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
		// 							BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
		// 								{
		// 								},
		// 								{
		// 							}},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 						Name: to.Ptr("appgwbhs"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
		// 							CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
		// 							Port: to.Ptr[int32](80),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RequestTimeout: to.Ptr[int32](30),
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
		// 						},
		// 				}},
		// 				FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 						Name: to.Ptr("appgwfip"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
		// 							PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							PublicIPAddress: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"),
		// 							},
		// 						},
		// 				}},
		// 				FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
		// 						Name: to.Ptr("appgwfp"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
		// 							Port: to.Ptr[int32](443),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
		// 						Name: to.Ptr("appgwfp80"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
		// 							Port: to.Ptr[int32](80),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/gatewayIPConfigurations/appgwipc"),
		// 						Name: to.Ptr("appgwipc"),
		// 						Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							Subnet: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 							},
		// 						},
		// 				}},
		// 				GlobalConfiguration: &armnetwork.ApplicationGatewayGlobalConfiguration{
		// 					EnableRequestBuffering: to.Ptr(true),
		// 					EnableResponseBuffering: to.Ptr(true),
		// 				},
		// 				HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
		// 						Name: to.Ptr("appgwhl"),
		// 						Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
		// 							FrontendIPConfiguration: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 							},
		// 							FrontendPort: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RequireServerNameIndication: to.Ptr(false),
		// 							SSLCertificate: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
		// 							},
		// 							SSLProfile: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
		// 							},
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTPS),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
		// 						Name: to.Ptr("appgwhttplistener"),
		// 						Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
		// 							FrontendIPConfiguration: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 							},
		// 							FrontendPort: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
		// 						},
		// 				}},
		// 				LoadDistributionPolicies: []*armnetwork.ApplicationGatewayLoadDistributionPolicy{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 						Name: to.Ptr("ldp1"),
		// 						Properties: &armnetwork.ApplicationGatewayLoadDistributionPolicyPropertiesFormat{
		// 							LoadDistributionAlgorithm: to.Ptr(armnetwork.ApplicationGatewayLoadDistributionAlgorithmRoundRobin),
		// 							LoadDistributionTargets: []*armnetwork.ApplicationGatewayLoadDistributionTarget{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
		// 									Name: to.Ptr("ld11"),
		// 									Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
		// 										BackendAddressPool: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 										},
		// 										WeightPerServer: to.Ptr[int32](40),
		// 									},
		// 								},
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
		// 									Name: to.Ptr("ld11"),
		// 									Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
		// 										BackendAddressPool: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
		// 										},
		// 										WeightPerServer: to.Ptr[int32](60),
		// 									},
		// 							}},
		// 						},
		// 				}},
		// 				OperationalState: to.Ptr(armnetwork.ApplicationGatewayOperationalStateRunning),
		// 				PrivateEndpointConnections: []*armnetwork.ApplicationGatewayPrivateEndpointConnection{
		// 				},
		// 				PrivateLinkConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1"),
		// 						Name: to.Ptr("privateLink1"),
		// 						Properties: &armnetwork.ApplicationGatewayPrivateLinkConfigurationProperties{
		// 							IPConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkIPConfiguration{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig1"),
		// 									Name: to.Ptr("natNicIpconfig1"),
		// 									Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
		// 										Primary: to.Ptr(true),
		// 										PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 										ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 										Subnet: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 										},
		// 									},
		// 								},
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig2"),
		// 									Name: to.Ptr("natNicIpconfig2"),
		// 									Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
		// 										PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 										ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 										Subnet: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 										},
		// 									},
		// 							}},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				Probes: []*armnetwork.ApplicationGatewayProbe{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwrule"),
		// 						Name: to.Ptr("appgwrule"),
		// 						Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
		// 							BackendAddressPool: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 							},
		// 							BackendHTTPSettings: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 							},
		// 							HTTPListener: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
		// 							},
		// 							LoadDistributionPolicy: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 							},
		// 							Priority: to.Ptr[int32](10),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RewriteRuleSet: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 							},
		// 							RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwPathBasedRule"),
		// 						Name: to.Ptr("appgwPathBasedRule"),
		// 						Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
		// 							HTTPListener: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
		// 							},
		// 							Priority: to.Ptr[int32](20),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypePathBasedRouting),
		// 							URLPathMap: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
		// 							},
		// 						},
		// 				}},
		// 				RewriteRuleSets: []*armnetwork.ApplicationGatewayRewriteRuleSet{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 						Name: to.Ptr("rewriteRuleSet1"),
		// 						Properties: &armnetwork.ApplicationGatewayRewriteRuleSetPropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RewriteRules: []*armnetwork.ApplicationGatewayRewriteRule{
		// 								{
		// 									Name: to.Ptr("Set X-Forwarded-For"),
		// 									ActionSet: &armnetwork.ApplicationGatewayRewriteRuleActionSet{
		// 										RequestHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
		// 											{
		// 												HeaderName: to.Ptr("X-Forwarded-For"),
		// 												HeaderValue: to.Ptr("{var_remote-addr}"),
		// 										}},
		// 										ResponseHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
		// 											{
		// 												HeaderName: to.Ptr("Strict-Transport-Security"),
		// 												HeaderValue: to.Ptr("max-age=31536000"),
		// 										}},
		// 										URLConfiguration: &armnetwork.ApplicationGatewayURLConfiguration{
		// 											ModifiedPath: to.Ptr("/abc"),
		// 											ModifiedQueryString: to.Ptr("x=y&a=b"),
		// 											Reroute: to.Ptr(false),
		// 										},
		// 									},
		// 									Conditions: []*armnetwork.ApplicationGatewayRewriteRuleCondition{
		// 										{
		// 											IgnoreCase: to.Ptr(true),
		// 											Negate: to.Ptr(false),
		// 											Pattern: to.Ptr("^Bearer"),
		// 											Variable: to.Ptr("http_req_Authorization"),
		// 									}},
		// 									RuleSequence: to.Ptr[int32](102),
		// 							}},
		// 						},
		// 				}},
		// 				SKU: &armnetwork.ApplicationGatewaySKU{
		// 					Name: to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardMedium),
		// 					Capacity: to.Ptr[int32](3),
		// 					Tier: to.Ptr(armnetwork.ApplicationGatewayTierStandard),
		// 				},
		// 				SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
		// 						Name: to.Ptr("sslcert"),
		// 						Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							PublicCertData: to.Ptr("*****"),
		// 						},
		// 				}},
		// 				SSLProfiles: []*armnetwork.ApplicationGatewaySSLProfile{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
		// 						Name: to.Ptr("sslProfile1"),
		// 						Properties: &armnetwork.ApplicationGatewaySSLProfilePropertiesFormat{
		// 							ClientAuthConfiguration: &armnetwork.ApplicationGatewayClientAuthConfiguration{
		// 								VerifyClientCertIssuerDN: to.Ptr(true),
		// 								VerifyClientRevocation: to.Ptr(armnetwork.ApplicationGatewayClientRevocationOptionsOCSP),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SSLPolicy: &armnetwork.ApplicationGatewaySSLPolicy{
		// 								CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
		// 									to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256)},
		// 									MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
		// 									PolicyType: to.Ptr(armnetwork.ApplicationGatewaySSLPolicyTypeCustom),
		// 								},
		// 								TrustedClientCertificates: []*armnetwork.SubResource{
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
		// 								}},
		// 							},
		// 					}},
		// 					TrustedClientCertificates: []*armnetwork.ApplicationGatewayTrustedClientCertificate{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
		// 							Name: to.Ptr("clientcert"),
		// 							Properties: &armnetwork.ApplicationGatewayTrustedClientCertificatePropertiesFormat{
		// 								ClientCertIssuerDN: to.Ptr("CN=User1, OU=Eng, O=Company Ltd, L=D4, S=Arizona, C=US"),
		// 								Data: to.Ptr("****"),
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								ValidatedCertData: to.Ptr("****"),
		// 							},
		// 					}},
		// 					URLPathMaps: []*armnetwork.ApplicationGatewayURLPathMap{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
		// 							Name: to.Ptr("pathMap1"),
		// 							Properties: &armnetwork.ApplicationGatewayURLPathMapPropertiesFormat{
		// 								DefaultBackendAddressPool: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 								},
		// 								DefaultBackendHTTPSettings: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 								},
		// 								DefaultLoadDistributionPolicy: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 								},
		// 								DefaultRewriteRuleSet: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 								},
		// 								PathRules: []*armnetwork.ApplicationGatewayPathRule{
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1/pathRules/apiPaths"),
		// 										Name: to.Ptr("apiPaths"),
		// 										Properties: &armnetwork.ApplicationGatewayPathRulePropertiesFormat{
		// 											BackendAddressPool: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 											},
		// 											BackendHTTPSettings: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 											},
		// 											LoadDistributionPolicy: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 											},
		// 											Paths: []*string{
		// 												to.Ptr("/api"),
		// 												to.Ptr("/v1/api")},
		// 												ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 												RewriteRuleSet: &armnetwork.SubResource{
		// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 												},
		// 											},
		// 									}},
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 						}},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayListAll.json
func ExampleApplicationGatewaysClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationGatewaysClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationGatewayListResult = armnetwork.ApplicationGatewayListResult{
		// 	Value: []*armnetwork.ApplicationGateway{
		// 		{
		// 			Name: to.Ptr("appgw"),
		// 			Type: to.Ptr("Microsoft.Network/applicationGateways"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw"),
		// 			Location: to.Ptr("southcentralus"),
		// 			Properties: &armnetwork.ApplicationGatewayPropertiesFormat{
		// 				AuthenticationCertificates: []*armnetwork.ApplicationGatewayAuthenticationCertificate{
		// 				},
		// 				BackendAddressPools: []*armnetwork.ApplicationGatewayBackendAddressPool{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 						Name: to.Ptr("appgwpool"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
		// 							BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
		// 						Name: to.Ptr("appgwpool1"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendAddressPoolPropertiesFormat{
		// 							BackendAddresses: []*armnetwork.ApplicationGatewayBackendAddress{
		// 								{
		// 								},
		// 								{
		// 							}},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHTTPSettings{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 						Name: to.Ptr("appgwbhs"),
		// 						Properties: &armnetwork.ApplicationGatewayBackendHTTPSettingsPropertiesFormat{
		// 							CookieBasedAffinity: to.Ptr(armnetwork.ApplicationGatewayCookieBasedAffinityDisabled),
		// 							Port: to.Ptr[int32](80),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RequestTimeout: to.Ptr[int32](30),
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
		// 						},
		// 				}},
		// 				FrontendIPConfigurations: []*armnetwork.ApplicationGatewayFrontendIPConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 						Name: to.Ptr("appgwfip"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendIPConfigurationPropertiesFormat{
		// 							PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							PublicIPAddress: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/appgwpip"),
		// 							},
		// 						},
		// 				}},
		// 				FrontendPorts: []*armnetwork.ApplicationGatewayFrontendPort{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
		// 						Name: to.Ptr("appgwfp"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
		// 							Port: to.Ptr[int32](443),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
		// 						Name: to.Ptr("appgwfp80"),
		// 						Properties: &armnetwork.ApplicationGatewayFrontendPortPropertiesFormat{
		// 							Port: to.Ptr[int32](80),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				GatewayIPConfigurations: []*armnetwork.ApplicationGatewayIPConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/gatewayIPConfigurations/appgwipc"),
		// 						Name: to.Ptr("appgwipc"),
		// 						Properties: &armnetwork.ApplicationGatewayIPConfigurationPropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							Subnet: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 							},
		// 						},
		// 				}},
		// 				GlobalConfiguration: &armnetwork.ApplicationGatewayGlobalConfiguration{
		// 					EnableRequestBuffering: to.Ptr(true),
		// 					EnableResponseBuffering: to.Ptr(true),
		// 				},
		// 				HTTPListeners: []*armnetwork.ApplicationGatewayHTTPListener{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
		// 						Name: to.Ptr("appgwhl"),
		// 						Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
		// 							FrontendIPConfiguration: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 							},
		// 							FrontendPort: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp"),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RequireServerNameIndication: to.Ptr(false),
		// 							SSLCertificate: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
		// 							},
		// 							SSLProfile: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
		// 							},
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTPS),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
		// 						Name: to.Ptr("appgwhttplistener"),
		// 						Properties: &armnetwork.ApplicationGatewayHTTPListenerPropertiesFormat{
		// 							FrontendIPConfiguration: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendIPConfigurations/appgwfip"),
		// 							},
		// 							FrontendPort: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/frontendPorts/appgwfp80"),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							Protocol: to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
		// 						},
		// 				}},
		// 				LoadDistributionPolicies: []*armnetwork.ApplicationGatewayLoadDistributionPolicy{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 						Name: to.Ptr("ldp1"),
		// 						Properties: &armnetwork.ApplicationGatewayLoadDistributionPolicyPropertiesFormat{
		// 							LoadDistributionAlgorithm: to.Ptr(armnetwork.ApplicationGatewayLoadDistributionAlgorithmRoundRobin),
		// 							LoadDistributionTargets: []*armnetwork.ApplicationGatewayLoadDistributionTarget{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
		// 									Name: to.Ptr("ld11"),
		// 									Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
		// 										BackendAddressPool: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 										},
		// 										WeightPerServer: to.Ptr[int32](40),
		// 									},
		// 								},
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1/loadDistributionTargets/ldt1"),
		// 									Name: to.Ptr("ld11"),
		// 									Properties: &armnetwork.ApplicationGatewayLoadDistributionTargetPropertiesFormat{
		// 										BackendAddressPool: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool1"),
		// 										},
		// 										WeightPerServer: to.Ptr[int32](60),
		// 									},
		// 							}},
		// 						},
		// 				}},
		// 				OperationalState: to.Ptr(armnetwork.ApplicationGatewayOperationalStateRunning),
		// 				PrivateEndpointConnections: []*armnetwork.ApplicationGatewayPrivateEndpointConnection{
		// 				},
		// 				PrivateLinkConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkConfiguration{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1"),
		// 						Name: to.Ptr("privateLink1"),
		// 						Properties: &armnetwork.ApplicationGatewayPrivateLinkConfigurationProperties{
		// 							IPConfigurations: []*armnetwork.ApplicationGatewayPrivateLinkIPConfiguration{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig1"),
		// 									Name: to.Ptr("natNicIpconfig1"),
		// 									Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
		// 										Primary: to.Ptr(true),
		// 										PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 										ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 										Subnet: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 										},
		// 									},
		// 								},
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/privateLinkConfigurations/privateLink1/privateLinkConfigurations/privateLink1/ipConfigurations/natNicIpconfig2"),
		// 									Name: to.Ptr("natNicIpconfig2"),
		// 									Properties: &armnetwork.ApplicationGatewayPrivateLinkIPConfigurationProperties{
		// 										PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 										ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 										Subnet: &armnetwork.SubResource{
		// 											ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1/subnets/appgwsubnet"),
		// 										},
		// 									},
		// 							}},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				Probes: []*armnetwork.ApplicationGatewayProbe{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				RequestRoutingRules: []*armnetwork.ApplicationGatewayRequestRoutingRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwrule"),
		// 						Name: to.Ptr("appgwrule"),
		// 						Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
		// 							BackendAddressPool: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 							},
		// 							BackendHTTPSettings: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 							},
		// 							HTTPListener: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhl"),
		// 							},
		// 							LoadDistributionPolicy: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 							},
		// 							Priority: to.Ptr[int32](10),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RewriteRuleSet: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 							},
		// 							RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypeBasic),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/requestRoutingRules/appgwPathBasedRule"),
		// 						Name: to.Ptr("appgwPathBasedRule"),
		// 						Properties: &armnetwork.ApplicationGatewayRequestRoutingRulePropertiesFormat{
		// 							HTTPListener: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/httpListeners/appgwhttplistener"),
		// 							},
		// 							Priority: to.Ptr[int32](20),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RuleType: to.Ptr(armnetwork.ApplicationGatewayRequestRoutingRuleTypePathBasedRouting),
		// 							URLPathMap: &armnetwork.SubResource{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
		// 							},
		// 						},
		// 				}},
		// 				RewriteRuleSets: []*armnetwork.ApplicationGatewayRewriteRuleSet{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 						Name: to.Ptr("rewriteRuleSet1"),
		// 						Properties: &armnetwork.ApplicationGatewayRewriteRuleSetPropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							RewriteRules: []*armnetwork.ApplicationGatewayRewriteRule{
		// 								{
		// 									Name: to.Ptr("Set X-Forwarded-For"),
		// 									ActionSet: &armnetwork.ApplicationGatewayRewriteRuleActionSet{
		// 										RequestHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
		// 											{
		// 												HeaderName: to.Ptr("X-Forwarded-For"),
		// 												HeaderValue: to.Ptr("{var_remote-addr}"),
		// 										}},
		// 										ResponseHeaderConfigurations: []*armnetwork.ApplicationGatewayHeaderConfiguration{
		// 											{
		// 												HeaderName: to.Ptr("Strict-Transport-Security"),
		// 												HeaderValue: to.Ptr("max-age=31536000"),
		// 										}},
		// 										URLConfiguration: &armnetwork.ApplicationGatewayURLConfiguration{
		// 											ModifiedPath: to.Ptr("/abc"),
		// 											ModifiedQueryString: to.Ptr("x=y&a=b"),
		// 											Reroute: to.Ptr(false),
		// 										},
		// 									},
		// 									Conditions: []*armnetwork.ApplicationGatewayRewriteRuleCondition{
		// 										{
		// 											IgnoreCase: to.Ptr(true),
		// 											Negate: to.Ptr(false),
		// 											Pattern: to.Ptr("^Bearer"),
		// 											Variable: to.Ptr("http_req_Authorization"),
		// 									}},
		// 									RuleSequence: to.Ptr[int32](102),
		// 							}},
		// 						},
		// 				}},
		// 				SKU: &armnetwork.ApplicationGatewaySKU{
		// 					Name: to.Ptr(armnetwork.ApplicationGatewaySKUNameStandardMedium),
		// 					Capacity: to.Ptr[int32](3),
		// 					Tier: to.Ptr(armnetwork.ApplicationGatewayTierStandard),
		// 				},
		// 				SSLCertificates: []*armnetwork.ApplicationGatewaySSLCertificate{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslCertificates/sslcert"),
		// 						Name: to.Ptr("sslcert"),
		// 						Properties: &armnetwork.ApplicationGatewaySSLCertificatePropertiesFormat{
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							PublicCertData: to.Ptr("*****"),
		// 						},
		// 				}},
		// 				SSLProfiles: []*armnetwork.ApplicationGatewaySSLProfile{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/sslProfiles/sslProfile1"),
		// 						Name: to.Ptr("sslProfile1"),
		// 						Properties: &armnetwork.ApplicationGatewaySSLProfilePropertiesFormat{
		// 							ClientAuthConfiguration: &armnetwork.ApplicationGatewayClientAuthConfiguration{
		// 								VerifyClientCertIssuerDN: to.Ptr(true),
		// 								VerifyClientRevocation: to.Ptr(armnetwork.ApplicationGatewayClientRevocationOptionsOCSP),
		// 							},
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SSLPolicy: &armnetwork.ApplicationGatewaySSLPolicy{
		// 								CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
		// 									to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256)},
		// 									MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
		// 									PolicyType: to.Ptr(armnetwork.ApplicationGatewaySSLPolicyTypeCustom),
		// 								},
		// 								TrustedClientCertificates: []*armnetwork.SubResource{
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
		// 								}},
		// 							},
		// 					}},
		// 					TrustedClientCertificates: []*armnetwork.ApplicationGatewayTrustedClientCertificate{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/trustedClientCertificates/clientcert"),
		// 							Name: to.Ptr("clientcert"),
		// 							Properties: &armnetwork.ApplicationGatewayTrustedClientCertificatePropertiesFormat{
		// 								ClientCertIssuerDN: to.Ptr("CN=User1, OU=Eng, O=Company Ltd, L=D4, S=Arizona, C=US"),
		// 								Data: to.Ptr("****"),
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								ValidatedCertData: to.Ptr("****"),
		// 							},
		// 					}},
		// 					URLPathMaps: []*armnetwork.ApplicationGatewayURLPathMap{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1"),
		// 							Name: to.Ptr("pathMap1"),
		// 							Properties: &armnetwork.ApplicationGatewayURLPathMapPropertiesFormat{
		// 								DefaultBackendAddressPool: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 								},
		// 								DefaultBackendHTTPSettings: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 								},
		// 								DefaultLoadDistributionPolicy: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 								},
		// 								DefaultRewriteRuleSet: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 								},
		// 								PathRules: []*armnetwork.ApplicationGatewayPathRule{
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/urlPathMaps/pathMap1/pathRules/apiPaths"),
		// 										Name: to.Ptr("apiPaths"),
		// 										Properties: &armnetwork.ApplicationGatewayPathRulePropertiesFormat{
		// 											BackendAddressPool: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendAddressPools/appgwpool"),
		// 											},
		// 											BackendHTTPSettings: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/appgwbhs"),
		// 											},
		// 											LoadDistributionPolicy: &armnetwork.SubResource{
		// 												ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/loadDistributionPolicies/ldp1"),
		// 											},
		// 											Paths: []*string{
		// 												to.Ptr("/api"),
		// 												to.Ptr("/v1/api")},
		// 												ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 												RewriteRuleSet: &armnetwork.SubResource{
		// 													ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/rewriteRuleSets/rewriteRuleSet1"),
		// 												},
		// 											},
		// 									}},
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 						}},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayStart.json
func ExampleApplicationGatewaysClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginStart(ctx, "rg1", "appgw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayStop.json
func ExampleApplicationGatewaysClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginStop(ctx, "rg1", "appgw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayBackendHealthGet.json
func ExampleApplicationGatewaysClient_BeginBackendHealth() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginBackendHealth(ctx, "appgw", "appgw", &armnetwork.ApplicationGatewaysClientBeginBackendHealthOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGatewayBackendHealth = armnetwork.ApplicationGatewayBackendHealth{
	// 	BackendAddressPools: []*armnetwork.ApplicationGatewayBackendHealthPool{
	// 		{
	// 			BackendAddressPool: &armnetwork.ApplicationGatewayBackendAddressPool{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendaddressPools/MFAnalyticsPool"),
	// 			},
	// 			BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHealthHTTPSettings{
	// 				{
	// 					BackendHTTPSettings: &armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/MFPoolSettings"),
	// 					},
	// 					Servers: []*armnetwork.ApplicationGatewayBackendHealthServer{
	// 						{
	// 							Address: to.Ptr("10.220.1.8"),
	// 							Health: to.Ptr(armnetwork.ApplicationGatewayBackendHealthServerHealthUp),
	// 					}},
	// 			}},
	// 		},
	// 		{
	// 			BackendAddressPool: &armnetwork.ApplicationGatewayBackendAddressPool{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendaddressPools/MFPool"),
	// 			},
	// 			BackendHTTPSettingsCollection: []*armnetwork.ApplicationGatewayBackendHealthHTTPSettings{
	// 				{
	// 					BackendHTTPSettings: &armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/MFPoolSettings"),
	// 					},
	// 					Servers: []*armnetwork.ApplicationGatewayBackendHealthServer{
	// 						{
	// 							Address: to.Ptr("10.220.1.4"),
	// 							Health: to.Ptr(armnetwork.ApplicationGatewayBackendHealthServerHealthUp),
	// 						},
	// 						{
	// 							Address: to.Ptr("10.220.1.5"),
	// 							Health: to.Ptr(armnetwork.ApplicationGatewayBackendHealthServerHealthUp),
	// 					}},
	// 			}},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayBackendHealthTest.json
func ExampleApplicationGatewaysClient_BeginBackendHealthOnDemand() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationGatewaysClient().BeginBackendHealthOnDemand(ctx, "rg1", "appgw", armnetwork.ApplicationGatewayOnDemandProbe{
		Path: to.Ptr("/"),
		BackendAddressPool: &armnetwork.SubResource{
			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendaddressPools/MFAnalyticsPool"),
		},
		BackendHTTPSettings: &armnetwork.SubResource{
			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/MFPoolSettings"),
		},
		PickHostNameFromBackendHTTPSettings: to.Ptr(true),
		Timeout:                             to.Ptr[int32](30),
		Protocol:                            to.Ptr(armnetwork.ApplicationGatewayProtocolHTTP),
	}, &armnetwork.ApplicationGatewaysClientBeginBackendHealthOnDemandOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGatewayBackendHealthOnDemand = armnetwork.ApplicationGatewayBackendHealthOnDemand{
	// 	BackendAddressPool: &armnetwork.ApplicationGatewayBackendAddressPool{
	// 		ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendaddressPools/MFAnalyticsPool"),
	// 	},
	// 	BackendHealthHTTPSettings: &armnetwork.ApplicationGatewayBackendHealthHTTPSettings{
	// 		BackendHTTPSettings: &armnetwork.ApplicationGatewayBackendHTTPSettings{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/applicationGateways/appgw/backendHttpSettingsCollection/MFPoolSettings"),
	// 		},
	// 		Servers: []*armnetwork.ApplicationGatewayBackendHealthServer{
	// 			{
	// 				Address: to.Ptr("10.220.1.4"),
	// 				Health: to.Ptr(armnetwork.ApplicationGatewayBackendHealthServerHealthUp),
	// 			},
	// 			{
	// 				Address: to.Ptr("10.220.1.5"),
	// 				Health: to.Ptr(armnetwork.ApplicationGatewayBackendHealthServerHealthUp),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableServerVariablesGet.json
func ExampleApplicationGatewaysClient_ListAvailableServerVariables() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().ListAvailableServerVariables(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StringArray = []*string{
	// 	to.Ptr("request_query")}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableRequestHeadersGet.json
func ExampleApplicationGatewaysClient_ListAvailableRequestHeaders() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().ListAvailableRequestHeaders(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StringArray = []*string{
	// 	to.Ptr("Accept-Charset")}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableResponseHeadersGet.json
func ExampleApplicationGatewaysClient_ListAvailableResponseHeaders() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().ListAvailableResponseHeaders(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StringArray = []*string{
	// 	to.Ptr("Access-Control-Allow-Origin")}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableWafRuleSetsGet.json
func ExampleApplicationGatewaysClient_ListAvailableWafRuleSets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().ListAvailableWafRuleSets(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGatewayAvailableWafRuleSetsResult = armnetwork.ApplicationGatewayAvailableWafRuleSetsResult{
	// 	Value: []*armnetwork.ApplicationGatewayFirewallRuleSet{
	// 		{
	// 			Name: to.Ptr("OWASP_3.0"),
	// 			Type: to.Ptr("Microsoft.Network/applicationGatewayAvailableWafRuleSets"),
	// 			ID: to.Ptr("/subscriptions//resourceGroups//providers/Microsoft.Network/applicationGatewayAvailableWafRuleSets/"),
	// 			Properties: &armnetwork.ApplicationGatewayFirewallRuleSetPropertiesFormat{
	// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				RuleGroups: []*armnetwork.ApplicationGatewayFirewallRuleGroup{
	// 					{
	// 						Description: to.Ptr(""),
	// 						RuleGroupName: to.Ptr("General"),
	// 						Rules: []*armnetwork.ApplicationGatewayFirewallRule{
	// 							{
	// 								Description: to.Ptr("Possible Multipart Unmatched Boundary."),
	// 								RuleID: to.Ptr[int32](200004),
	// 								RuleIDString: to.Ptr("200004"),
	// 						}},
	// 				}},
	// 				RuleSetType: to.Ptr("OWASP"),
	// 				RuleSetVersion: to.Ptr("3.0"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableSslOptionsGet.json
func ExampleApplicationGatewaysClient_ListAvailableSSLOptions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().ListAvailableSSLOptions(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGatewayAvailableSSLOptions = armnetwork.ApplicationGatewayAvailableSSLOptions{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Network/ApplicationGatewayAvailableSslOptions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default"),
	// 	Properties: &armnetwork.ApplicationGatewayAvailableSSLOptionsPropertiesFormat{
	// 		AvailableCipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITH3DESEDECBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA)},
	// 			AvailableProtocols: []*armnetwork.ApplicationGatewaySSLProtocol{
	// 				to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv10),
	// 				to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
	// 				to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv12)},
	// 				DefaultPolicy: to.Ptr(armnetwork.ApplicationGatewaySSLPolicyNameAppGwSSLPolicy20150501),
	// 				PredefinedPolicies: []*armnetwork.SubResource{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20150501"),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20170401"),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20170401S"),
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableSslOptionsPredefinedPoliciesGet.json
func ExampleApplicationGatewaysClient_NewListAvailableSSLPredefinedPoliciesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationGatewaysClient().NewListAvailableSSLPredefinedPoliciesPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationGatewayAvailableSSLPredefinedPolicies = armnetwork.ApplicationGatewayAvailableSSLPredefinedPolicies{
		// 	Value: []*armnetwork.ApplicationGatewaySSLPredefinedPolicy{
		// 		{
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20150501"),
		// 			Name: to.Ptr("AppGwSslPolicy20150501"),
		// 			Properties: &armnetwork.ApplicationGatewaySSLPredefinedPolicyPropertiesFormat{
		// 				CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256GCMSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128GCMSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256GCMSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128GCMSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256GCMSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128GCMSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA256),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITH3DESEDECBCSHA),
		// 					to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA)},
		// 					MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv10),
		// 				},
		// 			},
		// 			{
		// 				ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20170401"),
		// 				Name: to.Ptr("AppGwSslPolicy20170401"),
		// 				Properties: &armnetwork.ApplicationGatewaySSLPredefinedPolicyPropertiesFormat{
		// 					CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256GCMSHA384),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128GCMSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256GCMSHA384),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128GCMSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA256),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA),
		// 						to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA)},
		// 						MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv11),
		// 					},
		// 				},
		// 				{
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20170401S"),
		// 					Name: to.Ptr("AppGwSslPolicy20170401S"),
		// 					Properties: &armnetwork.ApplicationGatewaySSLPredefinedPolicyPropertiesFormat{
		// 						CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256GCMSHA384),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128GCMSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256GCMSHA384),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128GCMSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA256),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA),
		// 							to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA)},
		// 							MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv12),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ApplicationGatewayAvailableSslOptionsPredefinedPolicyGet.json
func ExampleApplicationGatewaysClient_GetSSLPredefinedPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGatewaysClient().GetSSLPredefinedPolicy(ctx, "AppGwSslPolicy20150501", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGatewaySSLPredefinedPolicy = armnetwork.ApplicationGatewaySSLPredefinedPolicy{
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups//providers/Microsoft.Network/ApplicationGatewayAvailableSslOptions/default/ApplicationGatewaySslPredefinedPolicy/AppGwSslPolicy20150501"),
	// 	Name: to.Ptr("AppGwSslPolicy20150501"),
	// 	Properties: &armnetwork.ApplicationGatewaySSLPredefinedPolicyPropertiesFormat{
	// 		CipherSuites: []*armnetwork.ApplicationGatewaySSLCipherSuite{
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHERSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHERSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256GCMSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128GCMSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA384),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSECDHEECDSAWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA256),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES256CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITHAES128CBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSRSAWITH3DESEDECBCSHA),
	// 			to.Ptr(armnetwork.ApplicationGatewaySSLCipherSuiteTLSDHEDSSWITH3DESEDECBCSHA)},
	// 			MinProtocolVersion: to.Ptr(armnetwork.ApplicationGatewaySSLProtocolTLSv10),
	// 		},
	// 	}
}
